/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.option;

import cc.lechun.apiinvoke.bi.BIGenerateSceneInvoke;
import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.object.BeanUtils;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.scrm.dao.option.DictionaryDetailMapper;
import cc.lechun.scrm.entity.option.DictionaryDetailEntity;
import cc.lechun.scrm.entity.option.DictionaryDetailQueryVo;
import cc.lechun.scrm.entity.option.OptionDictionaryEntity;
import cc.lechun.scrm.entity.property.DicDataTypeEnum;
import cc.lechun.scrm.entity.property.DicTypeEnum;
import cc.lechun.scrm.entity.property.EventPropertyEntity;
import cc.lechun.scrm.iservice.event.EventInterface;
import cc.lechun.scrm.iservice.option.DictionaryDetailInterface;
import cc.lechun.scrm.iservice.option.OptionDictionaryInterface;
import cc.lechun.scrm.iservice.property.EventPropertyInterface;
import cc.lechun.scrm.iservice.property.PropertyInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictionaryDetailService
extends BaseService<DictionaryDetailEntity, Integer>
implements DictionaryDetailInterface {
    @Resource
    private DictionaryDetailMapper dictionaryDetailMapper;
    @Autowired
    private EventInterface eventInterface;
    @Autowired
    private EventPropertyInterface eventPropertyInterface;
    @Autowired
    PropertyInterface propertyInterface;
    @Autowired
    BIGenerateSceneInvoke biGenerateSceneInvoke;
    @Autowired
    OptionDictionaryInterface optionDictionaryInterface;

    @Override
    public BaseJsonVo buildDictionaryDetail(Integer dataType, Integer dicId, String propertyField, String tableName) {
        if (dicId == null) {
            // empty if block
        }
        String sql = "select DISTINCT " + dicId + " as dicId," + propertyField + " as dicKey," + propertyField + " as dicValue,null as parentDicKey from " + tableName + " where " + propertyField + " is not null";
        if (dataType != 2) {
            sql = sql + " and " + propertyField + "!=''";
        }
        ArrayList<DictionaryDetailEntity> dictionaryDetailEntities = new ArrayList<DictionaryDetailEntity>();
        String key = MD5.sign((String)("buildDictionaryDetail." + sql));
        this.redisCacheUtil.set(key, (Object)sql, Long.valueOf(600L));
        BaseJsonVo jsonVo = this.biGenerateSceneInvoke.selectData(key);
        if (jsonVo.isSuccess()) {
            for (Map map : (List)jsonVo.getValue()) {
                DictionaryDetailEntity dictionaryDetailEntity = new DictionaryDetailEntity();
                try {
                    dictionaryDetailEntity = (DictionaryDetailEntity)BeanUtils.mapToBean((Map)map, (Object)dictionaryDetailEntity);
                }
                catch (Exception e) {
                    dictionaryDetailEntity.setDicId(Integer.valueOf(map.get("dicId").toString()));
                    dictionaryDetailEntity.setDicValue(map.get("dicValue").toString());
                    dictionaryDetailEntity.setDicKey(map.get("dicKey").toString());
                }
                dictionaryDetailEntities.add(dictionaryDetailEntity);
            }
        } else {
            this.logger.error("" + jsonVo.getMessage());
        }
        DictionaryDetailEntity del = new DictionaryDetailEntity();
        del.setDicId(dicId);
        List lst = this.getList(del);
        Serializable[] counts = lst.stream().map(c -> c.getId()).collect(Collectors.toList()).toArray(new Integer[lst.size()]);
        int j = 0;
        int i = 0;
        if (counts.length > 0 && dictionaryDetailEntities.size() > 0) {
            j = this.dictionaryDetailMapper.batchDelete(counts);
        }
        if (dictionaryDetailEntities.size() > 0) {
            i = this.dictionaryDetailMapper.batchInsert(dictionaryDetailEntities);
        }
        this.logger.info("\u6267\u884c\u6210\u529f,key:" + key + "\uff0c\u67e5\u8be2:" + jsonVo.isSuccess() + "\uff0c\u8f6c\u6362\uff1a" + dictionaryDetailEntities.size() + "\u6761,\u5220\u9664" + j + "\u6761\uff0c\u63d2\u5165" + i + "\u6761");
        return BaseJsonVo.success((Object)("\u6267\u884c\u6210\u529f,\u5220\u9664" + j + "\u6761\uff0c\u63d2\u5165" + i + "\u6761"));
    }

    @Override
    public List<DictionaryDetailEntity> getListVo(DictionaryDetailQueryVo dictionaryDetailQueryVo) {
        EventPropertyEntity eventPropertyEntity = (EventPropertyEntity)this.eventPropertyInterface.selectByPrimaryKey(dictionaryDetailQueryVo.getDicId());
        if (eventPropertyEntity.getDicType().intValue() == DicTypeEnum.dic_type.getValue() && eventPropertyEntity.getDicDataType().intValue() == DicDataTypeEnum.soure_dic.getValue()) {
            OptionDictionaryEntity dictionaryEntity = (OptionDictionaryEntity)this.optionDictionaryInterface.selectByPrimaryKey(dictionaryDetailQueryVo.getDicId());
            String tempSql = dictionaryEntity.getDicUpdateSql();
            tempSql = StringUtils.isNotEmpty((String)dictionaryDetailQueryVo.getDicValue()) ? "select * from (" + tempSql + ") T where T.DIC_VALUE like '%" + dictionaryDetailQueryVo.getDicValue() + "%' limit " + (dictionaryDetailQueryVo.getPageNum() - 1) * dictionaryDetailQueryVo.getPageSize() + "," + dictionaryDetailQueryVo.getPageSize() + "" : tempSql + " limit " + (dictionaryDetailQueryVo.getPageNum() - 1) * dictionaryDetailQueryVo.getPageSize() + "," + dictionaryDetailQueryVo.getPageSize() + "";
            return this.dictionaryDetailMapper.getDictionaryDetailList(tempSql);
        }
        this.logger.info("\u5c5e\u6027:{}\u4e0d\u652f\u6301\u5b57\u5178", (Object)eventPropertyEntity.getEventPropertyId());
        return new ArrayList<DictionaryDetailEntity>();
    }

    @Override
    public List<DictionaryDetailEntity> getList(DictionaryDetailQueryVo dictionaryDetailQueryVo) {
        List list;
        DictionaryDetailEntity query = new DictionaryDetailEntity();
        org.springframework.beans.BeanUtils.copyProperties((Object)dictionaryDetailQueryVo, (Object)query);
        if (StringUtils.isNotEmpty((String)dictionaryDetailQueryVo.getDicKey())) {
            query.setDicKey(SqlUtils.sqlLike((String)dictionaryDetailQueryVo.getDicKey(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        if (StringUtils.isNotEmpty((String)dictionaryDetailQueryVo.getDicValue())) {
            query.setDicValue(SqlUtils.sqlLike((String)dictionaryDetailQueryVo.getDicValue(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.dictionaryDetailMapper.getList(query)))) {
            list = list.stream().sorted(Comparator.comparing(DictionaryDetailEntity::getDicKey)).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    public BaseJsonVo save(DictionaryDetailEntity dictionaryDetailEntity) {
        if (dictionaryDetailEntity.getId() == null || dictionaryDetailEntity.getId() == 0) {
            DictionaryDetailEntity query = new DictionaryDetailEntity();
            query.setDicId(dictionaryDetailEntity.getDicId());
            query.setDicKey(dictionaryDetailEntity.getDicKey());
            DictionaryDetailEntity result = (DictionaryDetailEntity)this.dictionaryDetailMapper.getSingle(query);
            if (result != null) {
                return BaseJsonVo.error((String)"\u5b57\u5178key\u91cd\u590d");
            }
            this.dictionaryDetailMapper.insert(dictionaryDetailEntity);
        } else {
            this.dictionaryDetailMapper.updateByPrimaryKeySelective(dictionaryDetailEntity);
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }
}

