/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.option;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.scrm.dao.option.OptionDictionaryMapper;
import cc.lechun.scrm.entity.event.EventEntity;
import cc.lechun.scrm.entity.option.OptionDictionaryEntity;
import cc.lechun.scrm.entity.property.DicTypeEnum;
import cc.lechun.scrm.entity.property.EventPropertyEntity;
import cc.lechun.scrm.entity.property.PropertyEntity;
import cc.lechun.scrm.iservice.event.EventInterface;
import cc.lechun.scrm.iservice.option.DictionaryDetailInterface;
import cc.lechun.scrm.iservice.option.OptionDictionaryInterface;
import cc.lechun.scrm.iservice.property.EventPropertyInterface;
import cc.lechun.scrm.iservice.property.PropertyInterface;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class OptionDictionaryService
extends BaseService<OptionDictionaryEntity, Integer>
implements OptionDictionaryInterface {
    @Resource
    private OptionDictionaryMapper optionDictionaryMapper;
    @Lazy
    @Autowired
    private EventPropertyInterface eventPropertyInterface;
    @Lazy
    @Autowired
    private PropertyInterface propertyInterface;
    @Lazy
    @Autowired
    private EventInterface eventInterface;
    @Lazy
    @Autowired
    private DictionaryDetailInterface dictionaryDetailInterface;

    @Override
    public BaseJsonVo buildDictionary(Integer eventPropertyId) {
        EventPropertyEntity search = new EventPropertyEntity();
        search.setDicType(DicTypeEnum.dic_type.getValue());
        if (eventPropertyId != null) {
            search.setEventPropertyId(eventPropertyId);
        }
        List eventPropertyEntities = this.eventPropertyInterface.getList(search);
        String tableName = "t_scrm_option_dic_detail";
        String fieldsName = "DIC_KEY,DIC_VALUE,PARENT_DIC_KEY";
        for (EventPropertyEntity ep : eventPropertyEntities) {
            OptionDictionaryEntity dictionaryEntity = (OptionDictionaryEntity)this.optionDictionaryMapper.selectByPrimaryKey(ep.getEventPropertyId());
            if (dictionaryEntity != null && Integer.valueOf(0).equals(dictionaryEntity.getDicType())) continue;
            EventEntity eventEntity = (EventEntity)this.eventInterface.selectByPrimaryKey(ep.getEventId(), 0L);
            PropertyEntity propertyEntity = (PropertyEntity)this.propertyInterface.selectByPrimaryKey(ep.getPropertyId(), 0L);
            if (eventEntity == null || propertyEntity == null || "Date".equals(propertyEntity.getProperytDataType()) || "DateTime".equals(propertyEntity.getProperytDataType())) continue;
            if (Integer.valueOf(2).equals(ep.getDicDataType())) {
                tableName = eventEntity.getEventDataBase() + "." + eventEntity.getEventTableName();
                fieldsName = propertyEntity.getPropertyField() + " as DIC_KEY," + propertyEntity.getPropertyField() + " as DIC_VALUE,null as PARENT_DIC_KEY";
            }
            Integer dataType = "Number".equals(propertyEntity.getProperytDataType()) ? 2 : 1;
            if (dictionaryEntity == null) {
                dictionaryEntity = new OptionDictionaryEntity();
            }
            dictionaryEntity.setId(ep.getEventPropertyId());
            dictionaryEntity.setDicName(propertyEntity.getPropertyName());
            dictionaryEntity.setDicKeyType(dataType);
            String sql = "select DISTINCT " + fieldsName + " from " + tableName + " where 1=1 ";
            if (Integer.valueOf(2).equals(ep.getDicDataType())) {
                sql = sql + " and " + propertyEntity.getPropertyField() + " is not null ";
                if (dataType != 2) {
                    sql = sql + " and " + propertyEntity.getPropertyField() + "!=''";
                }
            } else {
                sql = sql + " and DIC_ID=" + dictionaryEntity.getId();
            }
            dictionaryEntity.setDicUpdateSql(sql + " order by DIC_KEY");
            if (dictionaryEntity.getCreateTime() == null) {
                dictionaryEntity.setCreateTime(new Date());
            }
            if (dictionaryEntity.getDicType() == null) {
                dictionaryEntity.setDicType(1);
            }
            dictionaryEntity.setUpdateTime(new Date());
            int i = this.optionDictionaryMapper.insertOrUpdate(dictionaryEntity);
            if (i <= 0) continue;
            BaseJsonVo baseJsonVo = this.dictionaryDetailInterface.buildDictionaryDetail(dataType, ep.getEventPropertyId(), propertyEntity.getPropertyField(), eventEntity.getEventDataBase() + "." + eventEntity.getEventTableName());
        }
        return BaseJsonVo.success((Object)"\u5b57\u5178\u6784\u5efa\u5b8c\u6210");
    }

    @Override
    public BaseJsonVo save(OptionDictionaryEntity optionDictionaryEntity) {
        if (optionDictionaryEntity.getId() == null || optionDictionaryEntity.getId() == 0) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u5c5e\u6027");
        }
        if (this.optionDictionaryMapper.exists(optionDictionaryEntity.getId()) > 0) {
            optionDictionaryEntity.setUpdateTime(DateUtils.now());
            this.optionDictionaryMapper.updateByPrimaryKeySelective(optionDictionaryEntity);
        } else {
            optionDictionaryEntity.setCreateTime(DateUtils.now());
            this.optionDictionaryMapper.insert(optionDictionaryEntity);
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }
}

