/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.property;

import cc.lechun.common.enums.common.StatusEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.scrm.dao.event.EventMapper;
import cc.lechun.scrm.dao.property.DataTypeFunMapper;
import cc.lechun.scrm.dao.property.EventPropertyMapper;
import cc.lechun.scrm.dao.property.OperateTypeMapper;
import cc.lechun.scrm.dao.property.PropertyMapper;
import cc.lechun.scrm.entity.property.DataTypeFunEntity;
import cc.lechun.scrm.entity.property.DataTypeFunItem;
import cc.lechun.scrm.entity.property.DicDataTypeEnum;
import cc.lechun.scrm.entity.property.DicTypeEnum;
import cc.lechun.scrm.entity.property.EventPropertyEntity;
import cc.lechun.scrm.entity.property.EventPropertyVo;
import cc.lechun.scrm.entity.property.OperateTypeEntity;
import cc.lechun.scrm.entity.property.OperateTypeItem;
import cc.lechun.scrm.entity.property.PropertyClassEnum;
import cc.lechun.scrm.entity.property.PropertyEntity;
import cc.lechun.scrm.iservice.property.EventPropertyInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class EventPropertyService
extends BaseService<EventPropertyEntity, Integer>
implements EventPropertyInterface {
    @Resource
    private EventPropertyMapper eventPropertyMapper;
    @Resource
    private EventMapper eventMapper;
    @Resource
    private PropertyMapper propertyMapper;
    @Resource
    private DataTypeFunMapper dataTypeFunMapper;
    @Resource
    private OperateTypeMapper operateTypeMapper;

    @Override
    public BaseJsonVo<EventPropertyVo> getEventPropertyList(EventPropertyEntity eventPropertyEntity) {
        List<Object> result = new ArrayList();
        List list = this.getList(eventPropertyEntity, 0L);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            result = list.stream().sorted((p1, p2) -> p1.getSort() - p2.getSort()).map(item -> {
                EventPropertyVo eventPropertyVo = new EventPropertyVo();
                BeanUtils.copyProperties((Object)item, (Object)eventPropertyVo);
                eventPropertyVo.setStatusName(Objects.equals(item.getStatus(), 1) ? StatusEnum.STATUS_OK.getName() : StatusEnum.STATUS_FAIL.getName());
                eventPropertyVo.setDicTypeName(DicTypeEnum.getName(item.getDicType()));
                PropertyEntity propertyEntity = (PropertyEntity)this.propertyMapper.selectByPrimaryKey(item.getPropertyId());
                eventPropertyVo.setPropertyName(propertyEntity != null ? propertyEntity.getPropertyName() : "");
                eventPropertyVo.setPropertyClass(propertyEntity.getPropertyClass());
                eventPropertyVo.setPropertyClassName(PropertyClassEnum.getName(propertyEntity.getPropertyClass()));
                eventPropertyVo.setProperytDataType(propertyEntity.getProperytDataType());
                OperateTypeEntity operateTypeEntity = new OperateTypeEntity();
                operateTypeEntity.setDataType(propertyEntity.getProperytDataType());
                List operateTypeEntityList = this.operateTypeMapper.getList(operateTypeEntity);
                if (CollectionUtils.isNotEmpty((Collection)operateTypeEntityList)) {
                    ArrayList<OperateTypeItem> operateTypeItemList = new ArrayList();
                    operateTypeItemList = operateTypeEntityList.stream().map(operate -> {
                        OperateTypeItem operateTypeItem = new OperateTypeItem();
                        BeanUtils.copyProperties((Object)operate, (Object)operateTypeItem);
                        return operateTypeItem;
                    }).collect(Collectors.toList());
                    eventPropertyVo.setOperateTypeItemList(operateTypeItemList);
                }
                DataTypeFunEntity dataTypeFunEntity = new DataTypeFunEntity();
                operateTypeEntity.setDataType(propertyEntity.getProperytDataType());
                List dataTypeFunEntityList = this.dataTypeFunMapper.getList(dataTypeFunEntity);
                if (CollectionUtils.isNotEmpty((Collection)dataTypeFunEntityList)) {
                    ArrayList<DataTypeFunItem> operateTypeItemList = new ArrayList();
                    operateTypeItemList = dataTypeFunEntityList.stream().map(operate -> {
                        DataTypeFunItem dataTypeFunItem = new DataTypeFunItem();
                        BeanUtils.copyProperties((Object)operate, (Object)dataTypeFunItem);
                        return dataTypeFunItem;
                    }).collect(Collectors.toList());
                    eventPropertyVo.setDataTypeFunItemList(operateTypeItemList);
                }
                return eventPropertyVo;
            }).collect(Collectors.toList());
        }
        return BaseJsonVo.success(result);
    }

    @Override
    public BaseJsonVo saveEventProperty(EventPropertyEntity eventPropertyEntity) {
        this.logger.info("{}", (Object)JsonUtils.toJson((Object)eventPropertyEntity, (boolean)false));
        if (eventPropertyEntity.getEventPropertyId() == null || eventPropertyEntity.getEventPropertyId() == 0) {
            eventPropertyEntity.setEventPropertyId(null);
            eventPropertyEntity.setCreateTime(DateUtils.now());
            EventPropertyEntity query = new EventPropertyEntity();
            query.setEventId(eventPropertyEntity.getEventId());
            query.setPropertyId(eventPropertyEntity.getPropertyId());
            List tempList = this.eventPropertyMapper.getList(query);
            if (CollectionUtils.isNotEmpty((Collection)tempList)) {
                return BaseJsonVo.error((String)"\u4e8b\u4ef6\u5c5e\u6027\u5df2\u5b58\u5728");
            }
            if (Objects.equals(DicTypeEnum.dic_type.getValue(), eventPropertyEntity.getDicType())) {
                eventPropertyEntity.setDicDataType(DicDataTypeEnum.soure_dic.getValue());
            } else {
                eventPropertyEntity.setDicDataType(DicDataTypeEnum.soure_input.getValue());
            }
            eventPropertyEntity.setStatus(1);
            this.eventPropertyMapper.insert(eventPropertyEntity);
        } else {
            if (Objects.equals(DicTypeEnum.dic_type.getValue(), eventPropertyEntity.getDicType())) {
                eventPropertyEntity.setDicDataType(DicDataTypeEnum.soure_dic.getValue());
            } else {
                eventPropertyEntity.setDicDataType(DicDataTypeEnum.soure_input.getValue());
            }
            this.eventPropertyMapper.updateByPrimaryKeySelective(eventPropertyEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo changeStatus(EventPropertyEntity eventPropertyEntity) {
        EventPropertyEntity update = new EventPropertyEntity();
        update.setStatus(eventPropertyEntity.getStatus());
        update.setEventPropertyId(eventPropertyEntity.getEventPropertyId());
        return this.eventPropertyMapper.updateByPrimaryKeySelective(update) > 0 ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }
}

