/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.property;

import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.scrm.dao.event.EventMapper;
import cc.lechun.scrm.dao.property.EventPropertyMapper;
import cc.lechun.scrm.dao.property.PropertyMapper;
import cc.lechun.scrm.dao.scene.SceneEventPropertyMapper;
import cc.lechun.scrm.entity.property.PropertyClassEnum;
import cc.lechun.scrm.entity.property.PropertyEntity;
import cc.lechun.scrm.entity.property.PropertyQueryVo;
import cc.lechun.scrm.entity.property.PropertyTypeEnum;
import cc.lechun.scrm.entity.property.PropertyVo;
import cc.lechun.scrm.entity.scene.SceneEventPropertyEntity;
import cc.lechun.scrm.iservice.property.PropertyInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class PropertyService
extends BaseService<PropertyEntity, Integer>
implements PropertyInterface {
    @Resource
    private PropertyMapper propertyMapper;
    @Resource
    private EventMapper eventMapper;
    @Resource
    private EventPropertyMapper eventPropertyMapper;
    @Resource
    private SceneEventPropertyMapper sceneEventPropertyMapper;

    @Override
    public BaseJsonVo getPropertyList(PropertyEntity propertyEntity) {
        List<Object> result = new ArrayList();
        List list = this.getList(propertyEntity, 0L);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            result = list.stream().map(item -> {
                PropertyVo propertyVo = new PropertyVo();
                BeanUtils.copyProperties((Object)item, (Object)propertyVo);
                propertyVo.setPropertyClassName(PropertyClassEnum.getName(item.getPropertyClass()));
                propertyVo.setPropertyTypeName(PropertyTypeEnum.getName(item.getPropertyType()));
                return propertyVo;
            }).collect(Collectors.toList());
        }
        return BaseJsonVo.success(result);
    }

    @Override
    public PageInfo getPropertyList(PropertyQueryVo propertyQueryVo) {
        Page page = PageHelper.startPage((int)propertyQueryVo.getCurrentPage(), (int)propertyQueryVo.getPageSize());
        if (StringUtils.isEmpty((String)propertyQueryVo.getPropertyName())) {
            propertyQueryVo.setPropertyName(null);
        } else {
            propertyQueryVo.setPropertyName(SqlUtils.sqlLike((String)propertyQueryVo.getPropertyName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        if (StringUtils.isEmpty((String)propertyQueryVo.getPropertyField())) {
            propertyQueryVo.setPropertyField(null);
        } else {
            propertyQueryVo.setPropertyField(SqlUtils.sqlLike((String)propertyQueryVo.getPropertyField(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        if (Objects.equals(propertyQueryVo.getPropertyType(), 0)) {
            propertyQueryVo.setPropertyType(PropertyTypeEnum.virtual_property.getValue());
        }
        PropertyEntity propertyEntity = new PropertyEntity();
        BeanUtils.copyProperties((Object)propertyQueryVo, (Object)propertyEntity);
        page.setOrderBy(" CREATE_TIME DESC ");
        List list = this.propertyMapper.getList(propertyEntity);
        List<Object> propertyVoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            propertyVoList = list.stream().map(item -> {
                PropertyVo propertyVo = new PropertyVo();
                BeanUtils.copyProperties((Object)item, (Object)propertyVo);
                propertyVo.setPropertyClassName(PropertyClassEnum.getName(item.getPropertyClass()));
                propertyVo.setPropertyTypeName(PropertyTypeEnum.getName(item.getPropertyType()));
                return propertyVo;
            }).collect(Collectors.toList());
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(propertyVoList);
        return pg;
    }

    @Override
    public BaseJsonVo saveProperty(PropertyEntity propertyEntity) {
        if (propertyEntity.getPropertyId() == null || propertyEntity.getPropertyId() == 0) {
            propertyEntity.setPropertyId(null);
            propertyEntity.setCreateTime(DateUtils.now());
            PropertyEntity query = new PropertyEntity();
            query.setPropertyName(propertyEntity.getPropertyName());
            query.setAppId(propertyEntity.getAppId());
            List tempList = this.getList(query, 0L);
            if (CollectionUtils.isNotEmpty((Collection)tempList)) {
                return BaseJsonVo.error((String)"\u5c5e\u6027\u91cd\u540d");
            }
            this.propertyMapper.insert(propertyEntity);
        } else {
            PropertyEntity oldEventGroup = (PropertyEntity)this.selectByPrimaryKey(propertyEntity.getPropertyId());
            if (!Objects.equals(oldEventGroup.getPropertyName(), propertyEntity.getPropertyName())) {
                PropertyEntity query = new PropertyEntity();
                query.setPropertyName(propertyEntity.getPropertyName());
                List tempList = this.getList(query, 0L);
                if (CollectionUtils.isNotEmpty((Collection)tempList)) {
                    return BaseJsonVo.error((String)"\u5c5e\u6027\u91cd\u540d");
                }
            }
            this.propertyMapper.updateByPrimaryKeySelective(propertyEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo deleteProperty(Integer propertyId) {
        SceneEventPropertyEntity sceneEventPropertyEntity = new SceneEventPropertyEntity();
        sceneEventPropertyEntity.setPropertyId(propertyId);
        List list = this.sceneEventPropertyMapper.getList(sceneEventPropertyEntity);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return BaseJsonVo.error((String)"\u5c5e\u6027\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u88ab\u5220\u9664");
        }
        return this.deleteByPrimaryKey(propertyId) > 0 ? BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f") : BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }
}

