/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.route;

import cc.lechun.apiinvoke.bi.BIGenerateSceneInvoke;
import cc.lechun.apiinvoke.bi.BIRouteCustomerInvoke;
import cc.lechun.apiinvoke.sales.ClueCleanInvoke;
import cc.lechun.common.dingding.DingdingUtils;
import cc.lechun.framework.common.enums.common.EnvironmentEnum;
import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.distribution.DistributorInterface;
import cc.lechun.mall.iservice.distribution.DistributorQiyeweixinExternalContactInterface;
import cc.lechun.mall.iservice.user.MallUserInterface;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import cc.lechun.scrm.dao.route.RouteCustomerMapper;
import cc.lechun.scrm.entity.AppEnum;
import cc.lechun.scrm.entity.calendar.CalendarEntity;
import cc.lechun.scrm.entity.material.MaterialEntity;
import cc.lechun.scrm.entity.material.PushTypeEnum;
import cc.lechun.scrm.entity.route.RouteCustomerEntity;
import cc.lechun.scrm.entity.route.RouteCustomerEntityRuleVo;
import cc.lechun.scrm.entity.route.RouteCustomerEntitySearchVo;
import cc.lechun.scrm.entity.route.RouteCustomerEntityVo;
import cc.lechun.scrm.entity.route.RouteCustomerQwCountVo;
import cc.lechun.scrm.entity.route.RouteCustomerRuleVo;
import cc.lechun.scrm.entity.route.RouteLinkEntity;
import cc.lechun.scrm.entity.route.RouteRecordEntity;
import cc.lechun.scrm.entity.route.SopInherit;
import cc.lechun.scrm.entity.route.UnPushCustomerInfo;
import cc.lechun.scrm.entity.route.UserOrderTypeEnum;
import cc.lechun.scrm.entity.scene.SceneEntity;
import cc.lechun.scrm.iservice.calendar.CalendarInterface;
import cc.lechun.scrm.iservice.material.MaterialInterface;
import cc.lechun.scrm.iservice.material.MaterialRuleInterface;
import cc.lechun.scrm.iservice.material.MaterialTraceInterface;
import cc.lechun.scrm.iservice.route.RouteCustomerInterface;
import cc.lechun.scrm.iservice.route.RouteInterface;
import cc.lechun.scrm.iservice.route.RouteLinkInterface;
import cc.lechun.scrm.iservice.route.RouteRecordInterface;
import cc.lechun.scrm.iservice.scene.SceneInterface;
import cc.lechun.scrm.iservice.variable.VariableInterface;
import cc.lechun.scrm.service.material.MaterialMediaService;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import weixin.popular.api.qy.SendMsgAPI;
import weixin.popular.api.qy.SendWelcomeAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.qy.QySendMsg;
import weixin.popular.bean.qy.QySendMsgAttachmentsFile;
import weixin.popular.bean.qy.QySendMsgAttachmentsFileBody;
import weixin.popular.bean.qy.QySendMsgAttachmentsImage;
import weixin.popular.bean.qy.QySendMsgAttachmentsImageBody;
import weixin.popular.bean.qy.QySendMsgAttachmentsLink;
import weixin.popular.bean.qy.QySendMsgAttachmentsLinkBody;
import weixin.popular.bean.qy.QySendMsgAttachmentsMini;
import weixin.popular.bean.qy.QySendMsgAttachmentsMiniBody;
import weixin.popular.bean.qy.QySendMsgAttachmentsVideo;
import weixin.popular.bean.qy.QySendMsgAttachmentsVideoBody;
import weixin.popular.bean.qy.QySendMsgAttachmentsVoice;
import weixin.popular.bean.qy.QySendMsgAttachmentsVoiceBody;
import weixin.popular.bean.qy.QySendMsgText;
import weixin.popular.bean.qy.SendMsgResult;
import weixin.popular.bean.qy.welcome.WelcomeInfo;

@Service
public class RouteCustomerService
extends BaseService<RouteCustomerEntity, Integer>
implements RouteCustomerInterface {
    @Resource
    private RouteCustomerMapper routeCustomerMapper;
    @Lazy
    @Autowired
    private RouteInterface routeInterface;
    @Lazy
    @Autowired
    private MaterialInterface materialInterface;
    @Autowired
    private BIGenerateSceneInvoke biGenerateSceneInvoke;
    @Value(value="${lechun.environment}")
    private String environment;
    @Lazy
    @Autowired
    private SceneInterface sceneInterface;
    @Lazy
    @Autowired
    private VariableInterface variableInterface;
    @Lazy
    @Autowired
    private MaterialRuleInterface materialRuleInterface;
    @Lazy
    @Autowired
    private CalendarInterface calendarInterface;
    @Autowired
    private WeiXinBaseAccessToken weiXinBaseAccessToken;
    @Autowired
    private MaterialTraceInterface materialTraceInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Lazy
    @Autowired
    private RouteLinkInterface routeLinkInterface;
    @Autowired
    private SysUserInterface userInterface;
    @Autowired
    private RouteRecordInterface routeRecordInterface;
    @Autowired
    private MaterialMediaService materialMediaService;
    @Lazy
    @Autowired
    private DistributorInterface distributorInterface;
    @Autowired
    private MallUserInterface mallUserInterface;
    @Autowired
    private BIRouteCustomerInvoke biRouteCustomerInvoke;
    @Autowired
    @Lazy
    private MallVipInterface vipService;
    @Autowired
    private ClueCleanInvoke clueCleanInvoke;
    @Lazy
    @Autowired
    DistributorQiyeweixinExternalContactInterface distributorQiyeweixinExternalContactInterface;
    private Integer limitCount = 2000;
    @Autowired
    DingdingUtils dingdingUtils;

    @Override
    public BaseJsonVo saveRouteCustomer(String externalUserID, String customerId, String state, String welcomeCode, String userID) {
        Map map;
        this.logger.info("externalUserID={},customerId={},state={},welcomeCode={},userID={}", new Object[]{externalUserID, customerId, state, welcomeCode, userID});
        if (StringUtils.isEmpty((String)state)) {
            this.logger.info("\u7528\u6237:{},\u5ba2\u670d:{}\u6e20\u9053\u6d3b\u7801\u4e3a\u7a7a", (Object)customerId, (Object)userID);
            return BaseJsonVo.success((Object)"");
        }
        if (state.contains("_")) {
            state = state.split("_")[0];
        }
        if ((map = this.materialInterface.getMaterialEntity(state)) == null) {
            this.logger.error("\u6d3b\u7801\u6e20\u9053:{}\u672a\u5173\u8054\u7d20\u6750", (Object)state);
            return BaseJsonVo.error((String)"\u6d3b\u7801\u672a\u5173\u8054\u7d20\u6750");
        }
        this.logger.info("\u67e5\u627emap:{}", (Object)JsonUtils.toJson((Object)map, (boolean)false));
        RouteCustomerEntity routeCustomerEntity = new RouteCustomerEntity();
        routeCustomerEntity.setKefuUseStatus(2);
        routeCustomerEntity.setCreateDate(DateUtils.getDateFromString((String)DateUtils.formatDate((Date)DateUtils.now(), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd"));
        routeCustomerEntity.setCreateTime(DateUtils.now());
        routeCustomerEntity.setCustomerId(customerId);
        CustomerEntity customerEntity = this.customerInterface.getCustomer(customerId);
        map.put("pushText", map.get("pushText").toString().replace("${routeCustomer.nick_name}", customerEntity.getNickName()));
        map.put("keyword", map.get("keyword").toString().replace("${routeCustomer.nick_name}", customerEntity.getNickName()));
        this.logger.info("\u67e5\u627e\u7528\u6237\u4fe1\u606f:{}", (Object)customerId);
        routeCustomerEntity.setAvatar(customerEntity.getHeadImageUrl());
        routeCustomerEntity.setExternalUserid(externalUserID);
        routeCustomerEntity.setFactPushText(map.get("pushText").toString());
        routeCustomerEntity.setPushText(map.get("pushText").toString());
        routeCustomerEntity.setFromDate(DateUtils.getDateFromString((String)DateUtils.formatDate((Date)DateUtils.now(), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd"));
        routeCustomerEntity.setKefuUseTime(DateUtils.now());
        routeCustomerEntity.setMaterialCode(map.get("materialCode").toString());
        routeCustomerEntity.setMaterialId(Integer.valueOf(map.get("id").toString()));
        MaterialEntity materialEntity = (MaterialEntity)this.materialInterface.selectByPrimaryKey(Integer.valueOf(map.get("id").toString()));
        this.logger.info("\u67e5\u627e\u7d20\u6750\u4fe1\u606f:{}", (Object)JsonUtils.toJson((Object)materialEntity, (boolean)false));
        routeCustomerEntity.setMaterialParentCode(materialEntity.getParentMaterialCode());
        routeCustomerEntity.setNickName(customerEntity.getNickName());
        routeCustomerEntity.setPhone(customerEntity.getMobile());
        RouteLinkEntity queryLink = new RouteLinkEntity();
        queryLink.setActionDetailId(Integer.valueOf(map.get("id").toString()));
        queryLink.setActionType(3);
        RouteLinkEntity routeLinkEntity = (RouteLinkEntity)this.routeLinkInterface.getSingle(queryLink, 0L);
        this.logger.info("\u67e5\u627e\u7d20\u6750\u5173\u8054\u65c5\u7a0b\u4fe1\u606f:{}", (Object)JsonUtils.toJson((Object)routeLinkEntity, (boolean)false));
        routeCustomerEntity.setRouteId(routeLinkEntity.getRouteId());
        routeCustomerEntity.setRouteLinkId(routeLinkEntity.getId());
        MallUserEntity queryUser = new MallUserEntity();
        queryUser.setQyWeixinUserid(userID);
        MallUserEntity mallUserEntity = this.userInterface.getSingle(queryUser);
        this.logger.info("\u67e5\u627e\u4f01\u5fae\u7528\u6237\u4fe1\u606f:{}", (Object)JsonUtils.toJson((Object)mallUserEntity, (boolean)false));
        routeCustomerEntity.setQwUserid(mallUserEntity.getUserId());
        routeCustomerEntity.setQyWeixinUserid(userID);
        routeCustomerEntity.setPushText1(map.get("keyword").toString());
        RouteRecordEntity recordQuery = new RouteRecordEntity();
        recordQuery.setRouteId(routeLinkEntity.getRouteId());
        recordQuery.setCreateDate(new Date());
        recordQuery.setCreateTime(new Date());
        RouteRecordEntity recordEntity = (RouteRecordEntity)this.routeRecordInterface.getSingle(recordQuery);
        if (recordEntity != null) {
            routeCustomerEntity.setRouteRecordId(recordEntity.getId());
        }
        queryLink = new RouteLinkEntity();
        queryLink.setActionType(1);
        queryLink.setRouteId(routeLinkEntity.getRouteId());
        routeLinkEntity = (RouteLinkEntity)this.routeLinkInterface.getSingle(queryLink, 0L);
        this.logger.info("\u67e5\u627e\u7d20\u6750\u5173\u8054\u7fa4\u7ec4\u4fe1\u606f:{}", (Object)JsonUtils.toJson((Object)routeLinkEntity, (boolean)false));
        routeCustomerEntity.setSceneId(routeLinkEntity.getActionDetailId());
        routeCustomerEntity.setUserLevel(customerEntity.getLevel());
        this.logger.info("\u5199\u7528\u6237\u63a8\u9001\u8bb0\u5f55:{}", (Object)JsonUtils.toJson((Object)routeCustomerEntity, (boolean)false));
        this.routeCustomerMapper.insertSelective(routeCustomerEntity);
        this.pushWelcome(welcomeCode, routeCustomerEntity, map);
        return BaseJsonVo.success((Object)"");
    }

    private void pushWelcome(String welcome, RouteCustomerEntity routeCustomerEntity, Map<String, Object> matermap) {
        this.logger.info("\u5f00\u59cb\u7ed9\u7528\u6237:{}\u63a8\u9001\u6b22\u8fce\u8bed:{}", (Object)routeCustomerEntity.getCustomerId(), (Object)welcome);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)welcome)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("welcome_code", welcome);
            HashMap<String, String> content = new HashMap<String, String>();
            if ("text".equals(matermap.get("materialType"))) {
                BaseJsonVo jsonVo = this.variableInterface.replaceVariable(routeCustomerEntity.getMaterialId(), routeCustomerEntity.getSceneId(), routeCustomerEntity.getRouteId(), routeCustomerEntity.getRouteRecordId(), "pushText");
                this.logger.info("\u7ed9\u7528\u6237:{}\u63a8\u9001\u6b22\u8fce\u8bed,\u66ff\u6362\u53d8\u91cf\uff1a{}", (Object)routeCustomerEntity.getCustomerId(), (Object)JsonUtils.toJson((Object)jsonVo, (boolean)false));
                content.put("content", routeCustomerEntity.getPushText());
                map.put("text", content);
                this.logger.info("\u7ed9\u7528\u6237:{}\u63a8\u9001\u6b22\u8fce\u8bed:{}", (Object)routeCustomerEntity.getCustomerId(), (Object)JsonUtils.toJson(map, (boolean)false));
                String accessToken = this.weiXinBaseAccessToken.getQiYeAccessTokenValueByPlatformId(7);
                try {
                    WelcomeInfo welcomeInfo = new WelcomeInfo();
                    welcomeInfo.setWelcome_code(welcome);
                    WelcomeInfo.Text text = new WelcomeInfo.Text();
                    text.setContent(routeCustomerEntity.getPushText());
                    welcomeInfo.setText(text);
                    BaseResult baseResult = SendWelcomeAPI.sendWelcomeMsg((String)accessToken, (WelcomeInfo)welcomeInfo);
                    this.logger.info("\u7528\u6237:{},\u4f01\u5fae:{}\u6b22\u8fce\u8bed\u63a8\u9001:{}", new Object[]{routeCustomerEntity.getCustomerId(), routeCustomerEntity.getQwUserid(), baseResult.toString()});
                }
                catch (Exception e) {
                    this.logger.error("\u7528\u6237:{}\u63a8\u9001\u6b22\u8fce\u8bed\u5931\u8d25:", (Object)routeCustomerEntity.getCustomerId(), (Object)e);
                }
            }
        }
    }

    @Override
    public BaseJsonVo pushAutoMessage(Date date) {
        List<AppEnum> appEnumList = AppEnum.getList();
        Date today = DateUtils.getDateFromString((String)DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
        for (AppEnum app : appEnumList) {
            BaseJsonVo baseJsonVo = this.calendarInterface.getQwUser(app.getValue());
            MaterialEntity query = new MaterialEntity();
            query.setPushType(PushTypeEnum.AUTO_PUSH.getValue());
            query.setStatus(1);
            query.setAppId(app.getValue());
            List materialEntityList = this.materialInterface.getList(query, 0L);
            this.logger.info("\u81ea\u52a8\u63a8\u9001\u7d20\u6750:{}", (Object)JsonUtils.toJson((Object)materialEntityList, (boolean)false));
            if (!CollectionUtils.isNotEmpty((Collection)materialEntityList)) continue;
            materialEntityList.forEach(materialEntity -> this.extracted(today, (BaseJsonVo<List<Map<String, String>>>)baseJsonVo, (MaterialEntity)materialEntity));
        }
        return BaseJsonVo.success((Object)"");
    }

    private void extracted(Date date, BaseJsonVo<List<Map<String, String>>> baseJsonVo, MaterialEntity materialEntity) {
        Date now;
        Date disableTime;
        Map map = this.materialInterface.getMaterialWithType(materialEntity.getId());
        if ("text".equals(map.get("materialType")) && (!map.containsKey("pushText") || map.get("pushText").toString().contains("${"))) {
            this.logger.info("\u7d20\u6750:{}\u4e2d\u4e0d\u5305\u542b\u6587\u6848\u6216\u6587\u6848\u4e2d\u5305\u542b\u53d8\u91cf", (Object)materialEntity.toString());
            return;
        }
        if (map.containsKey("mediaType") && !Objects.equals(map.getOrDefault("mediaType", ""), "link") && ((disableTime = (Date)map.get("disableTime")).before(now = DateUtils.now()) || DateUtils.getDateDiffSecond((Date)now, (Date)disableTime) < 120L)) {
            BaseJsonVo<String> reUploadRst = this.materialInterface.reUploadToQW(materialEntity.getId());
            if (!reUploadRst.isSuccess()) {
                this.logger.error("pushAutoMessage\u5f02\u5e38\uff0c\u4e34\u65f6\u7d20\u6750\u91cd\u65b0\u4e0a\u4f20\u5931\u8d25\uff0cmaterialId:{}", (Object)materialEntity.getId());
                return;
            }
            String materialOuterId = (String)reUploadRst.getValue();
            map.put("materialOuterId", materialOuterId);
        }
        for (Map item : (List)baseJsonVo.getValue()) {
            CalendarEntity calendarEntity = this.calendarInterface.getNextWorkDay(date, (String)item.get("id"));
            if (calendarEntity == null) {
                this.logger.info("\u81ea\u52a8\u63a8\u9001 \u8981\u63a8\u9001\u7684\u4f01\u5fae:{},\u8981\u63a8\u9001\u7684\u7d20\u6750:{}", item.get("name"), (Object)materialEntity.getMaterialName());
                RouteCustomerEntitySearchVo search = new RouteCustomerEntitySearchVo();
                search.setQyWeixinUserid((String)item.get("id"));
                search.setCreateDate(date);
                if (Objects.equals(materialEntity.getAppId(), AppEnum.SCRM.getValue())) {
                    search.setKefuUseStatus(0);
                } else if (Objects.equals(materialEntity.getAppId(), AppEnum.SALES.getValue())) {
                    search.setKefuUseStatus(-1);
                }
                search.setLechunAppId(materialEntity.getAppId());
                search.setPushType(PushTypeEnum.AUTO_PUSH.getValue());
                search.setMaterialId(materialEntity.getId());
                Page page = PageHelper.startPage((int)0, (int)999999);
                this.routeCustomerMapper.getServiceCustomerList(search);
                PageInfo pg = page.toPageInfo();
                if ("text".equals(map.get("materialType"))) {
                    this.push((String)item.get("id"), pg.getList(), map.get("pushText").toString(), "text", map);
                    continue;
                }
                if ("media".equals(map.get("materialType"))) {
                    this.push((String)item.get("id"), pg.getList(), map.get("materailOuterId").toString(), (String)map.get("mediaType"), map);
                    continue;
                }
                if ("miniprogram".equals(map.get("materialType"))) {
                    this.push((String)item.get("id"), pg.getList(), map.get("materailOuterId").toString(), (String)map.get("mediaType"), map);
                    continue;
                }
                if (!"link".equals(map.get("materialType"))) continue;
                this.push((String)item.get("id"), pg.getList(), "", (String)map.get("mediaType"), map);
                continue;
            }
            this.logger.info("\u4f01\u5fae:{} {}\u4e0d\u4e0a\u73ed", item.get("name"), (Object)date);
        }
    }

    @Override
    @Async
    public BaseJsonVo pushAutoMessage(Integer materialId) {
        MaterialEntity materialEntity = (MaterialEntity)this.materialInterface.selectByPrimaryKey(materialId);
        Date today = DateUtils.getDateFromString((String)DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
        BaseJsonVo baseJsonVo = this.calendarInterface.getQwUser(materialEntity.getAppId());
        this.extracted(today, (BaseJsonVo<List<Map<String, String>>>)baseJsonVo, materialEntity);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo pushMessageWithMaterialId(Integer materialId) {
        this.pushAutoMessage(materialId);
        return BaseJsonVo.success((Object)"");
    }

    private void push(String qyWeixinUserid, List<RouteCustomerEntityVo> list, String pushText, String pushType, Map<String, Object> item) {
        if (CollectionUtils.isNotEmpty(list)) {
            this.logger.info("\u81ea\u52a8\u63a8\u9001 \u8981\u63a8\u9001\u7684\u4f01\u5fae:{},\u7c7b\u578b:{},\u8981\u63a8\u9001\u7684\u7528\u6237:{},\u7d20\u6750:{}", new Object[]{qyWeixinUserid, pushType, JsonUtils.toJson(list, (boolean)false), JsonUtils.toJson(item, (boolean)false)});
            QySendMsg qySendMsg = new QySendMsg();
            qySendMsg.setChat_type("single");
            if ("text".equals(pushType)) {
                QySendMsgText qySendMsgText = new QySendMsgText();
                qySendMsgText.setContent(pushText);
                qySendMsg.setText(qySendMsgText);
            } else {
                ArrayList<Object> attachments = new ArrayList<Object>();
                this.logger.info("\u7d20\u6750\u7c7b\u578b:{}", (Object)pushType);
                if ("image".equals(pushType)) {
                    QySendMsgAttachmentsImage image = new QySendMsgAttachmentsImage();
                    QySendMsgAttachmentsImageBody imageBody = new QySendMsgAttachmentsImageBody();
                    imageBody.setMedia_id(item.get("materailOuterId").toString());
                    image.setMsgtype("image");
                    image.setImage(imageBody);
                    attachments.add(image);
                } else if ("video".equals(pushType)) {
                    QySendMsgAttachmentsVideo video = new QySendMsgAttachmentsVideo();
                    QySendMsgAttachmentsVideoBody videoBody = new QySendMsgAttachmentsVideoBody();
                    videoBody.setMedia_id(item.get("materailOuterId").toString());
                    video.setMsgtype("video");
                    video.setVideo(videoBody);
                    attachments.add(video);
                } else if ("voice".equals(pushType)) {
                    QySendMsgAttachmentsVoice voice = new QySendMsgAttachmentsVoice();
                    QySendMsgAttachmentsVoiceBody voiceBody = new QySendMsgAttachmentsVoiceBody();
                    voiceBody.setMedia_id(item.get("materailOuterId").toString());
                    voice.setMsgtype("voice");
                    voice.setVoice(voiceBody);
                    attachments.add(voice);
                } else if ("file".equals(pushType)) {
                    QySendMsgAttachmentsFile file = new QySendMsgAttachmentsFile();
                    QySendMsgAttachmentsFileBody fileBody = new QySendMsgAttachmentsFileBody();
                    fileBody.setMedia_id(item.get("materailOuterId").toString());
                    file.setMsgtype("file");
                    file.setFile(fileBody);
                    attachments.add(file);
                } else if ("miniprogram".equals(pushType)) {
                    QySendMsgAttachmentsMini mini = new QySendMsgAttachmentsMini();
                    QySendMsgAttachmentsMiniBody miniBody = new QySendMsgAttachmentsMiniBody();
                    miniBody.setAppid(item.getOrDefault("appid", "").toString());
                    miniBody.setPage(item.getOrDefault("page", "").toString());
                    miniBody.setPic_media_id(item.get("materailOuterId").toString());
                    miniBody.setTitle(item.getOrDefault("title", "").toString());
                    mini.setMiniprogram(miniBody);
                    mini.setMsgtype("miniprogram");
                    attachments.add(mini);
                } else if ("link".equals(pushType)) {
                    QySendMsgAttachmentsLink link = new QySendMsgAttachmentsLink();
                    QySendMsgAttachmentsLinkBody linkBody = new QySendMsgAttachmentsLinkBody();
                    linkBody.setDesc(item.getOrDefault("linkDesc", "").toString());
                    linkBody.setPicurl(item.getOrDefault("linkImglUrl", "").toString());
                    linkBody.setUrl(item.getOrDefault("link", "").toString());
                    linkBody.setTitle(item.getOrDefault("title", "").toString());
                    link.setLink(linkBody);
                    link.setMsgtype("link");
                    attachments.add(link);
                }
                qySendMsg.setAttachments(attachments);
            }
            qySendMsg.setSender(qyWeixinUserid);
            HashSet<String> userList = new HashSet<String>();
            for (RouteCustomerEntityVo routeCustomerEntityVo : list) {
                userList.add(routeCustomerEntityVo.getExternalUserid());
            }
            qySendMsg.setExternal_userid(userList.toArray(new String[userList.size()]));
            if (userList.size() > 0) {
                SendMsgResult sendMsgResult = SendMsgAPI.sendQyMsg((String)this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(7), (QySendMsg)qySendMsg);
                this.logger.error("\u7fa4\u53d1\u6d88\u606f:{},\u63a8\u9001\u7ed3\u679c:{}", (Object)JsonUtils.toJson((Object)qySendMsg, (boolean)false), (Object)JsonUtils.toJson((Object)sendMsgResult, (boolean)false));
                if (sendMsgResult.isSuccess()) {
                    for (RouteCustomerEntityVo routeCustomerEntityVo : list) {
                        RouteCustomerEntity routeCustomerEntity = new RouteCustomerEntity();
                        routeCustomerEntity.setId(routeCustomerEntityVo.getId());
                        routeCustomerEntity.setKefuUseStatus(1);
                        routeCustomerEntity.setKefuUseTime(DateUtils.now());
                        if (StringUtils.isNotEmpty((String)routeCustomerEntityVo.getRemark()) && (routeCustomerEntityVo.getRemark() + "|\u81ea\u52a8").length() < 255) {
                            routeCustomerEntity.setRemark(routeCustomerEntityVo.getRemark() + "|\u81ea\u52a8");
                        }
                        this.updateByPrimaryKeySelective(routeCustomerEntity);
                    }
                }
            }
        }
    }

    @Override
    public BaseJsonVo testPushVideo(String qyWeixinUserid, Set<String> externalCustomerIds, String mediaId) {
        this.logger.info("Test\u81ea\u52a8\u63a8\u9001VIDEO \u8981\u63a8\u9001\u7684\u4f01\u5fae:{},\u8981\u63a8\u9001\u7684\u7528\u6237:{}", (Object)qyWeixinUserid, (Object)JsonUtils.toJson(externalCustomerIds, (boolean)false));
        if (StringUtils.isEmpty((String)mediaId)) {
            mediaId = "3JzkLb2CtZxnGkRuAGB0I2ZSTFX8YJaJXqfDwcKRAKk7xRm6FizWEREIUEzEH4dwV";
        }
        qyWeixinUserid = "WangHanXiao";
        QySendMsg qySendMsg = new QySendMsg();
        qySendMsg.setChat_type("single");
        QySendMsgAttachmentsVideo video = new QySendMsgAttachmentsVideo();
        QySendMsgAttachmentsVideoBody videoBody = new QySendMsgAttachmentsVideoBody();
        videoBody.setMedia_id(mediaId);
        video.setMsgtype("video");
        video.setVideo(videoBody);
        ArrayList<QySendMsgAttachmentsVideo> attachments = new ArrayList<QySendMsgAttachmentsVideo>();
        attachments.add(video);
        qySendMsg.setAttachments(attachments);
        qySendMsg.setSender(qyWeixinUserid);
        if (externalCustomerIds != null && externalCustomerIds.size() > 0) {
            qySendMsg.setExternal_userid(externalCustomerIds.toArray(new String[externalCustomerIds.size()]));
        }
        SendMsgResult sendMsgResult = SendMsgAPI.sendQyMsg((String)this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(7), (QySendMsg)qySendMsg);
        this.logger.info("Test\u7fa4\u53d1VIDEO\u6d88\u606f:{},\u63a8\u9001\u7ed3\u679c:{}", (Object)JsonUtils.toJson((Object)qySendMsg, (boolean)false), (Object)JsonUtils.toJson((Object)sendMsgResult, (boolean)false));
        return BaseJsonVo.success((Object)sendMsgResult);
    }

    private void pushVideo(String qyWeixinUserid, List<RouteCustomerEntityVo> list, String mediaId) {
        this.logger.info("\u81ea\u52a8\u63a8\u9001VIDEO \u8981\u63a8\u9001\u7684\u4f01\u5fae:{},\u8981\u63a8\u9001\u7684\u7528\u6237:{}", (Object)qyWeixinUserid, (Object)JsonUtils.toJson(list, (boolean)false));
        if (CollectionUtils.isNotEmpty(list)) {
            QySendMsg qySendMsg = new QySendMsg();
            qySendMsg.setChat_type("single");
            QySendMsgAttachmentsVideo video = new QySendMsgAttachmentsVideo();
            QySendMsgAttachmentsVideoBody videoBody = new QySendMsgAttachmentsVideoBody();
            videoBody.setMedia_id(mediaId);
            video.setMsgtype("video");
            video.setVideo(videoBody);
            ArrayList<QySendMsgAttachmentsVideo> attachments = new ArrayList<QySendMsgAttachmentsVideo>();
            attachments.add(video);
            qySendMsg.setAttachments(attachments);
            qySendMsg.setSender(qyWeixinUserid);
            HashSet<String> userList = new HashSet<String>();
            for (RouteCustomerEntityVo routeCustomerEntityVo : list) {
                userList.add(routeCustomerEntityVo.getExternalUserid());
            }
            qySendMsg.setExternal_userid(userList.toArray(new String[userList.size()]));
            if (userList.size() > 0) {
                SendMsgResult sendMsgResult = SendMsgAPI.sendQyMsg((String)this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(7), (QySendMsg)qySendMsg);
                this.logger.info("\u7fa4\u53d1VIDEO\u6d88\u606f:{},\u63a8\u9001\u7ed3\u679c:{}", (Object)JsonUtils.toJson((Object)qySendMsg, (boolean)false), (Object)JsonUtils.toJson((Object)sendMsgResult, (boolean)false));
            }
            for (RouteCustomerEntityVo routeCustomerEntityVo : list) {
                RouteCustomerEntity routeCustomerEntity = new RouteCustomerEntity();
                routeCustomerEntity.setId(routeCustomerEntityVo.getId());
                routeCustomerEntity.setKefuUseStatus(1);
                routeCustomerEntity.setKefuUseTime(DateUtils.now());
                if (StringUtils.isNotEmpty((String)routeCustomerEntityVo.getRemark()) && (routeCustomerEntityVo.getRemark() + "|\u81ea\u52a8").length() < 255) {
                    routeCustomerEntity.setRemark(routeCustomerEntityVo.getRemark() + "|\u81ea\u52a8");
                }
                this.updateByPrimaryKeySelective(routeCustomerEntity);
            }
        }
    }

    @Override
    public BaseJsonVo getQwServiceList(String searchText, Integer pageNum, Integer pageSize, Integer routeId, String qwUserId, String sdate, String edate, String customerId, String openId, Integer status, Integer groupId, Integer appId, Map<Integer, List<String>> mapRight) {
        CustomerDetailVo customerDetailVo;
        if (StringUtils.isNotEmpty((String)openId) && StringUtils.isEmpty((String)customerId) && (customerDetailVo = this.customerInterface.getCustomerDetailByOpenid(openId)) != null) {
            customerId = customerDetailVo.getCustomerId();
        }
        return this.getQwServiceList(searchText, pageNum, pageSize, routeId, qwUserId, sdate, edate, customerId, status, groupId, null, appId, mapRight);
    }

    @Override
    public BaseJsonVo getQwServiceList(String searchText, Integer pageNum, Integer pageSize, Integer routeId, String qwUserId, String sdate, String edate, String customerId, Integer status, Integer groupId, Integer pushType, Integer appId, Map<Integer, List<String>> mapRight) {
        MallUserEntity search;
        String ncpBat = "";
        if (StringUtils.isNotEmpty((String)qwUserId) && (search = (MallUserEntity)this.mallUserInterface.selectByPrimaryKey((Serializable)((Object)qwUserId))) != null) {
            BaseJsonVo<String> baseJsonVo = this.distributorInterface.getQiyeWeixinShareCode(search.getQyWeixinUserid());
            ncpBat = baseJsonVo.isSuccess() ? (String)baseJsonVo.getValue() : "";
        }
        return this.getQwServiceList(searchText, pageNum, pageSize, routeId, qwUserId, ncpBat, sdate, edate, customerId, status, groupId, pushType, appId, mapRight);
    }

    @Override
    public BaseJsonVo getQwServiceList(String searchText, Integer pageNum, Integer pageSize, Integer routeId, String qwUserId, String ncpBat, String sdate, String edate, String customerId, Integer status, Integer groupId, Integer pushType, Integer appId, Map<Integer, List<String>> mapRight) {
        if (sdate == null) {
            sdate = DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd");
        }
        if (edate == null) {
            edate = DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd");
        }
        if (Integer.valueOf(-5).equals(status)) {
            status = null;
        }
        RouteCustomerEntitySearchVo search = new RouteCustomerEntitySearchVo();
        search.setQwUserid(qwUserId);
        if (StringUtils.isNotEmpty((String)customerId)) {
            search.setCustomerId(customerId);
        }
        if (appId != null) {
            search.setLechunAppId(appId);
        }
        search.setSdate(DateUtils.getDateFromString((String)sdate, (String)"yyyy-MM-dd"));
        search.setEdate(DateUtils.getDateFromString((String)edate, (String)"yyyy-MM-dd"));
        if (StringUtils.isNotEmpty((String)searchText)) {
            SceneEntity query = new SceneEntity();
            query.setSceneName(searchText);
            SceneEntity sceneEntity = (SceneEntity)this.sceneInterface.getSingle(query);
            if (sceneEntity != null) {
                search.setSceneId(sceneEntity.getId());
            } else {
                search.setAvatar(SqlUtils.sqlLike((String)searchText, (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
            }
        } else {
            search.setAvatar(null);
        }
        search.setKefuUseStatus(status);
        search.setGroupId(groupId);
        if (pushType != null) {
            search.setPushType(pushType);
        }
        if (mapRight.containsKey(1)) {
            if (mapRight.get(1).get(0).equals("0")) {
                search.setDataRights(null);
            } else {
                search.setDataRights(mapRight.get(1));
            }
        }
        if (mapRight.containsKey(2)) {
            if (mapRight.get(2).get(0).equals("0")) {
                search.setDataRights2(null);
            } else {
                List<String> users = this.distributorInterface.getUserIdByDistributor(mapRight.get(2));
                if (users != null && users.size() == 0) {
                    users = null;
                }
                search.setDataRights2(users);
            }
        }
        List<CalendarEntity> calendarList = this.calendarInterface.getCalendarListByDate(DateUtils.getDateFromString((String)sdate, (String)"yyyy-MM-dd"), DateUtils.getDateFromString((String)edate, (String)"yyyy-MM-dd"));
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.routeCustomerMapper.getServiceCustomerList(search);
        PageInfo pg = page.toPageInfo();
        List cluePoolVos = new ArrayList();
        if (pg.getTotal() > 0L) {
            if (Integer.valueOf(2).equals(appId)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("clueIdList", pg.getList().stream().map(c -> c.getClueId()).collect(Collectors.toList()));
                map.put("pageSize", pageSize);
                map.put("currentPage", pageNum);
                map.put("userId", "admin");
                PageInfo pageInfo = this.clueCleanInvoke.getCluePoolListForCms(map);
                this.logger.info("getCluePoolListForCms jsvo:" + pageInfo.getPageSize());
                if (pageInfo != null && pageInfo.getList() != null && pageInfo.getList().size() > 0) {
                    cluePoolVos = pageInfo.getList();
                    this.logger.info("getCluePoolListForCms jsvo:" + cluePoolVos.size());
                }
            }
            for (RouteCustomerEntityVo routeCustomerEntityVo : pg.getList()) {
                if (Objects.equals(routeCustomerEntityVo.getMaterialType(), "miniprogram") || Objects.equals(routeCustomerEntityVo.getMaterialType(), "link")) {
                    Map map = this.materialInterface.getMaterialWithType(routeCustomerEntityVo.getMaterialId());
                    if (Objects.equals(routeCustomerEntityVo.getMaterialType(), "miniprogram")) {
                        routeCustomerEntityVo.setAppId(map.getOrDefault("appid", "").toString());
                        routeCustomerEntityVo.setTitle(map.getOrDefault("title", "").toString());
                        String miniPage = map.getOrDefault("page", "").toString();
                        if (StringUtils.isNotEmpty((String)miniPage) && StringUtils.isNotEmpty((String)ncpBat) && miniPage.indexOf("ncp_bat") < 0) {
                            miniPage = miniPage.indexOf("?") > 0 ? miniPage + "&ncp_bat=" + ncpBat : miniPage + "?ncp_bat=" + ncpBat;
                        }
                        routeCustomerEntityVo.setPage(miniPage);
                        routeCustomerEntityVo.setImgUrl(map.getOrDefault("miniImgUrl", "").toString());
                    } else if (Objects.equals(routeCustomerEntityVo.getMaterialType(), "link")) {
                        routeCustomerEntityVo.setDesc(map.getOrDefault("linkDesc", "").toString());
                        routeCustomerEntityVo.setTitle(map.getOrDefault("title", "").toString());
                        routeCustomerEntityVo.setLink(map.getOrDefault("link", "").toString());
                        routeCustomerEntityVo.setImgUrl(map.getOrDefault("linkImglUrl", "").toString());
                    }
                }
                if (CollectionUtils.isNotEmpty(calendarList)) {
                    for (CalendarEntity calendarEntity : calendarList) {
                        if (!StringUtils.isNotEmpty((String)calendarEntity.getQyWeixinUserId()) || calendarEntity.getDate().compareTo(routeCustomerEntityVo.getCreateDate()) != 0 || !calendarEntity.getQyWeixinUserId().contains(routeCustomerEntityVo.getQyWeixinUserid())) continue;
                        if (Integer.valueOf(0).equals(calendarEntity.getQyWorkType())) {
                            routeCustomerEntityVo.setHoliday("\u8bf7\u5047");
                            continue;
                        }
                        routeCustomerEntityVo.setHoliday("\u52a0\u73ed");
                    }
                }
                if (!Integer.valueOf(2).equals(appId)) continue;
                Optional<LinkedHashMap> optional = cluePoolVos.stream().filter(c -> c.get("clueId").equals(routeCustomerEntityVo.getClueId())).findFirst();
                if (optional.isPresent()) {
                    routeCustomerEntityVo.setPushText("");
                }
                routeCustomerEntityVo.setCluePoolVo(optional.isPresent() ? optional.get() : null);
            }
        }
        return BaseJsonVo.success((Object)pg);
    }

    private BaseJsonVo getQwServiceListForSales(String searchText, Integer pageNum, Integer pageSize, String qwUserId, String sdate, String edate, String customerId, Integer status, Integer groupId, Integer pushType, Integer appId) {
        MallUserEntity search1;
        if (sdate == null) {
            sdate = DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd");
        }
        if (edate == null) {
            edate = DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd");
        }
        if (Integer.valueOf(-5).equals(status)) {
            status = null;
        }
        RouteCustomerEntitySearchVo search = new RouteCustomerEntitySearchVo();
        search.setQwUserid(qwUserId);
        if (StringUtils.isNotEmpty((String)customerId)) {
            search.setCustomerId(customerId);
        }
        if (appId != null) {
            search.setLechunAppId(appId);
        }
        search.setSdate(DateUtils.getDateFromString((String)sdate, (String)"yyyy-MM-dd"));
        search.setEdate(DateUtils.getDateFromString((String)edate, (String)"yyyy-MM-dd"));
        if (StringUtils.isNotEmpty((String)searchText)) {
            SceneEntity query = new SceneEntity();
            query.setSceneName(searchText);
            SceneEntity sceneEntity = (SceneEntity)this.sceneInterface.getSingle(query);
            if (sceneEntity != null) {
                search.setSceneId(sceneEntity.getId());
            } else {
                search.setAvatar(SqlUtils.sqlLike((String)searchText, (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
            }
        } else {
            search.setAvatar(null);
        }
        search.setKefuUseStatus(status);
        search.setGroupId(groupId);
        if (pushType != null) {
            search.setPushType(pushType);
        }
        String[] ncpBat = new String[1];
        if (StringUtils.isNotEmpty((String)qwUserId) && (search1 = (MallUserEntity)this.mallUserInterface.selectByPrimaryKey((Serializable)((Object)qwUserId))) != null) {
            BaseJsonVo<String> baseJsonVo = this.distributorInterface.getQiyeWeixinShareCode(search1.getQyWeixinUserid());
            ncpBat[0] = baseJsonVo.isSuccess() ? (String)baseJsonVo.getValue() : "";
        }
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.routeCustomerMapper.getServiceCustomerListForSales(search);
        PageInfo pg = page.toPageInfo();
        if (pg.getTotal() > 0L) {
            pg.getList().forEach(routeCustomerEntityVo -> {
                CalendarEntity calendarEntity;
                if (Objects.equals(routeCustomerEntityVo.getMaterialType(), "miniprogram") || Objects.equals(routeCustomerEntityVo.getMaterialType(), "link")) {
                    Map map = this.materialInterface.getMaterialWithType(routeCustomerEntityVo.getMaterialId());
                    if (Objects.equals(routeCustomerEntityVo.getMaterialType(), "miniprogram")) {
                        routeCustomerEntityVo.setAppId(map.getOrDefault("appid", "").toString());
                        routeCustomerEntityVo.setTitle(map.getOrDefault("title", "").toString());
                        String miniPage = map.getOrDefault("page", "").toString();
                        if (StringUtils.isNotEmpty((String)miniPage) && StringUtils.isNotEmpty((String)ncpBat[0]) && miniPage.indexOf("ncp_bat") < 0) {
                            miniPage = miniPage.indexOf("?") > 0 ? miniPage + "&ncp_bat=" + ncpBat[0] : miniPage + "?ncp_bat=" + ncpBat[0];
                        }
                        routeCustomerEntityVo.setPage(miniPage);
                        routeCustomerEntityVo.setImgUrl(map.getOrDefault("miniImgUrl", "").toString());
                    } else if (Objects.equals(routeCustomerEntityVo.getMaterialType(), "link")) {
                        routeCustomerEntityVo.setDesc(map.getOrDefault("linkDesc", "").toString());
                        routeCustomerEntityVo.setTitle(map.getOrDefault("title", "").toString());
                        routeCustomerEntityVo.setLink(map.getOrDefault("link", "").toString());
                        routeCustomerEntityVo.setImgUrl(map.getOrDefault("linkImglUrl", "").toString());
                    }
                }
                if ((calendarEntity = this.calendarInterface.getCalendarListByDate(routeCustomerEntityVo.getCreateDate())) != null && calendarEntity.getQyWeixinUserId().contains(routeCustomerEntityVo.getQyWeixinUserid())) {
                    if (Integer.valueOf(0).equals(calendarEntity.getQyWorkType())) {
                        routeCustomerEntityVo.setHoliday("\u8bf7\u5047");
                    } else {
                        routeCustomerEntityVo.setHoliday("\u52a0\u73ed");
                    }
                }
            });
        }
        return BaseJsonVo.success((Object)pg);
    }

    @Override
    public BaseJsonVo setProcessStatus(String userId, int id) {
        RouteCustomerEntity routeCustomerEntity = (RouteCustomerEntity)this.selectByPrimaryKey(Integer.valueOf(id));
        if (routeCustomerEntity == null) {
            return BaseJsonVo.error((String)"\u7528\u6237\u65c5\u7a0b\u4e0d\u5b58\u5728");
        }
        if (!userId.equals(routeCustomerEntity.getQwUserid())) {
            MallUserEntity userEntity = (MallUserEntity)this.mallUserInterface.selectByPrimaryKey((Serializable)((Object)routeCustomerEntity.getQwUserid()));
            String message = "\u6ca1\u6709\u6743\u9650,\u8be5\u7528\u6237\u5c5e\u4e8e" + (userEntity != null ? userEntity.getUserNick() : "\u5176\u4ed6\u4e1a\u52a1\u5458");
            this.logger.error("sop id:{}\u9884\u5904\u7406\u7528\u6237:{},\u6240\u5c5e\u7528\u6237:{}", new Object[]{id, userId, routeCustomerEntity.getQwUserid()});
            return BaseJsonVo.error((String)message);
        }
        routeCustomerEntity.setKefuUseStatus(1);
        routeCustomerEntity.setKefuUseTime(new Date());
        this.setParentUseStatus(routeCustomerEntity, 1);
        this.updateByPrimaryKeySelective(routeCustomerEntity);
        return BaseJsonVo.success((Object)"\u8bbe\u7f6e\u6210\u529f");
    }

    @Override
    public boolean deleteRouteCustomer(Integer routeId) {
        if (routeId == null) {
            return false;
        }
        RouteCustomerEntity search = new RouteCustomerEntity();
        search.setRouteId(routeId);
        return this.deleteByEntity(search) > 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public BaseJsonVo execMaterial(Integer materialId, Integer sceneId, Integer routeId, String routeRecordId) {
        if (materialId == null || sceneId == null || StringUtils.isEmpty((String)routeRecordId) || routeId == null) {
            return BaseJsonVo.error((String)"\u7d20\u6750\u6216\u573a\u666f\u4e3a\u7a7a");
        }
        Map map = this.materialInterface.getMaterialWithType(materialId);
        if (map.containsKey("status") && (Objects.equals(map.get("status").toString(), "0") || Objects.equals(map.get("status").toString(), "0"))) {
            this.logger.error("\u7d20\u6750:{}\u5df2\u4e0b\u67b6", map.get("materialName"));
            return BaseJsonVo.error((String)("\u7d20\u6750" + map.get("materialName") + "\u5df2\u4e0b\u67b6"));
        }
        BaseJsonVo jsonVo1 = BaseJsonVo.error((String)"\u6ca1\u6709\u5339\u914d\u5230\u7d20\u6750");
        String sql = "update " + this.getDbName() + ".t_scrm_route_customer set PUSH_TEXT=%s ,PUSH_TEXT1=%s ,MATERIAL_ID=" + materialId + ",MATERIAL_CODE='" + map.get("materialCode") + "',MATERIAL_PARENT_CODE=" + (map.get("materialParentCode") == null ? null : "'" + map.get("materialParentCode") + "'") + ",PARENT_USE_STATUS=" + (map.get("materialParentCode") == null ? -1 : 0) + " where route_id=" + routeId + " and SCENE_ID=" + sceneId + " and ROUTE_RECORD_ID='" + routeRecordId + "'";
        if ("text".equals(map.get("materialType"))) {
            String pushText = map.get("pushText").toString();
            BaseJsonVo jsonVo = this.variableInterface.replaceVariable(materialId, sceneId, routeId, routeRecordId, "pushText");
            this.logger.info("\u66ff\u6362\u53d8\u91cf\uff1a" + JsonUtils.toJson((Object)jsonVo, (boolean)false));
            BaseJsonVo jsonVo2 = this.variableInterface.replaceVariable(materialId, sceneId, routeId, routeRecordId, "keyword");
            this.logger.info("\u66ff\u6362\u53d8\u91cf\u975e\u6807\uff1a" + JsonUtils.toJson((Object)jsonVo, (boolean)false));
            sql = String.format(sql, jsonVo.isSuccess() ? jsonVo.getValue().toString() : "''", jsonVo2.isSuccess() ? jsonVo2.getValue().toString() : "''");
            String key = "scrm_routeCustomer_updateMaterial_" + routeId + "_" + materialId + "_" + routeRecordId;
            this.redisCacheUtil.set(key, (Object)sql, Long.valueOf(86400L));
            jsonVo1 = this.biGenerateSceneInvoke.updadeRouteCustomer(key, routeId, routeRecordId, sceneId);
            if (!jsonVo1.isSuccess()) {
                // empty if block
            }
        } else if ("media".equals(map.get("materialType"))) {
            sql = String.format(sql, "''", "''");
            String key = "scrm_routeCustomer_updateMaterial_" + routeId + "_" + materialId + "_" + routeRecordId;
            this.redisCacheUtil.set(key, (Object)sql, Long.valueOf(86400L));
            jsonVo1 = this.biGenerateSceneInvoke.updadeRouteCustomer(key, routeId, routeRecordId, sceneId);
            if (!jsonVo1.isSuccess()) {
                // empty if block
            }
        } else if ("miniprogram".equals(map.get("materialType"))) {
            sql = String.format(sql, "''", "''");
            String key = "scrm_routeCustomer_updateMaterial_" + routeId + "_" + materialId + "_" + routeRecordId;
            this.redisCacheUtil.set(key, (Object)sql, Long.valueOf(86400L));
            jsonVo1 = this.biGenerateSceneInvoke.updadeRouteCustomer(key, routeId, routeRecordId, sceneId);
            if (!jsonVo1.isSuccess()) {
                // empty if block
            }
        } else if ("link".equals(map.get("materialType"))) {
            sql = String.format(sql, "''", "''");
            String key = "scrm_routeCustomer_updateMaterial_" + routeId + "_" + materialId + "_" + routeRecordId;
            this.redisCacheUtil.set(key, (Object)sql, Long.valueOf(86400L));
            jsonVo1 = this.biGenerateSceneInvoke.updadeRouteCustomer(key, routeId, routeRecordId, sceneId);
            if (jsonVo1.isSuccess()) {
                // empty if block
            }
        }
        if (map.containsKey("pushType") && map.get("pushType") != null && Objects.equals(Integer.valueOf(map.get("pushType").toString()), PushTypeEnum.AUTO_PUSH.getValue())) {
            ((RouteCustomerService)SpringContextUtil.getBean(this.getClass())).pushAutoMessage(materialId);
        }
        return jsonVo1;
    }

    private String getDbName() {
        if (EnvironmentEnum.PRODUCT.getValue().equals(this.environment)) {
            return "`lechundb-2016_lechun`";
        }
        return "test_mall_dev";
    }

    private String getSaleDbName() {
        if (EnvironmentEnum.PRODUCT.getValue().equals(this.environment)) {
            return "`lechun-sales`";
        }
        return "test_sales_dev";
    }

    @Override
    public BaseJsonVo execRouteCustomers(Integer sceneId, Integer routeId, String routeRecordId, String linkId) {
        SceneEntity sceneEntity = (SceneEntity)this.sceneInterface.selectByPrimaryKey(sceneId);
        if (sceneEntity == null) {
            return BaseJsonVo.error((String)"\u573a\u666f\u4e0d\u5b58\u5728");
        }
        if (Integer.valueOf(2).equals(sceneEntity.getSceneType())) {
            return this.execRouteCustomersForSales(sceneId, routeId, routeRecordId, linkId, sceneEntity.getSceneType());
        }
        String sql = "\nINSERT INTO " + this.getDbName() + ".t_scrm_route_customer(\nROUTE_ID,\nSCENE_ID,\nROUTE_RECORD_ID,\nCUSTOMER_ID,\nNICK_NAME,\nPHONE,\nUSER_LEVEL,\nROUTE_LINK_ID,\nCREATE_TIME,\nCREATE_DATE,\nQW_USERID,\nqy_weixin_userid,\nexternal_userid,avatar,KEFU_USE_STATUS,ORDER_NO,ORDER_MAIN_NO,DEFINE_NICK_NAME,LECHUN_APP_ID,CLUE_ID)\nselect DISTINCT " + routeId + " as routeId," + sceneId + " as sceneId,'" + routeRecordId + "' as routeRecordId,c.CUSTOMER_ID,ifnull(ec.define_name,c.NICK_NAME) as NICK_NAME,c.PHONE,c.VIP_LEVEL,'" + linkId + "' as linkId,now() as createTime,date(now()) as createDate,u.user_id,ec.qy_weixin_userid,ec.external_userid,ec.avatar,-1 as KEFU_USE_STATUS,c.ORDER_NO,c.ORDER_MAIN_NO,ec.define_name,c.APP_ID,c.clue_id from " + this.getDbName() + ".t_scrm_scene_customer c \nLEFT JOIN " + this.getDbName() + ".t_mall_distributor_qiyeweixin_external_contact ec on c.customer_id=ec.customer_id and c.COMMON_QY_WEIXIN_USERID=ec.qy_weixin_userid\nleft join " + this.getDbName() + ".t_mall_sys_user u on INSTR(u.qy_weixin_userid,ec.qy_weixin_userid)>0\nwhere c.CREATE_TIME>=date(now()) and ec.save_succ=1 and (ec.define_status is null or ec.define_status not in(2,10,20)) and c.scene_id=" + sceneId + " and c.CUSTOMER_ID not in(select customer_id from " + this.getDbName() + ".t_scrm_route_customer where route_id=" + routeId + " and (create_date=date(now())))";
        String key = "scrm_routeCustomer_insert_" + routeId + "_" + sceneId + "_" + routeRecordId;
        this.redisCacheUtil.set(key, (Object)sql, Long.valueOf(3600L));
        this.logger.info("\u7fa4\u7ec4:{},\u65c5\u7a0b:{},key={},sql={}", new Object[]{sceneId, routeId, key, sql});
        return this.biGenerateSceneInvoke.insertRouteCustomer(key, routeId, routeRecordId, sceneId);
    }

    private BaseJsonVo execRouteCustomersForSales(Integer sceneId, Integer routeId, String routeRecordId, String linkId, Integer sceneType) {
        String sql = "\nINSERT INTO " + this.getDbName() + ".t_scrm_route_customer(\nROUTE_ID,\nSCENE_ID,\nROUTE_RECORD_ID,\nCUSTOMER_ID,\nNICK_NAME,\nPHONE,\nUSER_LEVEL,\nROUTE_LINK_ID,\nCREATE_TIME,\nCREATE_DATE,\nQW_USERID,\nqy_weixin_userid,\nexternal_userid,avatar,KEFU_USE_STATUS,ORDER_NO,ORDER_MAIN_NO,DEFINE_NICK_NAME,LECHUN_APP_ID,CLUE_ID,SCENE_TYPE)\nselect DISTINCT " + routeId + " as routeId," + sceneId + " as sceneId,'" + routeRecordId + "' as routeRecordId,c.clue_id,sc.CLIENT_NAME as NICK_NAME,sc.CONTACT_INFOR,c.VIP_LEVEL,'" + linkId + "' as linkId,now() as createTime,date(now()) as createDate,scd.user_id,scd.qy_weixin_userid,null,null,-1 as KEFU_USE_STATUS,c.ORDER_NO,c.ORDER_MAIN_NO,null,c.APP_ID,c.clue_id,cc.SCENE_TYPE from " + this.getDbName() + ".t_scrm_scene_customer c \n left join " + this.getSaleDbName() + ".t_sales_clue sc on c.clue_id=sc.clue_id  left join " + this.getSaleDbName() + ".t_sales_clue_distributor scd on scd.clue_id=sc.clue_id and scd.distributor_id=sc.last_contact_userid and scd.status=1  left join " + this.getDbName() + ".t_scrm_scene cc on cc.ID=c.SCENE_ID where c.CREATE_TIME>=date(now()) and cc.scene_type=2 and sc.status=1 and c.scene_id=" + sceneId + " and c.clue_id not in(select clue_id from " + this.getDbName() + ".t_scrm_route_customer where scene_type=2 and route_id=" + routeId + " and (create_date=date(now())))";
        this.logger.info("\u7fa4\u7ec4:{},\u65c5\u7a0b:{},sql:{}", new Object[]{sceneId, routeId, sql});
        String key = "scrm_routeCustomer_insert_" + routeId + "_" + sceneId + "_" + routeRecordId;
        this.redisCacheUtil.set(key, (Object)sql, Long.valueOf(3600L));
        this.logger.info("\u7fa4\u7ec4:{},\u65c5\u7a0b:{},sql:{}", new Object[]{sceneId, routeId, sql});
        return this.biGenerateSceneInvoke.insertRouteCustomer(key, routeId, routeRecordId, sceneId);
    }

    @Override
    public List<String> getServiceList(RouteCustomerEntity routeCustomerEntity) {
        return this.routeCustomerMapper.getServiceList(routeCustomerEntity);
    }

    @Override
    public BaseJsonVo getQwIsSend(Date date) {
        RouteCustomerEntity routeCustomerEntity = new RouteCustomerEntity();
        routeCustomerEntity.setKefuUseStatus(1);
        routeCustomerEntity.setCreateDate(DateUtils.getDateFromString((String)DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd"));
        List lst = this.getList(routeCustomerEntity);
        Integer i = 0;
        for (RouteCustomerEntity rc : lst) {
            BaseJsonVo jsonVo;
            String content = rc.getPushText();
            Map materialMap = this.materialInterface.getMaterialWithType(rc.getMaterialId());
            String materialType = materialMap.getOrDefault("materialType", "text").toString();
            if (Objects.equals(materialType, "link")) {
                content = materialMap.getOrDefault("link", "").toString();
            } else if (Objects.equals(materialType, "miniprogram")) {
                content = materialMap.getOrDefault("title", "").toString();
            } else if (Objects.equals(materialType, "media")) {
                content = materialMap.getOrDefault("mediaMaterialOuterId", "").toString();
            }
            if (!(jsonVo = this.biGenerateSceneInvoke.getQwSendContent(rc.getQyWeixinUserid(), rc.getExternalUserid(), content, materialMap.getOrDefault("materialType", "text").toString(), DateUtils.formatDate((Date)(rc.getKefuUseTime() == null ? date : rc.getKefuUseTime()), (String)"yyyy-MM-dd HH:mm:ss"), rc.getKefuUseStatus())).isSuccess()) continue;
            Map map = (Map)jsonVo.getValue();
            String factPushText = map.get("factPushText").toString();
            Integer isSend = Integer.valueOf(map.get("isSend").toString());
            Date createTime = rc.getKefuUseTime();
            if (map.get("createTime") != null) {
                createTime = DateUtils.getDateFromString((String)map.get("createTime").toString());
            }
            if (!Integer.valueOf(1).equals(isSend)) continue;
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            rc.setKefuUseStatus(2);
            rc.setFactPushText(factPushText);
            rc.setKefuUseTime(createTime);
            this.updateByPrimaryKeySelective(rc);
            this.setParentUseStatus(rc, 2);
        }
        return BaseJsonVo.success((Object)("\u67e5\u8be2" + lst.size() + "\u6761\uff0c\u5b9e\u9645\u53d1\u9001" + i + "\u6761"));
    }

    private void test(RouteCustomerEntity rc) {
        if (Objects.equals(rc.getLechunAppId(), AppEnum.SALES.getValue()) && Objects.equals(rc.getKefuUseStatus(), 1)) {
            rc.setKefuUseStatus(2);
            rc.setKefuUseTime(new Date());
            this.updateByPrimaryKeySelective(rc);
            this.setParentUseStatus(rc, 2);
        }
    }

    @Override
    public BaseJsonVo getUserIsRepeat(Date date, Integer pageNum, Integer pageSize) {
        RouteCustomerEntity routeCustomerEntity = new RouteCustomerEntity();
        routeCustomerEntity.setKefuUseStatus(2);
        routeCustomerEntity.setCreateDate(DateUtils.getDateFromString((String)DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd"));
        PageInfo pageInfo = this.getPageList(pageNum, pageSize, routeCustomerEntity);
        List lst = pageInfo.getList();
        Integer i = 0;
        for (RouteCustomerEntity rc : lst) {
            Map materialMap = this.materialInterface.getMaterialWithType(rc.getMaterialId());
            String content = rc.getPushText();
            String materialType = materialMap.getOrDefault("materialType", "text").toString();
            if (Objects.equals(materialType, "link")) {
                content = materialMap.getOrDefault("link", "").toString();
            } else if (Objects.equals(materialType, "miniprogram")) {
                content = materialMap.getOrDefault("title", "").toString();
            } else if (Objects.equals(materialType, "media")) {
                content = materialMap.getOrDefault("mediaMaterialOuterId", "").toString();
            }
            BaseJsonVo jsonVo = this.biGenerateSceneInvoke.getQwSendContent(rc.getQyWeixinUserid(), rc.getExternalUserid(), content, materialType, DateUtils.formatDate((Date)(rc.getKefuUseTime() == null ? date : rc.getKefuUseTime()), (String)"yyyy-MM-dd HH:mm:ss"), rc.getKefuUseStatus());
            if (jsonVo.isSuccess()) {
                String tag;
                Map map = (Map)jsonVo.getValue();
                Integer isRepeat = Integer.valueOf(map.get("isRepeat").toString());
                Integer repeatCount = 0;
                if (map.get("repeatCount") != null) {
                    repeatCount = Integer.valueOf(map.get("repeatCount").toString());
                }
                Date createTime = rc.getKefuUseTime();
                if (map.get("createTime") != null) {
                    createTime = DateUtils.getDateFromString((String)map.get("createTime").toString());
                }
                if (Integer.valueOf(1).equals(isRepeat)) {
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                    rc.setKefuUseStatus(3);
                    rc.setRepeatCount(repeatCount);
                    rc.setKefuUseTime(createTime);
                    this.updateByPrimaryKeySelective(rc);
                    this.setParentUseStatus(rc, 3);
                }
                if (!StringUtils.isNotEmpty((String)(tag = this.materialTraceInterface.getMaterialTraceTag(rc, isRepeat, (List)map.get("content"))))) continue;
                RouteCustomerEntity update = new RouteCustomerEntity();
                update.setId(rc.getId());
                update.setMaterialTag(tag);
                this.updateByPrimaryKeySelective(update);
                continue;
            }
            String tag = this.materialTraceInterface.getMaterialTraceTag(rc, 0, new ArrayList<Map<String, String>>());
            if (!StringUtils.isNotEmpty((String)tag)) continue;
            RouteCustomerEntity update = new RouteCustomerEntity();
            update.setId(rc.getId());
            update.setMaterialTag(tag);
            this.updateByPrimaryKeySelective(update);
        }
        return BaseJsonVo.success((Object)("\u67e5\u8be2" + lst.size() + "\u6761\uff0c\u5b9e\u9645\u56de\u590d" + i + "\u6761"));
    }

    private BaseJsonVo setParentUseStatus(RouteCustomerEntity routeCustomerEntity, int status) {
        if (StringUtils.isNotEmpty((String)routeCustomerEntity.getMaterialCode())) {
            RouteCustomerEntity searchChildren = new RouteCustomerEntity();
            searchChildren.setMaterialParentCode(routeCustomerEntity.getMaterialCode());
            searchChildren.setCustomerId(routeCustomerEntity.getCustomerId());
            searchChildren.setCreateDate(routeCustomerEntity.getCreateDate());
            List lst = this.getList(searchChildren);
            for (RouteCustomerEntity r : lst) {
                r.setParentUseStatus(status);
                this.updateByPrimaryKeySelective(r);
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo execMaterialRule(Date date, String customerId) {
        date = date == null ? DateUtils.currentDate() : date;
        List<RouteCustomerQwCountVo> qiWeiUserList = this.distributorQiyeweixinExternalContactInterface.getQiWeixinUseridList();
        List<CalendarEntity> lstCalendar = this.calendarInterface.getNextWorkDayList(date, 7);
        List workDayList = lstCalendar.stream().filter(c -> c.getIsHoliday() == 0).collect(Collectors.toList());
        int workDayCount = 5;
        if (CollectionUtils.isNotEmpty(workDayList)) {
            workDayCount = workDayList.size();
            this.logger.info("{}\u672a\u6765{}\u5929\u5de5\u4f5c\u65e5\u5929\u6570:{}", new Object[]{date, 7, workDayCount});
        }
        try {
            List<RouteCustomerQwCountVo> qwCounts = this.routeCustomerMapper.getQwSopCount(date);
            List<RouteCustomerRuleVo> lst = this.routeCustomerMapper.getRouteProcessCustomer(date, customerId);
            Map<String, List<RouteCustomerRuleVo>> customerMap = lst.stream().collect(Collectors.groupingBy(RouteCustomerRuleVo::getCustomerId));
            for (String c2 : customerMap.keySet()) {
                this.materialRuleInterface.processRule(c2, customerMap.get(c2), date);
                List<RouteCustomerRuleVo> l = customerMap.get(c2);
                l = l.stream().filter(cc -> Integer.valueOf(0).compareTo(cc.getKefuUseStatus()) == 1).collect(Collectors.toList());
                ArrayList<RouteCustomerEntity> list = new ArrayList<RouteCustomerEntity>();
                for (RouteCustomerRuleVo v : l) {
                    if (this.redisCacheUtil.get(v.getCustomerId() + "_" + v.getQyWeixinUserId() + "_" + date) != null) continue;
                    RouteCustomerEntity updateEntity = new RouteCustomerEntity();
                    updateEntity.setId(v.getId());
                    updateEntity.setCreateDate(v.getCreateDate());
                    updateEntity.setCreateTime(v.getCreateTime());
                    updateEntity.setFromDate(date);
                    if (Objects.equals(v.getSceneType(), 2) && StringUtils.isEmpty((String)v.getQwUserid())) {
                        MallUserEntity userEntity;
                        this.logger.info("\u8c03\u7528\u9500\u552e\u7cfb\u7edf\u5206\u914d\u4e1a\u52a1\u5458,\u5ba2\u6237id:{}", (Object)v.getCustomerId());
                        BaseJsonVo jsonVo = this.clueCleanInvoke.arrangeClueBySys(Integer.valueOf(v.getCustomerId()));
                        if (!jsonVo.isSuccess()) continue;
                        Map map = (Map)jsonVo.getValue();
                        this.logger.info("\u67e5\u8be2\u4e1a\u52a1\u5458\u9489\u9489\u53f7,\u5ba2\u6237id:{},\u8fd4\u56de\u7ed3\u679c:{}", (Object)v.getCustomerId(), (Object)JsonUtils.toJson((Object)map, (boolean)false));
                        if (map.containsKey("userId") && map.get("userId") != null && (userEntity = this.userInterface.getMallUser(map.get("userId").toString())) != null) {
                            this.logger.info("\u67e5\u8be2\u4e1a\u52a1\u5458:{},\u9489\u9489\u53f7,{},\u63a8\u9001\u6587\u6848:{}", new Object[]{userEntity.getUserId(), userEntity.getDingdingId(), v.getPushText()});
                            updateEntity.setQwUserid(userEntity.getUserId());
                            updateEntity.setQyWeixinUserid(userEntity.getQyWeixinUserid());
                            if (StringUtils.isNotEmpty((String)userEntity.getDingdingId())) {
                                this.dingdingUtils.sendTextMessage(userEntity.getDingdingId(), v.getPushText());
                            }
                        }
                    }
                    if (date.equals(v.getCreateDate()) && Integer.valueOf(-1).equals(v.getKefuUseStatus())) {
                        updateEntity.setKefuUseStatus(0);
                        if (Objects.equals(v.getMaterialStatus(), 3) || Objects.equals(v.getMaterialStatus(), 0)) {
                            updateEntity.setKefuUseStatus(-3);
                            updateEntity.setReason("\u7d20\u6750\u5ba1\u6838\u4e0d\u901a\u8fc7\u6216\u505c\u7528");
                            this.logger.info("\u7d20\u6750:{}\u505c\u7528\u4e86\uff0csop:{}\u4e0d\u518d\u5904\u7406", (Object)v.getMaterialId(), (Object)v.getId());
                        }
                    } else {
                        updateEntity.setKefuUseStatus(v.getKefuUseStatus());
                        updateEntity.setReason(v.getReason());
                    }
                    updateEntity.setRemark(v.getRemark());
                    if (Integer.valueOf(0).equals(updateEntity.getKefuUseStatus()) && updateEntity.getCreateDate().equals(date) && CollectionUtils.isNotEmpty(qwCounts)) {
                        Optional<RouteCustomerQwCountVo> qwHasCountVo;
                        int count = 1;
                        Optional<RouteCustomerQwCountVo> qwCountVo = qwCounts.stream().filter(e -> Objects.equals(e.getQyWeixinUserId(), v.getQyWeixinUserId())).findFirst();
                        if (qwCountVo.isPresent()) {
                            qwCountVo.get().setCount(qwCountVo.get().getCount() + 1);
                            count = qwCountVo.get().getCount() + 1;
                        } else {
                            RouteCustomerQwCountVo rqw = new RouteCustomerQwCountVo();
                            rqw.setCount(1);
                            rqw.setQyWeixinUserId(v.getQyWeixinUserId());
                            qwCounts.add(rqw);
                            count = this.redisCacheUtil.increment(v.getQyWeixinUserId() + ":" + date + "SOPNum", 1);
                        }
                        Integer qiWeiLimitCount = this.limitCount;
                        if (CollectionUtils.isNotEmpty(qiWeiUserList) && (qwHasCountVo = qiWeiUserList.stream().filter(e -> Objects.equals(e.getQyWeixinUserId(), v.getQyWeixinUserId())).findFirst()).isPresent()) {
                            if (qwHasCountVo.get().getCount() / workDayCount + 100 < qiWeiLimitCount) {
                                qiWeiLimitCount = qwHasCountVo.get().getCount() / workDayCount + 100;
                            }
                            this.logger.info("\u4f01\u5fae:{} \u5ba2\u6237\u603b\u6570:{},\u5df2\u7ecf\u5904\u7406{}\u4e2a\u5ba2\u6237sop, \u5de5\u4f5c\u65e5\u5929\u6570:{} \u5b9e\u65f6\u8ba1\u7b97\u4f01\u5fae\u6bcf\u65e5\u9650\u91cf\u6570:{}", new Object[]{qwHasCountVo.get().getQyWeixinUserId(), qwHasCountVo.get().getCount(), count, workDayCount, qiWeiLimitCount});
                        }
                        if (count > qiWeiLimitCount) {
                            updateEntity.setKefuUseStatus(-1);
                            updateEntity.setCreateDate(DateUtils.getAddDateByDay((Date)v.getCreateDate(), (int)1));
                            updateEntity.setCreateTime(DateUtils.getAddDateByDay((Date)v.getCreateTime(), (int)1));
                            updateEntity.setReason("\u5f53\u65e5:" + DateUtils.formatDate((Date)v.getCreateDate(), (String)"yyyy-MM-dd") + "\u9650\u91cf" + qiWeiLimitCount + " \u6d41\u8f6c\u5230\u4e0b\u4e00\u5929");
                            if (StringUtils.isNotEmpty((String)v.getRemark())) {
                                updateEntity.setRemark(v.getRemark() + "," + updateEntity.getReason());
                                if (updateEntity.getRemark().length() > 255) {
                                    updateEntity.setRemark(updateEntity.getRemark().substring(0, 254));
                                }
                            } else {
                                updateEntity.setRemark(updateEntity.getReason());
                            }
                        }
                    }
                    if (!date.equals(v.getCreateDate())) {
                        this.redisCacheUtil.set(v.getCustomerId() + "_" + v.getQyWeixinUserId() + "_" + date, (Object)"1", Long.valueOf(86400L));
                    }
                    if (StringUtils.isNotEmpty((String)v.getPushText()) && v.getPushText().indexOf("miniprogram") > 0) {
                        updateEntity.setPushText(this.materialInterface.replateMiniTagToHref(v.getPushText()));
                    }
                    if (StringUtils.isNotEmpty((String)v.getPushText1()) && v.getPushText1().indexOf("miniprogram") > 0) {
                        updateEntity.setPushText1(this.materialInterface.replateMiniTagToHref(v.getPushText1()));
                    }
                    list.add(updateEntity);
                    this.remoteCache(v.getId());
                }
                if (!CollectionUtils.isNotEmpty(list)) continue;
                try {
                    int n = this.routeCustomerMapper.updateForMaterialRulebatchUpdate(list);
                }
                catch (Exception e2) {
                    this.logger.error("\u6267\u884c\u51fa\u9519:{}", new Object[]{"\u66f4\u65b0\u7d20\u6750\u89c4\u5219", e2.getMessage(), e2});
                }
            }
        }
        catch (Exception e3) {
            this.logger.error("\u66f4\u65b0\u7528\u6237\u65c5\u7a0b\u8bb0\u5f55:{}", (Object)e3.getMessage(), (Object)e3);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public List<RouteCustomerEntityRuleVo> getRouteIsSendInLastDay(String customerId, Integer days, Integer materialId, Integer groupId) {
        return this.routeCustomerMapper.getRouteIsSendInLastDay(customerId, days, materialId, groupId);
    }

    @Override
    public BaseJsonVo noWorkSopTransfer() {
        Date date = DateUtils.currentDate();
        CalendarEntity calendarEntity = (CalendarEntity)this.calendarInterface.selectByPrimaryKey(date);
        String workUsers = "";
        String noWorkUsers = "";
        if (calendarEntity == null) {
            return BaseJsonVo.error((String)"\u5de5\u4f5c\u65e5\u5386\u4e0d\u5b58\u5728");
        }
        RouteCustomerEntity routeCustomerEntity = new RouteCustomerEntity();
        routeCustomerEntity.setCreateDate(date);
        routeCustomerEntity.setKefuUseStatus(0);
        if (Integer.valueOf(0).equals(calendarEntity.getQyWorkType()) && StringUtils.isNotEmpty((String)(noWorkUsers = calendarEntity.getQyWeixinUserId()))) {
            String[] noWorkUserArr;
            for (String w : noWorkUserArr = noWorkUsers.split(",")) {
                routeCustomerEntity.setQyWeixinUserid(w);
                this.transfer(date, this.routeCustomerMapper.getNoWorkTransferList(routeCustomerEntity), this.routeCustomerMapper.getNoWorkNoTransferList(routeCustomerEntity));
            }
        }
        if (Integer.valueOf(1).equals(calendarEntity.getQyWorkType())) {
            workUsers = calendarEntity.getQyWeixinUserId();
            List<RouteCustomerEntity> lst = this.routeCustomerMapper.getNoWorkTransferList(routeCustomerEntity);
            List<RouteCustomerEntity> nolst = this.routeCustomerMapper.getNoWorkNoTransferList(routeCustomerEntity);
            if (StringUtils.isNotEmpty((String)workUsers)) {
                String[] workUserArr = workUsers.split(",");
                lst.removeAll(lst.stream().filter(c -> Arrays.stream(workUserArr).collect(Collectors.toList()).contains(c.getQyWeixinUserid())).collect(Collectors.toList()));
                nolst.removeAll(nolst.stream().filter(c -> Arrays.stream(workUserArr).collect(Collectors.toList()).contains(c.getQyWeixinUserid())).collect(Collectors.toList()));
            }
            this.transfer(date, lst, nolst);
        }
        return BaseJsonVo.success((Object)"\u5904\u7406\u5b8c\u6210");
    }

    public BaseJsonVo transfer(Date date, List<RouteCustomerEntity> lst, List<RouteCustomerEntity> noTransferList) {
        if (noTransferList != null) {
            for (RouteCustomerEntity r : noTransferList) {
                r.setKefuUseStatus(-2);
                r.setRemark("\u914d\u7f6e\u4e3a\u4e0d\u6d41\u8f6c");
                this.updateByPrimaryKeySelective(r);
            }
        }
        Map<String, List<RouteCustomerEntity>> customerMap = lst.stream().collect(Collectors.groupingBy(RouteCustomerEntity::getQyWeixinUserid));
        for (String c : customerMap.keySet()) {
            CalendarEntity calendarEntity = this.calendarInterface.getNextWorkDay(date, c);
            if (calendarEntity == null) continue;
            int rows = customerMap.get(c).size();
            int days = 2;
            int size = rows / days;
            int i = 0;
            int day = 1;
            Date nextDate = calendarEntity.getDate();
            for (RouteCustomerEntity ce : customerMap.get(c)) {
                if (++i > size * day) {
                    nextDate = DateUtils.getAddDateByDay((Date)calendarEntity.getDate(), (int)day);
                    ++day;
                }
                ce.setCreateDate(nextDate);
                ce.setCreateTime(nextDate);
                ce.setKefuUseStatus(-1);
                ce.setRemark("[\u975e\u5de5\u4f5c\u65e5\u6d41\u8f6c]\u6765\u81ea" + DateUtils.formatDate((Date)date, (String)"MM\u6708dd\u65e5"));
                this.updateByPrimaryKeySelective(ce);
                this.logger.info("\u4f01\u5fae\uff1a" + c + ",\u6d41\u8f6crouteId:" + ce.getRouteId() + ",\u65e5\u671f:" + nextDate + ",day:" + day + ",rows:" + rows);
            }
        }
        return BaseJsonVo.success((Object)"\u5904\u7406\u5b8c\u6210");
    }

    @Override
    public BaseJsonVo workDayTransfer(Date unFinishDate, Date transferDate, Integer days) {
        if (unFinishDate == null || days == null || transferDate == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CalendarEntity calendarEntity = (CalendarEntity)this.calendarInterface.selectByPrimaryKey(unFinishDate);
        if (calendarEntity == null) {
            return BaseJsonVo.error((String)"\u5de5\u4f5c\u65e5\u5386\u4e0d\u5b58\u5728");
        }
        if (calendarEntity.getIsHoliday().intValue() != 0) {
            return BaseJsonVo.error((String)"\u4e0d\u662f\u5de5\u4f5c\u65e5\uff0c\u4e0d\u8fdb\u884c\u5de5\u4f5c\u65e5\u6d41\u8f6c");
        }
        List<RouteCustomerEntity> lst = this.routeCustomerMapper.getWorkDayUnFinishSop(DateUtils.StrToDate((String)DateUtils.formatDate((Date)unFinishDate, (String)"yyyy-MM-dd")));
        int size = lst.size() / days;
        int i = 0;
        int day = 1;
        Date nextDate = transferDate;
        for (RouteCustomerEntity c : lst) {
            Integer id = c.getId();
            if (++i > size * day) {
                nextDate = DateUtils.getAddDateByDay((Date)transferDate, (int)day);
                ++day;
            }
            c.setId(null);
            c.setKefuUseStatus(-1);
            c.setCreateDate(nextDate);
            c.setCreateTime(nextDate);
            c.setRemark("\u5de5\u4f5c\u65e5\u5269\u4f59\u6d41\u8f6c\uff0c\u6765\u81ea" + unFinishDate);
            this.routeCustomerMapper.insertSelective(c);
            c = new RouteCustomerEntity();
            c.setId(id);
            c.setKefuUseTime(new Date());
            c.setRemark("\u5de5\u4f5c\u65e5\u672a\u5b8c\u6210\uff0c\u88ab\u6d41\u8f6c\u5230" + nextDate);
            this.routeCustomerMapper.updateByPrimaryKeySelective(c);
        }
        return BaseJsonVo.success((Object)"\u5de5\u4f5c\u65e5\u6d41\u8f6c\u6210\u529f");
    }

    @Override
    public boolean updateRouteCustomerDisabled(Integer routeId) {
        return this.routeCustomerMapper.updateRouteCustomerDisabled(routeId, -3) > 0;
    }

    @Override
    public Map getTodaySopCount(String date) {
        return this.routeCustomerMapper.getTodaySopCount(date);
    }

    @Override
    public List<Map> getSopCountByDate(String sdate, String edate) {
        return this.routeCustomerMapper.getSopCountByDate(sdate, edate);
    }

    @Override
    public BaseJsonVo sopInherit(SopInherit sopInherit) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        int count = 0;
        for (String qyWeixinUserid : sopInherit.getTo()) {
            MallUserEntity userQuery = new MallUserEntity();
            userQuery.setQyWeixinUserid(qyWeixinUserid);
            MallUserEntity mallUserEntity = (MallUserEntity)this.mallUserInterface.getSingle(userQuery);
            count += this.routeCustomerMapper.sopInherit(sopInherit.getDate(), mallUserEntity.getUserId(), qyWeixinUserid);
            this.logger.info("userId={},qyWeixinUserid={}", (Object)mallUserEntity.getUserId(), (Object)qyWeixinUserid);
        }
        result.put("count", count);
        return BaseJsonVo.success(result);
    }

    public BaseJsonVo<PageInfo<UnPushCustomerInfo>> getUnPushCustomerList(Integer currentPage, Integer pageSize, Integer day, String customerId, String externalUserid, String qyWeixinUserid, String nickName, Integer userOrderType, Integer appId) {
        CustomerDetailVo customerDetailVo;
        if (StringUtils.isNotEmpty((String)externalUserid) && StringUtils.isEmpty((String)customerId) && (customerDetailVo = this.customerInterface.getCustomerDetailByOpenid(externalUserid)) != null) {
            customerId = customerDetailVo.getCustomerId();
        }
        PageInfo pageInfo = new PageInfo();
        BaseJsonVo<PageInfo<JSONObject>> baseJsonVo = this.biRouteCustomerInvoke.getUnPushCustomerList(currentPage, pageSize, day, customerId, qyWeixinUserid, nickName, userOrderType);
        if (baseJsonVo.isSuccess()) {
            ArrayList<UnPushCustomerInfo> tempList = new ArrayList<UnPushCustomerInfo>();
            for (JSONObject item : ((PageInfo)baseJsonVo.getValue()).getList()) {
                try {
                    UnPushCustomerInfo unPushCustomerInfo = (UnPushCustomerInfo)JsonUtils.fromJson((String)item.toJSONString(), UnPushCustomerInfo.class);
                    unPushCustomerInfo.setUserStatusName(unPushCustomerInfo.getUserStatus() == null ? "\u6b63\u5e38" : (item.getInteger("userStatus") == 10 ? "\u514d\u6253\u6270" : "\u81ea\u5df1\u4eba"));
                    unPushCustomerInfo.setUserOrderTypeName(UserOrderTypeEnum.getName(unPushCustomerInfo.getUserOrderType()));
                    tempList.add(unPushCustomerInfo);
                }
                catch (IOException e) {
                    this.logger.error("\u5bf9\u8c61\u8f6c\u6362\u5931\u8d25:{}", (Object)item.toJSONString(), (Object)e);
                }
            }
            pageInfo.setList(tempList);
            pageInfo.setTotal(((PageInfo)baseJsonVo.getValue()).getTotal());
        }
        return BaseJsonVo.success((Object)pageInfo);
    }

    @Override
    public BaseJsonVo getCustomerList(Integer currentPage, Integer pageSize, String customerId, String externalUserid, String qyWeixinUserid, String nickName, Integer appId) {
        if (StringUtils.isNotEmpty((String)externalUserid) && StringUtils.isEmpty((String)customerId)) {
            CustomerDetailVo customerDetailVo = this.customerInterface.getCustomerDetailByOpenid(externalUserid);
            if (customerDetailVo != null) {
                customerId = customerDetailVo.getCustomerId();
                this.logger.info("externalUserid={},customerId={}", (Object)externalUserid, (Object)customerId);
            } else {
                return BaseJsonVo.error((String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
            }
        }
        PageInfo pageInfo = new PageInfo();
        BaseJsonVo<PageInfo<JSONObject>> baseJsonVo = this.biRouteCustomerInvoke.getCustomerList(currentPage, pageSize, customerId, qyWeixinUserid, nickName);
        if (baseJsonVo.isSuccess()) {
            ArrayList<UnPushCustomerInfo> tempList = new ArrayList<UnPushCustomerInfo>();
            for (JSONObject item : ((PageInfo)baseJsonVo.getValue()).getList()) {
                try {
                    UnPushCustomerInfo unPushCustomerInfo = (UnPushCustomerInfo)JsonUtils.fromJson((String)item.toJSONString(), UnPushCustomerInfo.class);
                    unPushCustomerInfo.setUserStatusName(unPushCustomerInfo.getUserStatus() == null ? "\u6b63\u5e38" : (item.getInteger("userStatus") == 10 ? "\u514d\u6253\u6270" : "\u81ea\u5df1\u4eba"));
                    unPushCustomerInfo.setUserOrderTypeName(UserOrderTypeEnum.getName(unPushCustomerInfo.getUserOrderType()));
                    tempList.add(unPushCustomerInfo);
                }
                catch (IOException e) {
                    this.logger.error("\u5bf9\u8c61\u8f6c\u6362\u5931\u8d25:{}", (Object)item.toJSONString(), (Object)e);
                }
            }
            pageInfo.setList(tempList);
            pageInfo.setTotal(((PageInfo)baseJsonVo.getValue()).getTotal());
        }
        return BaseJsonVo.success((Object)pageInfo);
    }

    @Override
    public List<Map> getSopSendHistory(String customerId) {
        if (StringUtils.isEmpty((String)customerId)) {
            return new ArrayList<Map>();
        }
        return this.routeCustomerMapper.getSopSendHistory(customerId);
    }
}

