/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.route;

import cc.lechun.apiinvoke.mall.AccessTokenInvoke;
import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.object.BeanUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.user.MallUserInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.scrm.dao.route.RouteLinkMapper;
import cc.lechun.scrm.entity.AppEnum;
import cc.lechun.scrm.entity.action.ActionEntity;
import cc.lechun.scrm.entity.cron.CronEntity;
import cc.lechun.scrm.entity.material.MaterialEntity;
import cc.lechun.scrm.entity.route.RouteCustomerEntity;
import cc.lechun.scrm.entity.route.RouteEntity;
import cc.lechun.scrm.entity.route.RouteLinkEntity;
import cc.lechun.scrm.entity.route.RouteRecordEntity;
import cc.lechun.scrm.entity.scene.SceneEntity;
import cc.lechun.scrm.iservice.action.ActionInterface;
import cc.lechun.scrm.iservice.cron.CronInterface;
import cc.lechun.scrm.iservice.material.MaterialInterface;
import cc.lechun.scrm.iservice.route.RouteCustomerInterface;
import cc.lechun.scrm.iservice.route.RouteInterface;
import cc.lechun.scrm.iservice.route.RouteLinkInterface;
import cc.lechun.scrm.iservice.route.RouteRecordInterface;
import cc.lechun.scrm.iservice.scene.SceneInterface;
import cc.lechun.utils.DateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.popular.api.qy.WxApiUtils;
import weixin.popular.bean.qy.appMessage.MessageResult;

@Service
public class RouteLinkService
extends BaseService<RouteLinkEntity, String>
implements RouteLinkInterface {
    @Autowired
    RedisService redisService;
    @Resource
    private RouteLinkMapper routeLinkMapper;
    @Autowired
    private ActionInterface actionInterface;
    @Autowired
    private SceneInterface sceneInterface;
    @Autowired
    private MaterialInterface materialInterface;
    @Autowired
    @Lazy
    private RouteCustomerInterface routeCustomerInterface;
    @Autowired
    private MallUserInterface mallUserInterface;
    @Autowired
    private CronInterface cronInterface;
    @Autowired
    @Lazy
    private RouteInterface routeInterface;
    @Autowired
    private WeiXinBaseInterface weiXinBaseInterface;
    @Autowired
    private RouteRecordInterface routeRecordInterface;
    @Autowired
    private AccessTokenInvoke accessTokenInvoke;

    @Override
    public List<RouteLinkEntity> getRouteLinks(Integer routeId) {
        if (routeId != null) {
            RouteLinkEntity routeLinkEntity = new RouteLinkEntity();
            routeLinkEntity.setRouteId(routeId);
            return this.getList(routeLinkEntity);
        }
        return new ArrayList<RouteLinkEntity>();
    }

    @Override
    public BaseJsonVo getRouteLinksMap(Integer routeId) {
        List<RouteLinkEntity> lst = this.getRouteLinks(routeId);
        lst = lst.stream().sorted((e, f) -> e.getSort().compareTo(f.getSort())).collect(Collectors.toList());
        LinkedList<Map> mapList = new LinkedList<Map>();
        for (RouteLinkEntity r : lst) {
            Map m = BeanUtils.beanToMap((Object)r);
            m.put("actionDetailName", this.getActionDetailName(r.getActionType(), r.getActionDetailId()));
            ActionEntity actionEntity = (ActionEntity)this.actionInterface.selectByPrimaryKey(r.getActionId());
            if (actionEntity != null) {
                m.put("actionClass", actionEntity.getActionClass());
            }
            mapList.add(m);
        }
        return BaseJsonVo.success(mapList);
    }

    private String getActionDetailName(Integer actionType, Integer actionDetailId) {
        String result = "\u6682\u672a\u914d\u7f6e";
        if (actionDetailId == null) {
            return result;
        }
        switch (actionType) {
            case 1: {
                SceneEntity sceneEntity = (SceneEntity)this.sceneInterface.selectByPrimaryKey(actionDetailId);
                if (sceneEntity == null) break;
                result = sceneEntity.getSceneName();
                break;
            }
            case 2: {
                CronEntity cronEntity = (CronEntity)this.cronInterface.selectByPrimaryKey(actionDetailId);
                if (cronEntity == null) break;
                result = cronEntity.getCronName();
                break;
            }
            case 3: {
                MaterialEntity materialEntity = (MaterialEntity)this.materialInterface.selectByPrimaryKey(actionDetailId);
                if (materialEntity == null) break;
                result = materialEntity.getMaterialName();
                break;
            }
            case 4: {
                MaterialEntity materialEntity1 = (MaterialEntity)this.materialInterface.selectByPrimaryKey(actionDetailId);
                if (materialEntity1 == null) break;
                result = materialEntity1.getMaterialName();
                break;
            }
            case 5: {
                result = "\u53d1\u9001\u94fe\u63a5\u7ed9\u4f01\u5fae\u5ba2\u670d";
            }
        }
        return result;
    }

    @Override
    @Transactional
    public BaseJsonVo saveRouteLinks(List<RouteLinkEntity> lst) {
        BaseJsonVo jsonVo = BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        if (lst.size() <= 0 || !(jsonVo = this.deleteRouteLinks(lst.get(0).getRouteId())).isSuccess()) {
            // empty if block
        }
        this.recursionSort(lst, null, 1);
        for (RouteLinkEntity rl : lst) {
            jsonVo = this.saveRouteLink(rl);
            if (jsonVo.isSuccess()) continue;
            return jsonVo;
        }
        return jsonVo;
    }

    @Override
    public void recursionSort(List<RouteLinkEntity> routeLinks, String pId, Integer initsSort) {
        List topRouteLinks = routeLinks.stream().filter(c -> pId == null ? c.getParentId() == null : c.getParentId() != null && c.getParentId().contains(pId)).collect(Collectors.toList());
        if (topRouteLinks.size() == 0) {
            return;
        }
        for (RouteLinkEntity linkEntity : topRouteLinks) {
            if (linkEntity.getParentId() != null && pId != null) {
                String[] arr;
                for (String a : arr = linkEntity.getParentId().split(",")) {
                    if (pId.equals(a)) continue;
                }
            }
            linkEntity.setSort(initsSort);
            this.recursionSort(routeLinks, linkEntity.getId(), initsSort + 1);
        }
    }

    @Override
    public BaseJsonVo deleteRouteLinks(Integer routeId) {
        if (routeId == null) {
            return BaseJsonVo.error((String)"\u65c5\u7a0bId\u4e3a\u7a7a");
        }
        RouteLinkEntity linkEntity = new RouteLinkEntity();
        linkEntity.setRouteId(routeId);
        List lst = this.getList(linkEntity);
        for (RouteLinkEntity rl : lst) {
            if (rl.getId() == null) continue;
            this.deleteByPrimaryKey((Serializable)((Object)rl.getId()));
        }
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Override
    @Transactional
    public BaseJsonVo saveRouteLink(RouteLinkEntity routeLinkEntity) {
        int i;
        ActionEntity actionEntity;
        if (routeLinkEntity.getActionId() == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u52a8\u4f5c");
        }
        if (StringUtils.isEmpty((String)routeLinkEntity.getId())) {
            routeLinkEntity.setId(UUID.randomUUID().toString());
        }
        if ((actionEntity = (ActionEntity)this.actionInterface.selectByPrimaryKey(routeLinkEntity.getActionId())) == null) {
            return BaseJsonVo.error((String)"\u52a8\u4f5c\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        routeLinkEntity.setActionName(actionEntity.getActionName());
        routeLinkEntity.setActionType(actionEntity.getActionType());
        if (routeLinkEntity.getActionDetailId() == null) {
            // empty if block
        }
        if (routeLinkEntity.getCreateTime() == null) {
            routeLinkEntity.setCreateTime(new Date());
        }
        if ((i = this.insertOrUpdate(routeLinkEntity)) > 0) {
            if (Integer.valueOf(2).equals(routeLinkEntity.getActionType()) && routeLinkEntity.getActionDetailId() != null) {
                RouteEntity routeEntity = new RouteEntity();
                routeEntity.setId(routeLinkEntity.getRouteId());
                routeEntity.setCronId(routeLinkEntity.getActionDetailId());
                this.routeInterface.updateByPrimaryKeySelective(routeEntity);
            }
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    @Transactional
    public BaseJsonVo execRouteLik(Integer routeId) {
        try {
            RouteRecordEntity recordEntity = new RouteRecordEntity();
            recordEntity.setRouteId(routeId);
            recordEntity.setCreateDate(new Date());
            recordEntity.setCreateTime(new Date());
            recordEntity.setExecStatus(0);
            String routeRecordId = this.routeRecordInterface.saveReouteRecord(recordEntity);
            if (StringUtils.isEmpty((String)routeRecordId)) {
                return BaseJsonVo.error((String)"\u65c5\u7a0b\u8bb0\u5f55\u9519\u8bef");
            }
            List<RouteLinkEntity> routeLinks = this.getRouteLinks(routeId);
            List topRouteLinks = routeLinks.stream().filter(c -> c.getParentId() == null).collect(Collectors.toList());
            for (RouteLinkEntity r : topRouteLinks) {
                ArrayList<RouteLinkEntity> tmp = new ArrayList<RouteLinkEntity>();
                tmp.add(r);
                this.recursion(routeLinks, tmp, r.getActionDetailId(), routeRecordId);
            }
            recordEntity.setExecStatus(1);
            RouteCustomerEntity routeCustomerEntity = new RouteCustomerEntity();
            routeCustomerEntity.setRouteRecordId(routeRecordId);
            routeCustomerEntity.setRouteId(routeId);
            Integer i = this.routeCustomerInterface.existsByEntity(routeCustomerEntity);
            recordEntity.setSceneUserCount(i);
            recordEntity.setId(routeRecordId);
            this.routeRecordInterface.updateByPrimaryKeySelective(recordEntity);
        }
        catch (Exception e) {
            this.logger.error("\u6267\u884c\u5931\u8d25", (Throwable)e);
            return BaseJsonVo.error((String)("\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return BaseJsonVo.success((Object)"\u6267\u884c\u5b8c\u6210");
    }

    public void recursion(List<RouteLinkEntity> routeLinks, List<RouteLinkEntity> topRouteLinks, Integer sceneId, String routeRecordId) {
        for (RouteLinkEntity linkEntity : topRouteLinks) {
            BaseJsonVo baseJsonVo = this.execAction(linkEntity, sceneId, routeRecordId);
            if (baseJsonVo.isSuccess()) {
                String pId = linkEntity.getId();
                List<RouteLinkEntity> children = routeLinks.stream().filter(c -> pId.equals(c.getParentId())).collect(Collectors.toList());
                if (children.size() == 0) break;
                this.recursion(routeLinks, children, sceneId, routeRecordId);
                continue;
            }
            this.logger.error("\u65c5\u7a0b:{}\u6267\u884c\u51fa\u9519:{}", (Object)linkEntity.getRouteId(), (Object)baseJsonVo.getMessage());
        }
    }

    public BaseJsonVo execAction(RouteLinkEntity linkEntity, Integer sceneId, String routeRecordId) {
        BaseJsonVo baseJsonVo = BaseJsonVo.error((String)"\u7b49\u5f85\u6267\u884c");
        this.logger.info("\u6267\u884c\uff1a" + linkEntity.getActionType());
        switch (linkEntity.getActionType()) {
            case 1: {
                if (this.sceneInterface.buildSceneCustomers(linkEntity.getActionDetailId()).isSuccess()) {
                    baseJsonVo = this.routeCustomerInterface.execRouteCustomers(sceneId, linkEntity.getRouteId(), routeRecordId, linkEntity.getId());
                    break;
                }
                baseJsonVo = BaseJsonVo.error((String)"\u7fa4\u7ec4\u6267\u884c\u9519\u8bef");
                break;
            }
            case 2: {
                baseJsonVo = BaseJsonVo.success((Object)"\u6267\u884c\u6210\u529f");
                break;
            }
            case 3: {
                baseJsonVo = this.routeCustomerInterface.execMaterial(linkEntity.getActionDetailId(), sceneId, linkEntity.getRouteId(), routeRecordId);
                break;
            }
            case 4: {
                baseJsonVo = this.execInsideMaterial(linkEntity);
                break;
            }
            case 5: {
                baseJsonVo = this.execSendService(linkEntity);
            }
        }
        String name = this.getActionDetailName(linkEntity.getActionType(), linkEntity.getActionDetailId());
        String remark = (name == null ? "" : name) + "(" + DateUtils.now((String)"HH:mm:ss") + ")," + baseJsonVo.isSuccess() + "," + (baseJsonVo.getMessage() == null ? "" : baseJsonVo.getMessage());
        this.logger.info(remark);
        if (remark.length() > 500) {
            remark = remark.substring(0, 500);
        }
        this.changeMessage(linkEntity.getId(), remark);
        return baseJsonVo;
    }

    private BaseJsonVo changeMessage(String linkId, String message) {
        if (StringUtils.isEmpty((String)linkId)) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u65c5\u7a0b");
        }
        RouteLinkEntity linkEntity = new RouteLinkEntity();
        linkEntity.setId(linkId);
        linkEntity.setRemark(message);
        this.updateByPrimaryKeySelective(linkEntity);
        return BaseJsonVo.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    public BaseJsonVo execInsideMaterial(RouteLinkEntity linkEntity) {
        BaseJsonVo jsonVo = this.materialInterface.getMaterial(linkEntity);
        if (jsonVo.isSuccess()) {
            String txt = jsonVo.getValue().toString();
            linkEntity.setRemark(txt);
            this.updateByPrimaryKeySelective(linkEntity);
        }
        return BaseJsonVo.success((Object)"\u5185\u90e8\u7d20\u6750\u6210\u529f");
    }

    public BaseJsonVo execSendService(RouteLinkEntity linkEntity) {
        RouteLinkEntity parent = new RouteLinkEntity();
        parent.setActionType(4);
        parent.setRouteId(linkEntity.getRouteId());
        parent = (RouteLinkEntity)this.getSingle(parent);
        String text = "";
        if (parent != null) {
            Integer materialId = parent.getActionDetailId();
            if (materialId != null) {
                Map map = this.materialInterface.getMaterialWithType(materialId);
                if (map != null) {
                    WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseInterface.getWeiXinBase(10);
                    BaseJsonVo jsonVo = this.accessTokenInvoke.getAccessTokenValueByPlatformId(7);
                    List<Object> serviceList = new ArrayList();
                    if (map.get("pushText") != null) {
                        text = map.get("pushText").toString();
                        if (text != "") {
                            RouteCustomerEntity routeCustomerEntity = new RouteCustomerEntity();
                            routeCustomerEntity.setCreateDate(DateUtils.currentDate());
                            routeCustomerEntity.setRouteId(linkEntity.getRouteId());
                            serviceList = this.routeCustomerInterface.getServiceList(routeCustomerEntity);
                            if (weiXinBaseEntity != null && jsonVo.isSuccess()) {
                                MessageResult m = new MessageResult();
                                this.logger.info("\u53d1\u9001\u4f01\u5fae\u4eba\u6570:" + serviceList.size());
                                for (String string : serviceList) {
                                    String key = "Scrm.RouteLink.serviceList." + string;
                                    if (this.redisCacheUtil.get(key) != null) {
                                        this.logger.info("\u4f01\u5fae:{},{},\u5df2\u5b58\u5728\u63a8\u9001\u8bb0\u5f55", (Object)string, (Object)text);
                                        continue;
                                    }
                                    try {
                                        String message = (String)jsonVo.getValue();
                                        if (map.containsKey("appId") && Objects.equals(Integer.valueOf(map.get("appId").toString()), AppEnum.SALES.getValue())) {
                                            message = ((String)jsonVo.getValue()).replace("http://csms.lechun.cc/routeCustomerList", "https://sales.lechun.cc/routecustomerlist");
                                            message = message.replace("\u552e\u540e\u7cfb\u7edf", "\u5206\u9500\u7cfb\u7edf");
                                        }
                                        if (DateUtil.getCurrentHour() >= 22 || DateUtil.getCurrentHour() < 8) continue;
                                        m = WxApiUtils.sendAppTextMessage((String)message, (Integer)Integer.valueOf(weiXinBaseEntity.getMchId()), (String)string, (String)text);
                                        this.logger.info("\u4f01\u5fae:{},{},\u6d88\u606f\u63a8\u9001\u7ed3\u679c:{}", new Object[]{string, text, m.getErrcode()});
                                        this.redisCacheUtil.set(key, (Object)string, Long.valueOf(300L));
                                        this.redisService.setExpire(key, 5L, TimeUnit.MINUTES);
                                    }
                                    catch (Exception exception) {}
                                }
                                if (m.isSuccess()) {
                                    return BaseJsonVo.success((Object)"\u53d1\u9001\u6210\u529f");
                                }
                                return BaseJsonVo.error((String)("\u53d1\u9001\u5931\u8d25:" + m.getErrmsg()));
                            }
                            return BaseJsonVo.error((String)"\u4f01\u5fae\u53f7\u914d\u7f6e\u4e0d\u5b58\u5728");
                        }
                        return BaseJsonVo.error((String)"\u5185\u90e8\u7d20\u6750-\u6587\u672c\u7d20\u6750\u4e3a\u7a7a");
                    }
                    return BaseJsonVo.error((String)"\u6682\u65f6\u53ea\u652f\u6301\u6587\u672c\u5185\u90e8\u7d20\u6750");
                }
                return BaseJsonVo.error((String)"\u5185\u90e8\u7d20\u6750\u4e3a\u7a7a");
            }
            return BaseJsonVo.error((String)"\u6ca1\u6709\u9009\u62e9\u5185\u90e8\u7d20\u6750");
        }
        return BaseJsonVo.error((String)"\u5185\u90e8\u7d20\u6750\u4e0d\u5b58\u5728");
    }
}

