/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.route;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.scrm.dao.route.RouteRecordMapper;
import cc.lechun.scrm.entity.route.RouteRecordEntity;
import cc.lechun.scrm.iservice.route.RouteRecordInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RouteRecordService
extends BaseService<RouteRecordEntity, String>
implements RouteRecordInterface {
    @Resource
    private RouteRecordMapper routeRecordMapper;

    @Override
    public String saveReouteRecord(RouteRecordEntity recordEntity) {
        RouteRecordEntity search;
        if (recordEntity == null) {
            return "";
        }
        if (recordEntity.getRouteId() == null) {
            return "";
        }
        if (recordEntity.getCreateDate() == null) {
            return "";
        }
        if (recordEntity.getId() != null) {
            search = (RouteRecordEntity)this.selectByPrimaryKey((Serializable)((Object)recordEntity.getId()));
            if (search != null) {
                return search.getId();
            }
        } else {
            recordEntity.setId(UUID.randomUUID().toString());
        }
        search = new RouteRecordEntity();
        search.setCreateDate(DateUtils.currentDate());
        search.setRouteId(recordEntity.getRouteId());
        search = (RouteRecordEntity)this.getSingle(search);
        if (search != null) {
            return search.getId();
        }
        this.insertSelective(recordEntity);
        return recordEntity.getId();
    }

    @Override
    public List<RouteRecordEntity> getRouteRecords(Integer routeId) {
        if (routeId == null) {
            return new ArrayList<RouteRecordEntity>();
        }
        RouteRecordEntity search = new RouteRecordEntity();
        search.setRouteId(routeId);
        return this.getList(search);
    }

    @Override
    public boolean existsRouteRecords(Integer routeId) {
        if (routeId == null) {
            return false;
        }
        RouteRecordEntity search = new RouteRecordEntity();
        search.setRouteId(routeId);
        return this.existsByEntity(search) > 0;
    }

    @Override
    public Integer getRouteRecords(Integer routeId, Date date) {
        if (routeId == null) {
            return 0;
        }
        RouteRecordEntity search = new RouteRecordEntity();
        search.setRouteId(routeId);
        search.setCreateDate(date);
        List lst = this.getList(search, 0L);
        if (lst.size() > 0) {
            return ((RouteRecordEntity)lst.get(0)).getSceneUserCount() == null ? 0 : ((RouteRecordEntity)lst.get(0)).getSceneUserCount();
        }
        return 0;
    }
}

