/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.route;

import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.object.BeanUtils;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.MallUserInterface;
import cc.lechun.scrm.dao.route.RouteMapper;
import cc.lechun.scrm.entity.cron.CronEntity;
import cc.lechun.scrm.entity.route.RouteEntity;
import cc.lechun.scrm.entity.route.RouteEntityVo;
import cc.lechun.scrm.entity.route.RouteLinkEntity;
import cc.lechun.scrm.entity.route.RouteSceneVo;
import cc.lechun.scrm.entity.scene.SceneEntity;
import cc.lechun.scrm.iservice.cron.CronInterface;
import cc.lechun.scrm.iservice.group.SceneRouteGroupRefInterface;
import cc.lechun.scrm.iservice.route.RouteCustomerInterface;
import cc.lechun.scrm.iservice.route.RouteInterface;
import cc.lechun.scrm.iservice.route.RouteLinkInterface;
import cc.lechun.scrm.iservice.route.RouteRecordInterface;
import cc.lechun.scrm.iservice.run.RunRecordInterface;
import cc.lechun.scrm.iservice.scene.SceneInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class RouteService
extends BaseService<RouteEntity, Integer>
implements RouteInterface {
    @Resource
    private RouteMapper routeMapper;
    @Autowired
    private RouteLinkInterface routeLinkInterface;
    @Autowired
    private RouteRecordInterface routeRecordInterface;
    @Autowired
    private RouteCustomerInterface routeCustomerInterface;
    @Autowired
    private SceneInterface sceneInterface;
    @Autowired
    private RunRecordInterface runRecordInterface;
    @Autowired
    private CronInterface cronInterface;
    @Autowired
    private MallUserInterface mallUserInterface;
    @Autowired
    private SceneRouteGroupRefInterface sceneRouteGroupRefInterface;

    @Override
    public BaseJsonVo saveRoute(RouteEntity routeEntity) {
        if (routeEntity.getId() == null) {
            RouteEntity search = new RouteEntity();
            search.setRouteName(routeEntity.getRouteName());
            search.setAppId(routeEntity.getAppId());
            if (this.routeMapper.existsByEntity(search) > 0) {
                return BaseJsonVo.error((String)"\u65c5\u7a0b\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
            }
        }
        if (routeEntity.getStatus() == null) {
            routeEntity.setStatus(0);
        }
        routeEntity.setRouteRun(2);
        int i = this.insertOrUpdate(routeEntity);
        return BaseJsonVo.success((Object)"\u65c5\u7a0b\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public BaseJsonVo changeRouteStatus(Integer routeId, Integer status, Integer disableSop) {
        if (routeId != null && status != null) {
            RouteEntity routeEntity = new RouteEntity();
            routeEntity = (RouteEntity)this.selectByPrimaryKey(routeId);
            if (routeEntity == null) {
                return BaseJsonVo.error((String)"\u65c5\u7a0b\u4e0d\u5b58\u5728");
            }
            if (Integer.valueOf(2).equals(status) && Objects.equals(disableSop, 1)) {
                this.routeCustomerInterface.updateRouteCustomerDisabled(routeId);
            }
            routeEntity.setStatus(status);
            this.updateByPrimaryKeySelective(routeEntity);
            return BaseJsonVo.success((Object)"\u8bbe\u7f6e\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u8bbe\u7f6e\u5931\u8d25");
    }

    @Override
    public BaseJsonVo deleteRoute(Integer routeId) {
        RouteEntity routeEntity;
        if (routeId != null && (routeEntity = (RouteEntity)this.selectByPrimaryKey(routeId)) != null) {
            if (Integer.valueOf(0).equals(routeEntity.getStatus()) || Integer.valueOf(2).equals(routeEntity.getStatus())) {
                if (this.routeRecordInterface.existsRouteRecords(routeId)) {
                    return BaseJsonVo.error((String)"\u5df2\u7ecf\u5b58\u5728\u65c5\u7a0b\u8bb0\u5f55\uff0c\u4e0d\u80fd\u5220\u9664");
                }
                this.routeLinkInterface.deleteRouteLinks(routeId);
                this.routeCustomerInterface.deleteRouteCustomer(routeId);
                this.deleteByPrimaryKey(routeId);
                return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
            }
            return BaseJsonVo.error((String)"\u5df2\u53d1\u5e03\u7684\u65c5\u7a0b\u4e0d\u80fd\u5220\u9664");
        }
        return BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @Override
    public BaseJsonVo startRoute(Integer routeId) {
        int status = 1;
        if (routeId == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u65c5\u7a0b");
        }
        List<RouteLinkEntity> lst = this.routeLinkInterface.getRouteLinks(routeId);
        if (lst.stream().filter(c -> Integer.valueOf(1).equals(c.getActionType())).count() == 0L) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u65c5\u7a0b\u4e2d\u5fc5\u987b\u5305\u542b\u7fa4\u7ec4");
        }
        if (lst.stream().filter(c -> Integer.valueOf(2).equals(c.getActionType())).count() == 0L) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u65c5\u7a0b\u4e2d\u5fc5\u987b\u5305\u542b\u5b9a\u65f6");
        }
        Integer cronId = 0;
        for (RouteLinkEntity l : lst) {
            switch (l.getActionType()) {
                case 1: {
                    if (l.getActionDetailId() != null) break;
                    return BaseJsonVo.error((String)"\u8bf7\u5728\u65c5\u7a0b\u4e2d\u8bbe\u7f6e\u7fa4\u7ec4");
                }
                case 2: {
                    if (l.getActionDetailId() == null) {
                        return BaseJsonVo.error((String)"\u8bf7\u5728\u65c5\u7a0b\u4e2d\u8bbe\u7f6e\u5b9a\u65f6");
                    }
                    cronId = l.getActionDetailId();
                    break;
                }
                case 3: {
                    if (l.getActionDetailId() != null) break;
                    return BaseJsonVo.error((String)"\u8bf7\u5728\u65c5\u7a0b\u4e2d\u8bbe\u7f6e\u7528\u6237\u7d20\u6750");
                }
                case 4: {
                    if (l.getActionDetailId() != null) break;
                    return BaseJsonVo.error((String)"\u8bf7\u5728\u65c5\u7a0b\u4e2d\u8bbe\u7f6e\u5185\u90e8\u7d20\u6750");
                }
            }
        }
        BaseJsonVo jsonVo = this.changeRouteStatus(routeId, status, 1);
        if (jsonVo.isSuccess() && Integer.valueOf(1).equals(cronId)) {
            this.execRoute(routeId);
        }
        return jsonVo;
    }

    @Override
    public BaseJsonVo execRoute(Integer routeId) {
        try {
            List lst;
            Date now = DateUtils.getDateFromString((String)DateUtils.now((String)"yyyy-MM-dd HH:mm"), (String)"yyyy-MM-dd HH:mm");
            RouteEntity routeEntity = new RouteEntity();
            routeEntity.setStatus(1);
            routeEntity.setRouteRun(2);
            if (routeId != null) {
                routeEntity.setId(routeId);
            }
            if (CollectionUtils.isEmpty((Collection)(lst = this.getList(routeEntity)))) {
                return BaseJsonVo.success((Object)"\u6267\u884c\u5b8c\u6210");
            }
            int threadNum = lst.size() == 1 ? 1 : 8;
            ExecutorService pool = Executors.newFixedThreadPool(threadNum);
            for (RouteEntity s : lst) {
                if (routeId != null || now.equals(s.getNextExecTime())) {
                    CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> this.execRoute2(s), pool);
                }
                this.getNextExecTime(s);
            }
            pool.shutdown();
        }
        catch (Exception e) {
            this.logger.error("\u65c5\u7a0b:{}\u6267\u884c\u5931\u8d25", (Object)routeId, (Object)e);
            return BaseJsonVo.success((Object)"\u6267\u884c\u5931\u8d25");
        }
        return BaseJsonVo.success((Object)"\u6267\u884c\u5b8c\u6210");
    }

    private void execRoute2(RouteEntity s) {
        try {
            Date beginTime = new Date();
            BaseJsonVo jsonVo = this.routeLinkInterface.execRouteLik(s.getId());
            this.runRecordInterface.saveRouteRunRecord(s.getId(), beginTime, new Date(), jsonVo.isSuccess() ? 1 : 0, jsonVo.getMessage());
            s.setLastExecTime(new Date());
            s.setMessage("\u6267\u884c\uff1a" + jsonVo.isSuccess() + "," + jsonVo.getMessage());
            this.updateByPrimaryKeySelective(s);
        }
        catch (Exception e) {
            this.logger.info("\u65c5\u7a0b:{}\u6267\u884c\u51fa\u9519", (Object)s.getRouteName(), (Object)e);
        }
    }

    private void getNextExecTime(RouteEntity s) {
        RouteLinkEntity linkEntity = new RouteLinkEntity();
        linkEntity.setRouteId(s.getId());
        linkEntity.setActionType(2);
        List linkEntities = this.routeLinkInterface.getList(linkEntity);
        ArrayList<Object> dates = new ArrayList<Object>();
        for (RouteLinkEntity l : linkEntities) {
            BaseJsonVo<Date> js = this.sceneInterface.isExecTime(l.getActionDetailId(), "\u65c5\u7a0b:" + s.getRouteName());
            if (!js.isSuccess()) continue;
            dates.add(js.getValue());
        }
        Collections.sort(dates);
        if (dates.size() > 0) {
            s.setNextExecTime((Date)dates.get(0));
            this.updateByPrimaryKeySelective(s);
        }
    }

    @Override
    public BaseJsonVo getServiceOption(Integer appId) {
        return BaseJsonVo.success(this.routeMapper.getqyServiceRoute());
    }

    @Override
    public BaseJsonVo getRoutePageList(Integer pageNum, Integer pageSize, RouteEntityVo routeEntity) {
        Page pages = PageHelper.startPage((int)pageNum, (int)pageSize, (String)"ROUTE_NAME desc");
        if (StringUtils.isNotEmpty((String)routeEntity.getRouteName())) {
            routeEntity.setRouteName(SqlUtils.sqlLike((String)routeEntity.getRouteName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        this.routeMapper.getRoutePageList(routeEntity);
        PageInfo pg = pages.toPageInfo();
        ArrayList<Map> result = new ArrayList<Map>();
        for (Object s : pg.getList()) {
            MallUserEntity mallUserEntity;
            SceneEntity sceneEntity;
            RouteLinkEntity routeLinkEntity;
            CronEntity cronEntity;
            Map map = BeanUtils.beanToMap(s);
            if (map.get("cronId") != null && (cronEntity = (CronEntity)this.cronInterface.selectByPrimaryKey(Integer.valueOf(map.get("cronId").toString()))) != null) {
                map.put("cronName", cronEntity.getCronName());
            }
            Object message = map.get("message");
            List<RouteLinkEntity> routeLinks = this.routeLinkInterface.getRouteLinks(Integer.valueOf(map.get("id").toString()));
            routeLinks = routeLinks.stream().sorted((e, f) -> e.getSort() == null ? 0 : e.getSort().compareTo(f.getSort())).collect(Collectors.toList());
            StringBuilder sb = new StringBuilder();
            for (RouteLinkEntity r : routeLinks) {
                sb.append((r.getActionName() == null ? "\u672a\u77e5\u52a8\u4f5c" : r.getActionName()) + ":" + (r.getRemark() == null ? "\u6267\u884c\u72b6\u6001\u672a\u77e5" : r.getRemark()) + "\r\n");
            }
            if (CollectionUtils.isNotEmpty(routeLinks) && (routeLinkEntity = routeLinks.get(0)) != null && routeLinkEntity.getActionId() == 1 && (sceneEntity = (SceneEntity)this.sceneInterface.selectByPrimaryKey(routeLinkEntity.getActionDetailId())) != null) {
                map.put("sceneName", sceneEntity.getSceneName());
            }
            map.put("message", sb.toString());
            if (map.get("createUserId") != null && (mallUserEntity = (MallUserEntity)this.mallUserInterface.selectByPrimaryKey((Serializable)((Object)map.get("createUserId").toString()))) != null) {
                map.put("createUserName", mallUserEntity.getUserNick());
            }
            map.put("quantity", this.routeRecordInterface.getRouteRecords(Integer.valueOf(map.get("id").toString()), DateUtils.currentDate()));
            map.put("groupIds", this.sceneRouteGroupRefInterface.getRouteRef(Integer.valueOf(map.get("id").toString()), 2));
            result.add(map);
        }
        pg.setList(result);
        return BaseJsonVo.success((Object)pg);
    }

    @Override
    @Transactional
    public BaseJsonVo copyRoute(Integer routeId, String userId) {
        try {
            RouteEntity routeEntity = (RouteEntity)this.selectByPrimaryKey(routeId);
            List<RouteLinkEntity> links = this.routeLinkInterface.getRouteLinks(routeId);
            routeEntity.setId(null);
            routeEntity.setCreateTime(new Date());
            routeEntity.setMessage(null);
            routeEntity.setLastExecTime(null);
            routeEntity.setStatus(0);
            routeEntity.setCreateUserId(userId);
            routeEntity.setRouteName(routeEntity.getRouteName() + "-\u590d\u5236");
            int i = this.routeMapper.insert(routeEntity);
            if (i == 1) {
                Integer routeNewId = routeEntity.getId();
                if (routeNewId == null) {
                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                    return BaseJsonVo.error((String)"\u590d\u5236\u5931\u8d25");
                }
                for (RouteLinkEntity link : links) {
                    link.setRouteId(routeNewId);
                    link.setRemark(null);
                    link.setCreateTime(new Date());
                    String newid = UUID.randomUUID().toString();
                    String id = link.getId();
                    List parents = links.stream().filter(c -> id.equals(c.getParentId())).collect(Collectors.toList());
                    for (RouteLinkEntity p : parents) {
                        p.setParentId(newid);
                    }
                    link.setId(newid);
                }
                this.routeLinkInterface.batchInsert(links);
            }
            return BaseJsonVo.success((Object)"\u590d\u5236\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseJsonVo.success((Object)"\u590d\u5236\u5931\u8d251");
        }
    }

    @Override
    public List<RouteSceneVo> getListByMaterail() {
        return this.routeMapper.getListByMaterail();
    }
}

