/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.run;

import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.scrm.dao.run.RunRecordMapper;
import cc.lechun.scrm.entity.run.RunRecordEntity;
import cc.lechun.scrm.entity.run.RunRecordVo;
import cc.lechun.scrm.iservice.run.RunRecordInterface;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RunRecordService
extends BaseService<RunRecordEntity, Integer>
implements RunRecordInterface {
    @Resource
    private RunRecordMapper runRecordMapper;

    private void saveRunRecord(String type, Integer runId, Date beginTime, Date endTime, Integer status, String message) {
        RunRecordEntity recordEntity = new RunRecordEntity();
        recordEntity.setStatus(status);
        int length = 500;
        if (message.length() <= 500) {
            length = message.length();
        }
        recordEntity.setMessage(message.substring(0, length));
        recordEntity.setRunId(runId);
        recordEntity.setEndTime(endTime);
        recordEntity.setBeginTime(beginTime);
        recordEntity.setCreateDate(new Date());
        recordEntity.setRunType(type);
        this.insertSelective(recordEntity);
    }

    @Override
    public void saveSceneRunRecord(Integer sceneId, Date beginTime, Date endTime, Integer status, String message) {
        this.saveRunRecord("scene", sceneId, beginTime, endTime, status, message);
    }

    @Override
    public void saveRouteRunRecord(Integer routeId, Date beginTime, Date endTime, Integer status, String message) {
        this.saveRunRecord("route", routeId, beginTime, endTime, status, message);
    }

    @Override
    public BaseJsonVo getRunRecord(Date date, Integer appId) {
        List<RunRecordVo> lst = this.runRecordMapper.getRunRecord(date, appId);
        return BaseJsonVo.success(lst);
    }
}

