/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.scene;

import cc.lechun.apiinvoke.bi.BIGenerateSceneInvoke;
import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.BeanUtils;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.user.MallUserMapper;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.scrm.dao.scene.SceneMapper;
import cc.lechun.scrm.entity.cron.CronEntity;
import cc.lechun.scrm.entity.route.RouteLinkEntity;
import cc.lechun.scrm.entity.scene.SceneEntity;
import cc.lechun.scrm.entity.scene.SceneEntityVo;
import cc.lechun.scrm.entity.scene.SceneTypeEnum;
import cc.lechun.scrm.iservice.cron.CronInterface;
import cc.lechun.scrm.iservice.group.SceneRouteGroupRefInterface;
import cc.lechun.scrm.iservice.property.EventPropertyInterface;
import cc.lechun.scrm.iservice.route.RouteLinkInterface;
import cc.lechun.scrm.iservice.run.RunRecordInterface;
import cc.lechun.scrm.iservice.scene.SceneCustomerInterface;
import cc.lechun.scrm.iservice.scene.SceneEventInterface;
import cc.lechun.scrm.iservice.scene.SceneEventMeaSureInterface;
import cc.lechun.scrm.iservice.scene.SceneEventPropertyInterface;
import cc.lechun.scrm.iservice.scene.SceneInterface;
import cc.lechun.scrm.iservice.scene.SceneRuleInterface;
import cc.lechun.scrm.iservice.scene.UserGroupInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.quartz.CronExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SceneService
extends BaseService<SceneEntity, Integer>
implements SceneInterface {
    @Resource
    private SceneMapper sceneMapper;
    @Autowired
    private SceneEventPropertyInterface sceneEventPropertyInterface;
    @Autowired
    private SceneRuleInterface sceneRuleInterface;
    @Autowired
    private SceneEventInterface sceneEventInterface;
    @Autowired
    private SceneEventMeaSureInterface sceneEventMeaSureService;
    @Autowired
    private SceneCustomerInterface sceneCustomerInterface;
    @Autowired
    private EventPropertyInterface eventPropertyInterface;
    @Autowired
    private CronInterface cronInterface;
    @Autowired
    private RedisCacheUtil redisCacheUtil;
    @Autowired
    private BIGenerateSceneInvoke biGenerateSceneInvoke;
    @Autowired
    private RouteLinkInterface routeLinkInterface;
    @Autowired
    private RunRecordInterface runRecordInterface;
    @Autowired
    private SceneRouteGroupRefInterface sceneRouteGroupRefInterface;
    @Autowired
    private UserGroupInterface userGroupInterface;
    @Resource
    MallUserMapper mallUserMapper;

    @Override
    public List<SceneEntity> getList(Integer materailId) {
        return this.sceneMapper.getListByMaterailId(materailId);
    }

    @Override
    public BaseJsonVo saveSceneName(SceneEntity sceneEntity) {
        if (sceneEntity.getId() == null) {
            return BaseJsonVo.error((String)"\u4e0d\u652f\u6301\u65b0\u589e");
        }
        SceneEntity search = new SceneEntity();
        search.setSceneName(sceneEntity.getSceneName());
        List lst = this.getList(search, 0L);
        if (lst.stream().filter(c -> !c.getId().equals(sceneEntity.getId())).count() > 0L) {
            return BaseJsonVo.error((String)"\u7fa4\u7ec4\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362");
        }
        search.setId(sceneEntity.getId());
        this.updateByPrimaryKeySelective(search);
        return BaseJsonVo.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    @Override
    public BaseJsonVo getScenePageList(Integer pageNum, Integer pageSize, SceneEntityVo sceneEntity) {
        Page pages = PageHelper.startPage((int)pageNum, (int)pageSize, (String)"CREATE_TIME desc");
        if (StringUtils.isNotEmpty((String)sceneEntity.getSceneName())) {
            sceneEntity.setSceneName(SqlUtils.sqlLike((String)sceneEntity.getSceneName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        this.sceneMapper.getScenePageList(sceneEntity);
        PageInfo pg = pages.toPageInfo();
        ArrayList<Map> result = new ArrayList<Map>();
        for (Object s : pg.getList()) {
            MallUserEntity userEntity;
            CronEntity cronEntity;
            Map map = BeanUtils.beanToMap(s);
            map.put("groupIds", this.sceneRouteGroupRefInterface.getRouteRef(Integer.valueOf(map.get("id").toString()), 1));
            if (map.get("cronId") != null && (cronEntity = (CronEntity)this.cronInterface.selectByPrimaryKey(Integer.valueOf(map.get("cronId").toString()))) != null) {
                map.put("cronName", cronEntity.getCronName());
            }
            Object message = map.get("message");
            map.put("messageLong", message);
            map.put("sceneTypeName", map.get("sceneType") != null ? SceneTypeEnum.getName(Integer.valueOf(map.get("sceneType").toString())) : "");
            if (message != null && message.toString().length() > 30) {
                map.put("message", message.toString().substring(0, 30));
            }
            if ((userEntity = (MallUserEntity)this.mallUserMapper.selectByPrimaryKey((Serializable)((Object)map.getOrDefault("createUserId", "").toString()))) != null) {
                map.put("createUserName", userEntity.getUserNick());
            }
            result.add(map);
        }
        pg.setList(result);
        return BaseJsonVo.success((Object)pg);
    }

    @Override
    public BaseJsonVo changeStatus(Integer sceneId, Integer status) {
        if (sceneId == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u573a\u666f/\u7fa4\u7ec4");
        }
        if (!Integer.valueOf(1).equals(status) && !Integer.valueOf(0).equals(status)) {
            return BaseJsonVo.error((String)"\u72b6\u6001\u9519\u8bef");
        }
        SceneEntity sceneEntity = new SceneEntity();
        sceneEntity.setId(sceneId);
        sceneEntity.setStatus(status);
        this.updateByPrimaryKeySelective(sceneEntity);
        return BaseJsonVo.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    private BaseJsonVo changeMessage(Integer sceneId, String message) {
        if (sceneId == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u573a\u666f/\u7fa4\u7ec4");
        }
        SceneEntity sceneEntity = new SceneEntity();
        sceneEntity.setId(sceneId);
        sceneEntity.setMessage(message);
        this.updateByPrimaryKeySelective(sceneEntity);
        return BaseJsonVo.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    @Override
    public BaseJsonVo deleteScene(Integer sceneId) {
        if (sceneId == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u573a\u666f/\u7fa4\u7ec4");
        }
        if (this.sceneCustomerInterface.existsSceneCustomer(sceneId)) {
            return BaseJsonVo.error((String)"\u7fa4\u7ec4\u4e2d\u5df2\u7ecf\u5b58\u5728\u7528\u6237\u4e0d\u80fd\u5220\u9664\u7fa4\u7ec4");
        }
        RouteLinkEntity routeLinkEntity = new RouteLinkEntity();
        routeLinkEntity.setActionType(1);
        routeLinkEntity.setActionDetailId(sceneId);
        if (this.routeLinkInterface.existsByEntity(routeLinkEntity) > 0) {
            return BaseJsonVo.error((String)"\u7fa4\u7ec4\u4e2d\u5df2\u7ecf\u5728\u65c5\u7a0b\u4e2d\u88ab\u5e94\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        int i = this.deleteByPrimaryKey(sceneId);
        this.sceneRuleInterface.deleteSceneRule(sceneId);
        this.sceneEventInterface.deleteSceneEventEntity(sceneId);
        this.sceneEventMeaSureService.deleteSceneEventMeaSure(sceneId);
        this.sceneEventPropertyInterface.deleteSceneEventProperty(sceneId);
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public BaseJsonVo buildSceneCustomers(Integer sceneId) {
        SceneEntity s = (SceneEntity)this.sceneMapper.selectByPrimaryKey(sceneId);
        if (!Objects.equals(s.getStatus(), 1)) {
            this.logger.error("\u7fa4\u7ec4{}\u5df2\u7981\u7528", (Object)s.getSceneName());
            this.changeMessage(s.getId(), "\u8fd0\u884c\u5931\u8d25:\u7fa4\u7ec4\u672a\u542f\u7528");
            return BaseJsonVo.error((String)"\u8fd0\u884c\u5931\u8d25:\u7fa4\u7ec4\u672a\u542f\u7528");
        }
        Date beginTime = new Date();
        BaseJsonVo jsonVo = this.execInsertScene(s);
        this.runRecordInterface.saveSceneRunRecord(s.getId(), beginTime, new Date(), jsonVo.isSuccess() ? 1 : 0, jsonVo.getMessage());
        s.setSceneLastUpdateTime(new Date());
        this.updateByPrimaryKeySelective(s);
        return BaseJsonVo.success((Object)"\u6267\u884c\u5b8c\u6210");
    }

    private BaseJsonVo execInsertScene(Integer sceneId) {
        if (sceneId == null) {
            return BaseJsonVo.error((String)"\u573a\u666fId \u4e3a\u7a7a");
        }
        SceneEntity sceneEntity = (SceneEntity)this.selectByPrimaryKey(sceneId);
        if (sceneEntity == null) {
            return BaseJsonVo.error((String)"\u573a\u666f\u4e3a\u7a7a");
        }
        return this.execInsertScene(sceneEntity);
    }

    private BaseJsonVo execInsertScene(SceneEntity sceneEntity) {
        BaseJsonVo jsonVo = BaseJsonVo.error((String)"\u672a\u6267\u884c");
        try {
            Map map;
            String key = "scrm_scene_insert_" + sceneEntity.getId() + DateUtils.now((String)"yyyyMMddhhmmss");
            String sql = sceneEntity.getSceneBigSql();
            BaseJsonVo jsonVo1 = this.userGroupInterface.getUserGroupSql(sceneEntity.getId());
            if (jsonVo1.isSuccess() && (map = (Map)jsonVo1.getValue()) != null && StringUtils.isNotEmpty((String)((String)map.get("writeSql")))) {
                sql = (String)map.get("writeSql");
                this.logger.info("sql:" + sql);
            }
            if (StringUtils.isEmpty((String)sql)) {
                return BaseJsonVo.error((String)"\u811a\u672c\u4e3a\u7a7a");
            }
            this.logger.info("\u7fa4\u7ec4:{},sql:{}", (Object)sceneEntity.getId(), (Object)sql);
            this.redisCacheUtil.set(key, (Object)sql, Long.valueOf(86400L));
            this.changeMessage(sceneEntity.getId(), "\u6b63\u5728\u8fd0\u884c");
            jsonVo = this.biGenerateSceneInvoke.insertSceneCustomer(key, sceneEntity.getId());
            if (!jsonVo.isSuccess()) {
                this.changeMessage(sceneEntity.getId(), "\u8fd0\u884c\u5931\u8d25:" + jsonVo.getMessage());
                this.logger.error("\u7fa4\u7ec4:{},{}", (Object)sceneEntity.getSceneName(), (Object)jsonVo.getMessage());
            } else {
                this.changeMessage(sceneEntity.getId(), "\u8fd0\u884c\u5b8c\u6210");
            }
        }
        catch (Exception e) {
            this.logger.error("\u7fa4\u7ec4:{}\u62c9\u7528\u6237\u51fa\u9519", (Object)sceneEntity.getSceneName(), (Object)e);
        }
        return jsonVo;
    }

    @Override
    public Integer execCountScene(Integer sceneId) {
        if (sceneId == null) {
            return 0;
        }
        SceneEntity sceneEntity = (SceneEntity)this.selectByPrimaryKey(sceneId);
        if (sceneEntity == null) {
            return 0;
        }
        return this.execCountScene(sceneEntity);
    }

    public Integer execCountScene(SceneEntity sceneEntity) {
        Integer result = 0;
        String key = "scrm_scene_count_" + sceneEntity.getId() + DateUtils.now((String)"yyyyMMddhhmmss");
        String sql = sceneEntity.getCountSql();
        if (StringUtils.isEmpty((String)sql)) {
            return result;
        }
        this.redisCacheUtil.set(key, (Object)sql, Long.valueOf(86400L));
        BaseJsonVo jsonVo = this.biGenerateSceneInvoke.getSceneCustomerCount(key);
        if (!jsonVo.isSuccess()) {
            this.logger.error(jsonVo.getMessage());
        } else {
            this.logger.info("BI\u8fd4\u56de\u6570\u636e\uff1a" + JsonUtils.toJson((Object)jsonVo, (boolean)true));
            result = Integer.valueOf(jsonVo.getValue().toString());
        }
        return result;
    }

    @Override
    public Integer execCountScene(String sql) {
        String md5Key = MD5.sign((String)sql);
        Integer result = 0;
        String key = "scrm_scene_count_" + md5Key + DateUtils.now((String)"yyyyMMddhhmmss");
        if (StringUtils.isEmpty((String)sql)) {
            return result;
        }
        this.redisCacheUtil.set(key, (Object)sql, Long.valueOf(86400L));
        BaseJsonVo jsonVo = this.biGenerateSceneInvoke.getSceneCustomerCount(key);
        if (!jsonVo.isSuccess()) {
            this.logger.error(jsonVo.getMessage());
        } else {
            this.logger.info("BI\u8fd4\u56de\u6570\u636e\uff1a" + JsonUtils.toJson((Object)jsonVo, (boolean)true));
            result = Integer.valueOf(jsonVo.getValue().toString());
        }
        return result;
    }

    @Override
    public BaseJsonVo<Date> isExecTime(Integer cronId, String remark) {
        CronExpression cronExpression;
        if (cronId == null) {
            this.logger.error("isExecTime:cronId\u4e3a\u7a7a");
            return BaseJsonVo.error((String)"cronId\u4e3a\u7a7a");
        }
        if (cronId == 1) {
            return BaseJsonVo.error((String)"\u7acb\u5373\u6267\u884c\u4e0d\u5904\u7406");
        }
        CronEntity cronEntity = (CronEntity)this.cronInterface.selectByPrimaryKey(cronId);
        if (cronEntity == null) {
            this.logger.error("isExecTime:cron\u5bf9\u8c61\u4e3a\u7a7a");
            return BaseJsonVo.error((String)"cron\u5bf9\u8c61\u4e3a\u7a7a");
        }
        try {
            cronExpression = new CronExpression(cronEntity.getCron());
        }
        catch (ParseException e) {
            e.printStackTrace();
            this.logger.error("isExecTime:cronExpression\u4e3a\u7a7a");
            return BaseJsonVo.error((String)"cronExpression\u4e3a\u7a7a");
        }
        Date execTime = cronExpression.getTimeAfter(DateUtils.getAddDateBySecond((Date)new Date(), (int)-50));
        if (execTime == null) {
            this.logger.error("isExecTime:\u65e0\u6cd5\u83b7\u53d6\u6267\u884c\u65f6\u95f4");
            return BaseJsonVo.error((String)"\u65e0\u6cd5\u83b7\u53d6\u6267\u884c\u65f6\u95f4");
        }
        String execTimeStr = DateUtils.formatDate((Date)execTime, (String)"yyyy-MM-dd HH:mm");
        return BaseJsonVo.success((Object)DateUtils.StrToDate((String)execTimeStr, (String)"yyyy-MM-dd HH:mm"));
    }
}

