/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.scene;

import cc.lechun.common.enums.common.StatusEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.scrm.entity.event.ConditionEvent;
import cc.lechun.scrm.entity.event.EventEntity;
import cc.lechun.scrm.entity.event.EventGroupEntity;
import cc.lechun.scrm.entity.event.EventTypeEnum;
import cc.lechun.scrm.entity.event.RelationItem;
import cc.lechun.scrm.entity.event.UserEvent;
import cc.lechun.scrm.entity.event.UserEventItem;
import cc.lechun.scrm.entity.property.ActiveTimeItem;
import cc.lechun.scrm.entity.property.ConditionProperty;
import cc.lechun.scrm.entity.property.DataTypeFunEntity;
import cc.lechun.scrm.entity.property.DataTypeFunItem;
import cc.lechun.scrm.entity.property.DicTypeEnum;
import cc.lechun.scrm.entity.property.EventPropertyEntity;
import cc.lechun.scrm.entity.property.OperateTypeEntity;
import cc.lechun.scrm.entity.property.OperateTypeItem;
import cc.lechun.scrm.entity.property.PropertyClassEnum;
import cc.lechun.scrm.entity.property.PropertyDataTypeEnum;
import cc.lechun.scrm.entity.property.PropertyEntity;
import cc.lechun.scrm.entity.property.PropertyTypeEnum;
import cc.lechun.scrm.entity.property.TimeTypeItem;
import cc.lechun.scrm.entity.scene.FiltersRule;
import cc.lechun.scrm.entity.scene.Measure;
import cc.lechun.scrm.entity.scene.RuleItem;
import cc.lechun.scrm.entity.scene.SceneClassEnum;
import cc.lechun.scrm.entity.scene.SceneEntity;
import cc.lechun.scrm.entity.scene.SceneEventEntity;
import cc.lechun.scrm.entity.scene.SceneEventMeaSureEntity;
import cc.lechun.scrm.entity.scene.SceneEventPropertyEntity;
import cc.lechun.scrm.entity.scene.SceneRuleEntity;
import cc.lechun.scrm.entity.scene.SceneTypeEnum;
import cc.lechun.scrm.entity.scene.TimeTypeEnum;
import cc.lechun.scrm.entity.scene.UserGroup;
import cc.lechun.scrm.entity.scene.UserGroupCondition;
import cc.lechun.scrm.entity.scene.UserGroupQuery;
import cc.lechun.scrm.entity.scene.UserGroupRule;
import cc.lechun.scrm.entity.scene.UserGroupRuleTypeEnum;
import cc.lechun.scrm.iservice.event.EventGroupInterface;
import cc.lechun.scrm.iservice.event.EventInterface;
import cc.lechun.scrm.iservice.property.DataTypeFunInterface;
import cc.lechun.scrm.iservice.property.EventPropertyInterface;
import cc.lechun.scrm.iservice.property.OperateTypeInterface;
import cc.lechun.scrm.iservice.property.PropertyInterface;
import cc.lechun.scrm.iservice.scene.SceneEventInterface;
import cc.lechun.scrm.iservice.scene.SceneEventMeaSureInterface;
import cc.lechun.scrm.iservice.scene.SceneEventPropertyInterface;
import cc.lechun.scrm.iservice.scene.SceneInterface;
import cc.lechun.scrm.iservice.scene.SceneRuleInterface;
import cc.lechun.scrm.iservice.scene.UserGroupInterface;
import cc.lechun.scrm.service.scene.usergroup.EventContext;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserGroupService
implements UserGroupInterface {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SceneInterface sceneInterface;
    @Autowired
    private SceneEventPropertyInterface sceneEventPropertyInterface;
    @Autowired
    private SceneRuleInterface sceneRuleInterface;
    @Autowired
    @Lazy
    private SceneEventInterface sceneEventInterface;
    @Autowired
    private SceneEventMeaSureInterface sceneEventMeaSureService;
    @Autowired
    private EventPropertyInterface eventPropertyInterface;
    @Lazy
    @Autowired
    private EventContext eventContext;
    @Autowired
    private DataTypeFunInterface dataTypeFunInterface;
    @Autowired
    private PropertyInterface propertyInterface;
    @Autowired
    @Lazy
    private EventInterface eventInterface;
    @Autowired
    private OperateTypeInterface operateTypeInterface;
    @Autowired
    private EventGroupInterface eventGroupInterface;

    @Override
    @Transactional
    public BaseJsonVo saveUserGroup(UserGroup userGroup) {
        SceneEntity temp;
        SceneEntity query;
        this.logger.info("{}", (Object)userGroup.toString());
        SceneEntity sceneEntity = null;
        if (userGroup.getGroupId() == null || userGroup.getGroupId() == 0) {
            if (StringUtils.isNotEmpty((String)userGroup.getGroupName())) {
                query = new SceneEntity();
                query.setSceneName(userGroup.getGroupName());
                query.setAppId(userGroup.getAppId());
                temp = (SceneEntity)this.sceneInterface.getSingle(query, 0L);
                if (temp != null) {
                    return BaseJsonVo.error((String)"\u7fa4\u7ec4\u540d\u79f0\u91cd\u590d");
                }
            }
            sceneEntity = new SceneEntity();
            sceneEntity.setStatus(1);
            sceneEntity.setAppId(userGroup.getAppId());
            if (userGroup.getDistinctStatus() != null) {
                sceneEntity.setDistinctStatus(userGroup.getDistinctStatus());
            }
            sceneEntity.setSceneName(userGroup.getGroupName());
            sceneEntity.setCreateTime(DateUtils.now());
            sceneEntity.setCreateUserId(userGroup.getUserId());
            sceneEntity.setCreateUserName(userGroup.getUserName());
            sceneEntity.setRemark(userGroup.getRemark());
            sceneEntity.setSecenClass(SceneClassEnum.public_use.getValue());
            sceneEntity.setSceneType(userGroup.getSceneType() == null ? 3 : userGroup.getSceneType());
            if (userGroup.getChooseCount() != null) {
                sceneEntity.setChooseCount(userGroup.getChooseCount());
            }
            this.sceneInterface.insert(sceneEntity);
            userGroup.setGroupId(sceneEntity.getId());
        } else {
            sceneEntity = (SceneEntity)this.sceneInterface.selectByPrimaryKey(userGroup.getGroupId());
            if (StringUtils.isNotEmpty((String)userGroup.getGroupName()) && !Objects.equals(userGroup.getGroupName(), sceneEntity.getSceneName())) {
                query = new SceneEntity();
                query.setSceneName(userGroup.getGroupName());
                query.setAppId(userGroup.getAppId());
                temp = (SceneEntity)this.sceneInterface.getSingle(query, 0L);
                if (temp != null) {
                    return BaseJsonVo.error((String)"\u7fa4\u7ec4\u540d\u79f0\u91cd\u590d");
                }
            }
            sceneEntity.setStatus(userGroup.getStatus() != null ? userGroup.getStatus() : 1);
            sceneEntity.setSceneName(userGroup.getGroupName());
            sceneEntity.setRemark(userGroup.getRemark());
            if (userGroup.getSceneType() != null) {
                sceneEntity.setSceneType(userGroup.getSceneType());
            }
            if (userGroup.getChooseCount() != null) {
                sceneEntity.setChooseCount(userGroup.getChooseCount());
            }
            if (userGroup.getDistinctStatus() != null) {
                sceneEntity.setDistinctStatus(userGroup.getDistinctStatus());
            }
            this.sceneInterface.updateByPrimaryKeySelective(sceneEntity);
            Boolean result = this.sceneRuleInterface.deleteSceneRule(userGroup.getGroupId());
            this.logger.info("\u5220\u9664\u573a\u666f\u89c4\u5219:{}", (Object)result);
            result = this.sceneEventInterface.deleteSceneEventEntity(userGroup.getGroupId());
            this.logger.info("\u5220\u9664\u573a\u666f\u4e8b\u4ef6:{}", (Object)result);
            result = this.sceneEventMeaSureService.deleteSceneEventMeaSure(userGroup.getGroupId());
            this.logger.info("\u5220\u9664\u573a\u666f\u805a\u5408:{}", (Object)result);
            result = this.sceneEventPropertyInterface.deleteSceneEventProperty(userGroup.getGroupId());
            this.logger.info("\u5220\u9664\u573a\u666f\u5c5e\u6027:{}", (Object)result);
        }
        ((UserGroupService)AopContext.currentProxy()).saveUserGroupRule(userGroup, sceneEntity);
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Integer count = this.sceneInterface.execCountScene(userGroup.getGroupId());
            SceneEntity sc = new SceneEntity();
            sc.setId(userGroup.getGroupId());
            sc.setPreUserCount(count);
            this.sceneInterface.updateByPrimaryKeySelective(sc);
            map.put("count", count);
            return BaseJsonVo.success(map);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u4eba\u6570\u5931\u8d25", (Throwable)e);
            map.put("count", "\u67e5\u8be2\u4eba\u6570\u5931\u8d25,\u8bf7\u91cd\u8bd5!");
            return BaseJsonVo.success(map);
        }
    }

    @Override
    public BaseJsonVo getUserGroupSql(Integer groupId) {
        BaseJsonVo baseJsonVo = this.getUserGroup(groupId);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        return this.eventContext.getSceneSql((UserGroup)baseJsonVo.getValue());
    }

    @Override
    public BaseJsonVo getUserCount(UserGroup userGroup) {
        BaseJsonVo<Map<String, String>> baseJsonVo;
        if (userGroup.getSceneType() == null) {
            SceneEntity sceneEntity = (SceneEntity)this.sceneInterface.selectByPrimaryKey(userGroup.getGroupId());
            userGroup.setSceneType(sceneEntity.getSceneType());
        }
        if ((baseJsonVo = this.eventContext.getSceneSql(userGroup)).isSuccess()) {
            Map sqlMap = (Map)baseJsonVo.getValue();
            Integer result = this.sceneInterface.execCountScene((String)sqlMap.get("readSql"));
            return BaseJsonVo.success((Object)result);
        }
        this.logger.error("\u751f\u6210sql\u51fa\u9519:{}", (Object)baseJsonVo.getMessage());
        return baseJsonVo;
    }

    @Override
    public BaseJsonVo getUserCount(Integer groupId, Integer day) {
        BaseJsonVo baseJsonVo = this.getUserGroup(groupId);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        BaseJsonVo<Map<String, String>> result = this.eventContext.getSceneSql((UserGroup)baseJsonVo.getValue(), day);
        if (baseJsonVo.isSuccess()) {
            Map sqlMap = (Map)result.getValue();
            Integer num = this.sceneInterface.execCountScene((String)sqlMap.get("readSql"));
            return BaseJsonVo.success((Object)num);
        }
        this.logger.error("\u751f\u6210sql\u51fa\u9519:{}", (Object)baseJsonVo.getMessage());
        return baseJsonVo;
    }

    @Override
    public BaseJsonVo copyUserGroup(String userId, String userName, Integer groupId) {
        BaseJsonVo userGroupBaseJsonVo = this.getUserGroup(groupId);
        if (userGroupBaseJsonVo.isSuccess()) {
            UserGroup userGroup = (UserGroup)userGroupBaseJsonVo.getValue();
            userGroup.setGroupId(null);
            userGroup.setUserId(userId);
            userGroup.setUserName(userName);
            userGroup.setGroupName(userGroup.getGroupName() + "\u590d\u5236");
            return this.saveUserGroup(userGroup);
        }
        return userGroupBaseJsonVo;
    }

    @Override
    public BaseJsonVo saveUserGroupRule(UserGroup userGroup, SceneEntity sceneEntity) {
        BaseJsonVo<Map<String, String>> baseJsonVo;
        SceneRuleEntity sceneRuleEntity = new SceneRuleEntity();
        sceneRuleEntity.setRetion(userGroup.getUserGroupRule().getRelation());
        sceneRuleEntity.setSceneId(sceneEntity.getId());
        sceneRuleEntity.setCreateTime(DateUtils.now());
        sceneEntity.setCreateTime(DateUtils.now());
        this.sceneRuleInterface.insert(sceneRuleEntity);
        if (userGroup.getUserEvent() != null && CollectionUtils.isNotEmpty(userGroup.getUserEvent().getFiltersRuleList())) {
            if (CollectionUtils.isEmpty(userGroup.getUserGroupRule().getRuleList())) {
                userGroup.getUserGroupRule().setRuleList(new ArrayList<RuleItem>());
            }
            RuleItem ruleItem = new RuleItem();
            if (userGroup.getUserEvent().getFiltersRuleList().size() > 1 && StringUtils.isEmpty((String)userGroup.getUserEvent().getRelation())) {
                this.logger.error("\u6761\u4ef6\u5173\u7cfb\u5fc5\u9009");
                throw new RuntimeException("\u6761\u4ef6\u5173\u7cfb\u5fc5\u9009");
            }
            BeanUtils.copyProperties((Object)userGroup.getUserEvent(), (Object)ruleItem);
            this.saveEvent(userGroup, sceneEntity, ruleItem);
        }
        if (CollectionUtils.isNotEmpty(userGroup.getUserGroupRule().getRuleList())) {
            for (RuleItem ruleItem : userGroup.getUserGroupRule().getRuleList()) {
                this.saveEvent(userGroup, sceneEntity, ruleItem);
            }
        }
        if (userGroup.getSceneType() == null && sceneEntity.getSceneType() != null) {
            userGroup.setSceneType(sceneEntity.getSceneType());
        }
        if ((baseJsonVo = this.eventContext.getSceneSql(userGroup)).isSuccess()) {
            Map sqlMap = (Map)baseJsonVo.getValue();
            SceneEntity update = new SceneEntity();
            update.setId(userGroup.getGroupId());
            update.setSceneBigSql((String)sqlMap.get("writeSql"));
            update.setCountSql((String)sqlMap.get("readSql"));
            int k = this.sceneInterface.updateByPrimaryKeySelective(update);
            this.logger.info("\u7fa4\u7ec4:{},{} sql\u5df2\u66f4\u65b0:{}", new Object[]{userGroup.getGroupName(), update.toString(), k > 0});
        } else {
            this.logger.error("\u751f\u6210sql\u51fa\u9519:{}", (Object)baseJsonVo.getMessage());
        }
        return baseJsonVo;
    }

    private void saveEvent(UserGroup userGroup, SceneEntity sceneEntity, RuleItem ruleItem) {
        if (ruleItem.getEventId() == null) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u4e8b\u4ef6");
        }
        if (CollectionUtils.isEmpty(ruleItem.getFiltersRuleList())) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u7b5b\u9009\u6761\u4ef6");
        }
        SceneEventEntity sceneEventEntity = new SceneEventEntity();
        sceneEventEntity.setCreateTime(DateUtils.now());
        sceneEventEntity.setEventId(ruleItem.getEventId());
        sceneEventEntity.setSceneId(sceneEntity.getId());
        sceneEventEntity.setRation(ruleItem.getRelation());
        this.sceneEventInterface.insert(sceneEventEntity);
        this.logger.info("\u7fa4\u7ec4:{}\u4e8b\u4ef6ID:{} \u5bf9\u8c61\u5df2\u5199\u5165", (Object)userGroup.getGroupName(), (Object)ruleItem.getEventId());
        for (FiltersRule filtersRule : ruleItem.getFiltersRuleList()) {
            boolean notNeedParams;
            if (filtersRule.getOperateId() == null) {
                throw new RuntimeException("\u8bf7\u9009\u62e9\u5c5e\u6027\u64cd\u4f5c");
            }
            if (filtersRule.getEventPropertyId() == null) {
                throw new RuntimeException("\u8bf7\u9009\u62e9\u4e8b\u4ef6\u5c5e\u6027");
            }
            SceneEventPropertyEntity sceneEventPropertyEntity = new SceneEventPropertyEntity();
            sceneEventPropertyEntity.setEventPropertyId(filtersRule.getEventPropertyId());
            if (StringUtils.isNotEmpty((String)filtersRule.getParams()) && this.containsSqlInjection(filtersRule.getParams())) {
                this.logger.error("\u8f93\u5165\u53c2\u6570:{}\u975e\u6cd5", (Object)filtersRule.getParams());
                throw new RuntimeException("\u8f93\u5165\u503c\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            OperateTypeEntity operateTypeEntity = (OperateTypeEntity)this.operateTypeInterface.selectByPrimaryKey(filtersRule.getOperateId());
            boolean bl = notNeedParams = Objects.equals(operateTypeEntity.getOperateField(), "is_null") || Objects.equals(operateTypeEntity.getOperateField(), "is_not_null");
            if (!notNeedParams && StringUtils.isEmpty((String)filtersRule.getParams())) {
                this.logger.error("\u8f93\u5165\u53c2\u6570:{}\u975e\u6cd5", (Object)filtersRule.getParams());
                throw new RuntimeException("\u8f93\u5165\u503c\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            if (Objects.equals(filtersRule.getTimeTypeId(), TimeTypeEnum.relative_time.getValue())) {
                if (!filtersRule.getParams().contains("-")) {
                    throw new RuntimeException("\u8f93\u5165\u503c\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                }
                if (filtersRule.getParams().split("-").length < 2) {
                    throw new RuntimeException("\u8bf7\u9009\u62e9\u76f8\u5bf9\u65f6\u95f4\u53c2\u6570");
                }
            }
            sceneEventPropertyEntity.setParams(filtersRule.getParams());
            sceneEventPropertyEntity.setRation(filtersRule.getRelation());
            EventPropertyEntity eventPropertyEntity = (EventPropertyEntity)this.eventPropertyInterface.selectByPrimaryKey(filtersRule.getEventPropertyId());
            PropertyEntity propertyEntity = (PropertyEntity)this.propertyInterface.selectByPrimaryKey(eventPropertyEntity.getPropertyId());
            if (Objects.equals(propertyEntity.getProperytDataType(), PropertyDataTypeEnum.DateTimeType.getValue()) || Objects.equals(propertyEntity.getProperytDataType(), PropertyDataTypeEnum.DateType.getValue())) {
                if (filtersRule.getTimeTypeId() == null) {
                    throw new RuntimeException("\u8bf7\u9009\u62e9\u662f\u76f8\u5bf9\u65f6\u95f4\u8fd8\u662f\u7edd\u5bf9\u65f6\u95f4");
                }
                if (Objects.equals(filtersRule.getTimeTypeId(), TimeTypeEnum.relative_time.getValue()) && filtersRule.getParams().indexOf("-") < 0) {
                    throw new RuntimeException("\u8bf7\u9009\u62e9\u662f\u76f8\u5bf9\u65f6\u95f4\u5355\u4f4d");
                }
            }
            sceneEventPropertyEntity.setPropertyId(eventPropertyEntity.getPropertyId());
            sceneEventPropertyEntity.setSceneEventId(sceneEventEntity.getSceneEventId());
            sceneEventPropertyEntity.setTimetype(filtersRule.getTimeTypeId());
            sceneEventPropertyEntity.setSceneId(userGroup.getGroupId());
            sceneEventPropertyEntity.setOperateId(filtersRule.getOperateId());
            this.sceneEventPropertyInterface.insert(sceneEventPropertyEntity);
            this.logger.info("\u7fa4\u7ec4:{}\u5c5e\u6027:{} \u503c:{} \u5bf9\u8c61\u5df2\u5199\u5165", new Object[]{userGroup.getGroupName(), propertyEntity.getPropertyName(), filtersRule.getParams()});
        }
        if (ruleItem.getMeasure() != null) {
            EventPropertyEntity eventPropertyEntity = (EventPropertyEntity)this.eventPropertyInterface.selectByPrimaryKey(ruleItem.getMeasure().getEventPropertyId(), 0L);
            SceneEventMeaSureEntity sceneEventMeaSureEntity = new SceneEventMeaSureEntity();
            sceneEventMeaSureEntity.setCreateTime(DateUtils.now());
            sceneEventMeaSureEntity.setFunId(ruleItem.getMeasure().getFunId());
            sceneEventMeaSureEntity.setOperateId(ruleItem.getMeasure().getOperateId());
            sceneEventMeaSureEntity.setPropertyId(eventPropertyEntity.getPropertyId());
            if (StringUtils.isNotEmpty((String)ruleItem.getMeasure().getParams()) && this.containsSqlInjection(ruleItem.getMeasure().getParams())) {
                throw new RuntimeException("\u8f93\u5165\u503c\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            sceneEventMeaSureEntity.setEventPropertyId(ruleItem.getMeasure().getEventPropertyId());
            sceneEventMeaSureEntity.setParams(ruleItem.getMeasure().getParams());
            sceneEventMeaSureEntity.setSceneId(sceneEntity.getId());
            sceneEventMeaSureEntity.setEventId(ruleItem.getEventId());
            sceneEventMeaSureEntity.setSceneEventId(sceneEventEntity.getSceneEventId());
            this.sceneEventMeaSureService.insert(sceneEventMeaSureEntity);
            this.logger.info("\u7fa4\u7ec4:{}\u4e8b\u4ef6\u805a\u5408 \u5bf9\u8c61\u5df2\u5199\u5165", (Object)userGroup.getGroupName());
        }
    }

    private boolean containsSqlInjection(String obj) {
        Pattern pattern = Pattern.compile("\\b(and|exec|insert|select|drop|grant|alter|delete|update|count|chr|mid|master|truncate|char|declare|or)");
        Matcher matcher = pattern.matcher(obj);
        return matcher.find();
    }

    @Override
    public BaseJsonVo getUserGroup(Integer groupId) {
        ArrayList<RuleItem> ruleList;
        SceneEntity sceneEntity = (SceneEntity)this.sceneInterface.selectByPrimaryKey(groupId, 0L);
        if (sceneEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u7528\u6237\u7fa4\u7ec4");
        }
        sceneEntity.setId(groupId);
        UserGroup userGroup = new UserGroup();
        BeanUtils.copyProperties((Object)sceneEntity, (Object)userGroup);
        userGroup.setGroupName(sceneEntity.getSceneName());
        userGroup.setGroupId(sceneEntity.getId());
        userGroup.setSceneType(sceneEntity.getSceneType());
        userGroup.setSceneTypeName(SceneTypeEnum.getName(sceneEntity.getSceneType()));
        userGroup.setRemark(sceneEntity.getRemark());
        userGroup.setStatus(sceneEntity.getStatus());
        userGroup.setUserName(sceneEntity.getCreateUserName());
        userGroup.setUserId(sceneEntity.getCreateUserId());
        userGroup.setStatusName(sceneEntity.getStatus() == 1 ? StatusEnum.STATUS_OK.getName() : StatusEnum.STATUS_FAIL.getName());
        userGroup.setChooseCount(sceneEntity.getChooseCount());
        userGroup.setSceneType(sceneEntity.getSceneType());
        UserGroupRule userGroupRule = new UserGroupRule();
        SceneRuleEntity query = new SceneRuleEntity();
        query.setSceneId(groupId);
        SceneRuleEntity sceneRuleEntity = (SceneRuleEntity)this.sceneRuleInterface.getSingle(query, 0L);
        if (sceneRuleEntity != null) {
            userGroupRule.setRelation(sceneRuleEntity.getRetion());
            userGroupRule.setRuleType(UserGroupRuleTypeEnum.event_rule.getName());
            BeanUtils.copyProperties((Object)userGroupRule, (Object)sceneRuleEntity);
            ruleList = new ArrayList<RuleItem>();
            SceneEventEntity querySceneEvent = new SceneEventEntity();
            querySceneEvent.setSceneId(groupId);
            List sceneEventEntityList = this.sceneEventInterface.getList(querySceneEvent, 0L);
            if (CollectionUtils.isNotEmpty((Collection)sceneEventEntityList)) {
                for (SceneEventEntity sceneEventEntity : sceneEventEntityList) {
                    EventEntity eventEntity = (EventEntity)this.eventInterface.selectByPrimaryKey(sceneEventEntity.getEventId());
                    ArrayList<FiltersRule> filtersRuleList = new ArrayList<FiltersRule>();
                    SceneEventPropertyEntity queryEventProperty = new SceneEventPropertyEntity();
                    queryEventProperty.setSceneId(groupId);
                    queryEventProperty.setSceneEventId(sceneEventEntity.getSceneEventId());
                    List sceneEventPropertyEntityList = this.sceneEventPropertyInterface.getList(queryEventProperty, 0L);
                    if (CollectionUtils.isNotEmpty((Collection)sceneEventPropertyEntityList)) {
                        for (SceneEventPropertyEntity sceneEventPropertyEntity : sceneEventPropertyEntityList) {
                            FiltersRule filtersRule = new FiltersRule();
                            BeanUtils.copyProperties((Object)sceneEventPropertyEntity, (Object)filtersRule);
                            filtersRule.setEventPropertyId(sceneEventPropertyEntity.getEventPropertyId());
                            filtersRule.setRelation(sceneEventPropertyEntity.getRation());
                            this.logger.info("\u7fa4\u7ec4\u4e8b\u4ef6\u5c5e\u6027:{}", (Object)sceneEventPropertyEntity.toString());
                            EventPropertyEntity eventPropertyEntity = (EventPropertyEntity)this.eventPropertyInterface.selectByPrimaryKey(sceneEventPropertyEntity.getEventPropertyId());
                            this.logger.info("\u4e8b\u4ef6\u5c5e\u6027:{}", (Object)eventPropertyEntity.toString());
                            filtersRule.setType(UserGroupRuleTypeEnum.property_rule.getName());
                            PropertyEntity propertyEntity = (PropertyEntity)this.propertyInterface.selectByPrimaryKey(eventPropertyEntity.getPropertyId(), 0L);
                            if (propertyEntity == null) continue;
                            filtersRule.setField(propertyEntity.getPropertyField());
                            filtersRule.setOperateId(sceneEventPropertyEntity.getOperateId());
                            filtersRule.setParams(sceneEventPropertyEntity.getParams());
                            filtersRule.setRelation(sceneEventPropertyEntity.getRation());
                            filtersRule.setTimeTypeId(sceneEventPropertyEntity.getTimetype());
                            filtersRuleList.add(filtersRule);
                        }
                    }
                    if (Objects.equals(eventEntity.getEventType(), EventTypeEnum.base_event.getValue())) {
                        RuleItem ruleItem = new RuleItem();
                        BeanUtils.copyProperties((Object)sceneEventEntity, (Object)ruleItem);
                        ruleItem.setType(UserGroupRuleTypeEnum.property_rule.getName());
                        ruleItem.setEventName(eventEntity.getEventName());
                        ruleItem.setEventId(eventEntity.getEventId());
                        ruleItem.setFiltersRuleList(filtersRuleList);
                        ruleItem.setRelation(sceneEventEntity.getRation());
                        SceneEventMeaSureEntity sceneEventMeaSureQuery = new SceneEventMeaSureEntity();
                        sceneEventMeaSureQuery.setSceneId(groupId);
                        sceneEventMeaSureQuery.setSceneEventId(sceneEventEntity.getSceneEventId());
                        SceneEventMeaSureEntity sceneEventMeaSureEntity = (SceneEventMeaSureEntity)this.sceneEventMeaSureService.getSingle(sceneEventMeaSureQuery, 0L);
                        if (sceneEventMeaSureEntity != null) {
                            Measure measure = new Measure();
                            BeanUtils.copyProperties((Object)sceneEventMeaSureEntity, (Object)measure);
                            measure.setParams(sceneEventMeaSureEntity.getParams());
                            measure.setEventName(eventEntity.getEventName());
                            measure.setType(UserGroupRuleTypeEnum.having_rule.getName());
                            if (sceneEventMeaSureEntity.getFunId() != null) {
                                DataTypeFunEntity dataTypeFunEntity = (DataTypeFunEntity)this.dataTypeFunInterface.selectByPrimaryKey(sceneEventMeaSureEntity.getFunId());
                                measure.setAggregator(dataTypeFunEntity.getFunName());
                                measure.setFunId(dataTypeFunEntity.getFunId());
                            }
                            measure.setEventName(eventEntity.getEventName());
                            if (sceneEventMeaSureEntity.getEventPropertyId() != null) {
                                EventPropertyEntity eventPropertyEntity = (EventPropertyEntity)this.eventPropertyInterface.selectByPrimaryKey(sceneEventMeaSureEntity.getEventPropertyId());
                                PropertyEntity propertyEntity = (PropertyEntity)this.propertyInterface.selectByPrimaryKey(eventPropertyEntity.getPropertyId());
                                measure.setField(propertyEntity.getPropertyField());
                            }
                            ruleItem.setMeasure(measure);
                        }
                        ruleList.add(ruleItem);
                        continue;
                    }
                    if (!Objects.equals(eventEntity.getEventType(), EventTypeEnum.user_event.getValue())) continue;
                    UserEventItem userEvent = new UserEventItem();
                    userEvent.setEventId(eventEntity.getEventId());
                    userEvent.setEventName(eventEntity.getEventName());
                    userEvent.setRelation(sceneEventEntity.getRation());
                    userEvent.setFiltersRuleList(filtersRuleList);
                    userGroup.setUserEvent(userEvent);
                }
            }
        } else {
            return BaseJsonVo.error((String)"\u672a\u914d\u7f6e\u7528\u6237\u7fa4\u7ec4\u89c4\u5219");
        }
        userGroupRule.setRuleList(ruleList);
        userGroup.setUserGroupRule(userGroupRule);
        return BaseJsonVo.success((Object)userGroup);
    }

    @Override
    public BaseJsonVo getUserGroupList(UserGroupQuery userGroupVo) {
        SceneEntity query = new SceneEntity();
        BeanUtils.copyProperties((Object)userGroupVo, (Object)query);
        Page page = PageHelper.startPage((int)userGroupVo.getCurrentPage(), (int)userGroupVo.getPageSize());
        page.setOrderBy(" CREATE_TIME ");
        List list = this.sceneInterface.getList(query);
        List<Object> userGroupVos = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            userGroupVos = list.stream().map(sceneEntity -> {
                UserGroup userGroup = new UserGroup();
                userGroup.setGroupName(sceneEntity.getSceneName());
                userGroup.setGroupId(sceneEntity.getId());
                BeanUtils.copyProperties((Object)sceneEntity, (Object)userGroup);
                userGroup.setSceneTypeName(SceneTypeEnum.getName(sceneEntity.getSceneType()));
                return userGroup;
            }).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(userGroupVos)) {
            for (UserGroup userGroup : userGroupVos) {
                SceneRuleEntity queryRule = new SceneRuleEntity();
                queryRule.setSceneId(userGroup.getGroupId());
                SceneRuleEntity rule = (SceneRuleEntity)this.sceneRuleInterface.getSingle(queryRule, 0L);
                UserGroupRule userGroupRule = new UserGroupRule();
                userGroupRule.setRuleType(UserGroupRuleTypeEnum.event_rule.getName());
                userGroupRule.setRelation(rule.getRetion());
                userGroup.setUserGroupRule(userGroupRule);
            }
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(userGroupVos);
        return BaseJsonVo.success((Object)pg);
    }

    @Override
    public BaseJsonVo generateSql(Integer groupId) {
        BaseJsonVo userGroupBaseJsonVo = this.getUserGroup(groupId);
        if (userGroupBaseJsonVo.isSuccess()) {
            BaseJsonVo<Map<String, String>> baseJsonVo = this.eventContext.getSceneSql((UserGroup)userGroupBaseJsonVo.getValue());
            if (baseJsonVo.isSuccess()) {
                Map sqlMap = (Map)baseJsonVo.getValue();
                SceneEntity update = new SceneEntity();
                update.setId(groupId);
                update.setSceneBigSql((String)sqlMap.get("writeSql"));
                update.setCountSql((String)sqlMap.get("readSql"));
                this.sceneInterface.updateByPrimaryKeySelective(update);
            }
            return baseJsonVo;
        }
        return BaseJsonVo.error((String)"");
    }

    @Override
    public BaseJsonVo<UserGroupCondition> getUserGroupCondition(Integer appId) {
        ArrayList<RelationItem> userEventConditionList = new ArrayList<RelationItem>();
        ArrayList<RelationItem> baseEventConditionList = new ArrayList<RelationItem>();
        RelationItem relationItem = new RelationItem();
        relationItem.setName("\u5e76");
        relationItem.setValue("and");
        userEventConditionList.add(relationItem);
        baseEventConditionList.add(relationItem);
        RelationItem relationItemOr = new RelationItem();
        relationItemOr.setName("\u6216");
        relationItemOr.setValue("or");
        baseEventConditionList.add(relationItemOr);
        UserGroupCondition userGroupCondition = new UserGroupCondition();
        UserEvent userEvent = new UserEvent();
        EventEntity query = new EventEntity();
        query.setEventType(EventTypeEnum.user_event.getValue());
        query.setStatus(StatusEnum.STATUS_OK.getValue());
        query.setAppId(appId);
        EventEntity eventEntity = (EventEntity)this.eventInterface.getSingle(query, 0L);
        BeanUtils.copyProperties((Object)eventEntity, (Object)userEvent);
        userGroupCondition.setUserEvent(userEvent);
        userEvent.setRelationList(userEventConditionList);
        userEvent.setConditionPropertyList(this.setConditionEventProperty(eventEntity));
        EventEntity baseEventQuery = new EventEntity();
        baseEventQuery.setEventType(EventTypeEnum.base_event.getValue());
        baseEventQuery.setStatus(StatusEnum.STATUS_OK.getValue());
        baseEventQuery.setAppId(appId);
        List baseEventList = this.eventInterface.getList(baseEventQuery, 0L);
        baseEventList = baseEventList.stream().sorted((e1, e2) -> e1.getSort() - e2.getSort()).collect(Collectors.toList());
        ArrayList<ConditionEvent> conditionEventList = new ArrayList<ConditionEvent>();
        if (CollectionUtils.isNotEmpty(baseEventList)) {
            for (EventEntity baseEvent : baseEventList) {
                ConditionEvent conditionEvent = new ConditionEvent();
                BeanUtils.copyProperties((Object)baseEvent, (Object)conditionEvent);
                conditionEvent.setRelationList(baseEventConditionList);
                conditionEvent.setConditionPropertyList(this.setConditionEventProperty(baseEvent));
                if (baseEvent.getEventGroupId() != null) {
                    EventGroupEntity eventGroupEntity = (EventGroupEntity)this.eventGroupInterface.selectByPrimaryKey(baseEvent.getEventGroupId());
                    conditionEvent.setEventGroupName(eventGroupEntity.getEventGroupName());
                }
                conditionEventList.add(conditionEvent);
            }
            userGroupCondition.setConditionEventList(conditionEventList);
        }
        return BaseJsonVo.success((Object)userGroupCondition);
    }

    private List<ConditionProperty> setConditionEventProperty(EventEntity eventEntity) {
        ArrayList<ConditionProperty> result = new ArrayList<ConditionProperty>();
        EventPropertyEntity eventPropertyQuery = new EventPropertyEntity();
        eventPropertyQuery.setStatus(1);
        eventPropertyQuery.setEventPropertyType(0);
        eventPropertyQuery.setEventId(eventEntity.getEventId());
        List eventPropertyEntityList = this.eventPropertyInterface.getList(eventPropertyQuery, 0L);
        eventPropertyEntityList = eventPropertyEntityList.stream().sorted((e1, e2) -> e1.getSort() - e2.getSort()).collect(Collectors.toList());
        for (EventPropertyEntity item : eventPropertyEntityList) {
            ConditionProperty conditionProperty = new ConditionProperty();
            BeanUtils.copyProperties((Object)item, (Object)conditionProperty);
            this.logger.info("propertyId={}", (Object)item.getPropertyId());
            PropertyEntity propertyEntity = (PropertyEntity)this.propertyInterface.selectByPrimaryKey(item.getPropertyId(), 0L);
            conditionProperty.setPropertyName(propertyEntity.getPropertyName());
            conditionProperty.setPropertyType(propertyEntity.getPropertyType());
            conditionProperty.setPropertyTypeName(PropertyTypeEnum.getName(propertyEntity.getPropertyType()));
            conditionProperty.setProperytDataType(propertyEntity.getProperytDataType());
            conditionProperty.setPropertyDemo(propertyEntity.getPropertyDemo());
            conditionProperty.setPropertyClass((int)propertyEntity.getPropertyClass());
            conditionProperty.setPropertyClassName(PropertyClassEnum.getName(propertyEntity.getPropertyClass()));
            conditionProperty.setDicType(Objects.equals(item.getDicDataType(), DicTypeEnum.dic_type.getValue()) && Objects.equals(item.getDicDataType(), 1) ? DicTypeEnum.dic_type.getValue() : DicTypeEnum.not_dic_type.getValue());
            conditionProperty.setDicTypeName(DicTypeEnum.getName(conditionProperty.getDicType()));
            DataTypeFunEntity dataTypeFunQuery = new DataTypeFunEntity();
            dataTypeFunQuery.setDataType(propertyEntity.getProperytDataType());
            List dataTypeFunEntityList = this.dataTypeFunInterface.getList(dataTypeFunQuery, 0L);
            dataTypeFunEntityList = dataTypeFunEntityList.stream().sorted((e1, e2) -> e1.getSort() - e2.getSort()).collect(Collectors.toList());
            ArrayList<DataTypeFunItem> funItemList = new ArrayList();
            for (DataTypeFunEntity dataTypeFunEntity : dataTypeFunEntityList) {
                DataTypeFunItem dataTypeFunItem = new DataTypeFunItem();
                BeanUtils.copyProperties((Object)dataTypeFunEntity, (Object)dataTypeFunItem);
                funItemList.add(dataTypeFunItem);
            }
            funItemList = funItemList.stream().sorted((e1, e2) -> e1.getSort() - e2.getSort()).collect(Collectors.toList());
            conditionProperty.setFunItemList(funItemList);
            OperateTypeEntity operateTypeQuery = new OperateTypeEntity();
            operateTypeQuery.setDataType(propertyEntity.getProperytDataType());
            List operateTypeEntityList = this.operateTypeInterface.getList(operateTypeQuery, 0L);
            ArrayList<OperateTypeItem> operateItemList = new ArrayList<OperateTypeItem>();
            for (OperateTypeEntity operateTypeEntity : operateTypeEntityList) {
                if ((Objects.equals(operateTypeEntity.getDataType(), "Number") || Objects.equals(operateTypeEntity.getDataType(), "String")) && Objects.equals(item.getDicDataType(), DicTypeEnum.dic_type.getValue())) {
                    boolean filterFlag;
                    boolean bl = filterFlag = Objects.equals(operateTypeEntity.getOperateField(), "equal") || Objects.equals(operateTypeEntity.getOperateField(), "not_equal");
                    if (!filterFlag) continue;
                }
                OperateTypeItem operateTypeItem = new OperateTypeItem();
                BeanUtils.copyProperties((Object)operateTypeEntity, (Object)operateTypeItem);
                if (operateTypeEntity.getOperateName().indexOf("\u4ecb\u4e8e") >= 0) {
                    operateTypeItem.setMoreParam(1);
                } else {
                    operateTypeItem.setMoreParam(0);
                }
                if (Objects.equals(operateTypeEntity.getDataType(), "Date") || Objects.equals(operateTypeEntity.getDataType(), "DateTime")) {
                    if (operateTypeEntity.getOperateName().indexOf("\u665a\u4e8e") > -1 || operateTypeEntity.getOperateName().indexOf("\u65e9\u4e8e") > -1 || operateTypeEntity.getOperateName().indexOf("\u4ecb\u4e8e\u4e4b\u95f4") > -1) {
                        operateTypeItem.setTimeTypeId(TimeTypeEnum.absolutely_time.getValue());
                    } else {
                        operateTypeItem.setTimeTypeId(TimeTypeEnum.relative_time.getValue());
                    }
                }
                operateItemList.add(operateTypeItem);
            }
            conditionProperty.setOperateTypeItemList(operateItemList);
            conditionProperty.setNeedParams(Objects.equals(propertyEntity.getProperytDataType(), PropertyDataTypeEnum.Compute_type.getValue()) ? 0 : 1);
            conditionProperty.setNeedParamsDesc(conditionProperty.getNeedParams() == 1 ? "\u9700\u8981\u53c2\u6570" : "\u4e0d\u9700\u8981\u53c2\u6570");
            if (Objects.equals(propertyEntity.getProperytDataType(), "Date") || Objects.equals(propertyEntity.getProperytDataType(), "DateTime")) {
                ArrayList<TimeTypeItem> timeTypeItemList = new ArrayList<TimeTypeItem>();
                TimeTypeItem timeTypeItem = new TimeTypeItem();
                timeTypeItem.setId(TimeTypeEnum.relative_time.getValue());
                timeTypeItem.setName(TimeTypeEnum.relative_time.getName());
                timeTypeItem.setActiveTimeItemList(this.getActiveTimeItemList());
                timeTypeItemList.add(timeTypeItem);
                TimeTypeItem timeTypeItem1 = new TimeTypeItem();
                timeTypeItem1.setId(TimeTypeEnum.absolutely_time.getValue());
                timeTypeItem1.setName(TimeTypeEnum.absolutely_time.getName());
                timeTypeItemList.add(timeTypeItem1);
                conditionProperty.setTimeTypeItemList(timeTypeItemList);
            }
            result.add(conditionProperty);
        }
        return result;
    }

    private List<ActiveTimeItem> getActiveTimeItemList() {
        ArrayList<ActiveTimeItem> activeTimeItemList = new ArrayList<ActiveTimeItem>();
        ActiveTimeItem minute = new ActiveTimeItem();
        minute.setName("\u5206\u949f");
        minute.setValue("MINUTE");
        activeTimeItemList.add(minute);
        ActiveTimeItem hour = new ActiveTimeItem();
        hour.setName("\u5c0f\u65f6");
        hour.setValue("HOUR");
        activeTimeItemList.add(hour);
        ActiveTimeItem day = new ActiveTimeItem();
        day.setName("\u5929");
        day.setValue("DAY");
        activeTimeItemList.add(day);
        ActiveTimeItem week = new ActiveTimeItem();
        week.setName("\u5468");
        week.setValue("WEEK");
        activeTimeItemList.add(week);
        ActiveTimeItem month = new ActiveTimeItem();
        month.setName("\u6708");
        month.setValue("MONTH");
        activeTimeItemList.add(month);
        ActiveTimeItem ji = new ActiveTimeItem();
        ji.setName("\u5b63");
        ji.setValue("QUARTER");
        activeTimeItemList.add(ji);
        ActiveTimeItem year = new ActiveTimeItem();
        year.setName("\u5e74");
        year.setValue("YEAR");
        activeTimeItemList.add(year);
        return activeTimeItemList;
    }
}

