/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.scene.usergroup;

import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.scrm.entity.AppEnum;
import cc.lechun.scrm.entity.event.EventEntity;
import cc.lechun.scrm.entity.property.EventPropertyEntity;
import cc.lechun.scrm.entity.property.EventPropertyTypeEnum;
import cc.lechun.scrm.entity.property.PropertyEntity;
import cc.lechun.scrm.entity.scene.RuleItem;
import cc.lechun.scrm.entity.scene.UserGroup;
import cc.lechun.scrm.iservice.event.EventInterface;
import cc.lechun.scrm.iservice.property.EventPropertyInterface;
import cc.lechun.scrm.iservice.property.PropertyInterface;
import cc.lechun.scrm.service.scene.usergroup.ProfileRuleContext;
import cc.lechun.scrm.service.scene.usergroup.UserGroupBase;
import cc.lechun.scrm.service.scene.usergroup.measure.MeasureRuleContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventContext
extends UserGroupBase {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private EventInterface eventInterface;
    @Autowired
    private EventPropertyInterface eventPropertyInterface;
    @Autowired
    private PropertyInterface propertyInterface;
    @Autowired
    ProfileRuleContext profileRuleContext;
    @Autowired
    MeasureRuleContext measureRuleContext;
    @Autowired
    protected RedisCacheUtil redisCacheUtil;
    private static String distingSql = " LEFT JOIN\n(\n\tSELECT\n\t\tc.CUSTOMER_ID  FROM `lechundb-2016_lechun`.t_scrm_route_customer c\n\tWHERE\n\t\t\t\tc.KEFU_USE_STATUS >= 0\n\t\t\t\tAND c.CREATE_DATE > DATE_ADD(${CURDATE}, INTERVAL -7 DAY)\n\t\t\t\tAND c.CREATE_DATE < DATE_ADD(${CURDATE}, INTERVAL +1 DAY)\n) T ON t0.CUSTOMER_ID = T.CUSTOMER_ID\n     where T.CUSTOMER_ID IS NULL";

    public BaseJsonVo<Map<String, String>> getSceneSql(UserGroup userGroup) {
        return this.getSceneSql(userGroup, 0);
    }

    public BaseJsonVo<Map<String, String>> getSceneSql(UserGroup userGroup, Integer execDay) {
        StringBuilder condition = new StringBuilder();
        StringBuilder queryHead = new StringBuilder();
        StringBuilder queryHeadCount = new StringBuilder();
        StringBuilder countCondition = new StringBuilder();
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        if (userGroup.getGroupId() == null) {
            userGroup.setGroupId(0);
        }
        ArrayList<String> queryTemplateList = new ArrayList<String>();
        HashSet<String> queryTemplateSet = new HashSet<String>();
        ArrayList<String> insertTemplateList = new ArrayList<String>();
        int i = 1;
        String joinKey = (userGroup.getGroupId() == null ? userGroup.getGroupName() : userGroup.getGroupId().toString()) + ":0:JoinKey:" + userGroup.getAppId();
        String joinKeyValue = "CUSTOMER_ID";
        if (Objects.equals(userGroup.getAppId(), AppEnum.SALES.getValue())) {
            joinKeyValue = "CLUE_ID";
        }
        this.redisCacheUtil.set(joinKey, (Object)joinKeyValue, Long.valueOf(600L));
        for (RuleItem ruleItem : userGroup.getUserGroupRule().getRuleList()) {
            Map<String, Object> resultMap = this.getRuleSql(userGroup, ruleItem, condition, countCondition, i, execDay);
            if (Objects.equals(resultMap.get("statsu"), 0)) {
                return BaseJsonVo.error((String)resultMap.get("message").toString());
            }
            if (resultMap.get("showTemplate") != null && StringUtils.isNotEmpty((String)resultMap.get("showTemplate").toString())) {
                String template = resultMap.get("showTemplate").toString();
                for (String item : template.split(",")) {
                    String[] arr = item.split(" ");
                    this.logger.info("\u8bfb\u6a21\u677f\u5217:{}", (Object)("t" + i + "." + arr[arr.length - 1]));
                    this.logger.info("\u5199\u6a21\u677f\u5217:{}", (Object)arr[arr.length - 1]);
                    if (queryTemplateSet.contains(arr[arr.length - 1].toLowerCase())) continue;
                    queryTemplateSet.add(arr[arr.length - 1].toLowerCase());
                    queryTemplateList.add("t" + i + "." + arr[arr.length - 1]);
                    insertTemplateList.add(arr[arr.length - 1]);
                }
            }
            ++i;
        }
        if (userGroup.getUserEvent() != null && userGroup.getUserEvent().getFiltersRuleList() != null) {
            RuleItem ruleItem = new RuleItem();
            BeanUtils.copyProperties((Object)userGroup.getUserEvent(), (Object)ruleItem);
            queryHead.append(this.getUserSql(userGroup.getGroupId(), userGroup.getSceneType(), ruleItem, queryTemplateList, userGroup.getAppId()));
            queryHeadCount.append(this.getUserCountSql(ruleItem, execDay, userGroup.getAppId()));
        } else {
            queryHead.append(this.getUserSql(userGroup.getGroupId(), userGroup.getSceneType(), queryTemplateList, userGroup.getAppId()));
            queryHeadCount.append(this.getUserCountSql(userGroup.getAppId()));
        }
        if (Objects.equals(userGroup.getAppId(), AppEnum.SCRM.getValue()) && Objects.equals(userGroup.getDistinctStatus(), 1)) {
            if (execDay == null) {
                execDay = 0;
            }
            if (execDay == null || execDay == 0) {
                distingSql = distingSql.replace("${now}", " now()");
                distingSql = distingSql.replace("${CURDATE}", "CURDATE()");
            } else {
                distingSql = distingSql.replace("${now}", "DATE_ADD(now(),INTERVAL " + execDay + " DAY)");
                distingSql = distingSql.replace("${CURDATE}", "DATE_ADD(CURDATE(),INTERVAL " + execDay + " DAY)");
            }
            condition.append(" " + distingSql);
            countCondition.append(" " + distingSql);
        }
        this.logger.info(" \u8bfbsql={}", (Object)condition.toString());
        if (userGroup.getChooseCount() != null && userGroup.getChooseCount() > 0) {
            condition.append(" LIMIT " + userGroup.getChooseCount());
        }
        String writeUserSqlTemplate = this.getWriteUserSql(insertTemplateList, userGroup.getAppId()) + queryHead.toString() + condition.toString();
        this.logger.info(" \u5199 sql={}", (Object)writeUserSqlTemplate);
        sqlMap.put("writeSql", writeUserSqlTemplate);
        this.logger.info(" \u8bfb\u7528\u6237\u8bb0\u5f55\u6570 sql={}", (Object)(queryHeadCount.toString() + countCondition.toString()));
        sqlMap.put("readSql", queryHeadCount.toString() + countCondition.toString());
        return BaseJsonVo.success(sqlMap);
    }

    private Map<String, Object> getRuleSql(UserGroup userGroup, RuleItem ruleItem, StringBuilder condition, StringBuilder countCondition, int i, Integer execDay) {
        boolean addDataBase;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("showTemplate", "");
        EventEntity eventEntity = (EventEntity)this.eventInterface.selectByPrimaryKey(ruleItem.getEventId());
        EventPropertyEntity eventPropertyEntity = new EventPropertyEntity();
        eventPropertyEntity.setEventId(eventEntity.getEventId());
        List eventPropertyEntityList = this.eventPropertyInterface.getList(eventPropertyEntity, 0L);
        if (CollectionUtils.isEmpty((Collection)eventPropertyEntityList)) {
            this.logger.error("\u4e8b\u4ef6:{}\u5c5e\u6027\u672a\u914d\u7f6e", (Object)eventEntity.getEventName());
            result.put("statsu", 0);
            result.put("message", "\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return result;
        }
        Optional<EventPropertyEntity> joinPropertyOptional = eventPropertyEntityList.stream().filter(ep -> Objects.equals(ep.getEventPropertyType(), EventPropertyTypeEnum.join_property.getValue())).findFirst();
        if (!joinPropertyOptional.isPresent()) {
            this.logger.error("\u4e8b\u4ef6:{}\u8868\u8fde\u63a5\u5c5e\u6027\u672a\u914d\u7f6e", (Object)eventEntity.getEventName());
            String err = "\u4e8b\u4ef6:" + eventEntity.getEventName() + "\u672a\u6307\u5b9a\u8fde\u63a5\u5c5e\u6027";
            this.logger.error("\u7fa4\u7ec4:{} \u9519\u8bef\u6d88\u606f:{}", (Object)userGroup.toString(), (Object)err);
            throw new RuntimeException(err);
        }
        PropertyEntity propertyEntity = (PropertyEntity)this.propertyInterface.selectByPrimaryKey(joinPropertyOptional.get().getPropertyId());
        String where = this.profileRuleContext.getWhereSql(ruleItem, execDay);
        String measure = "";
        if (ruleItem.getMeasure() != null) {
            measure = this.measureRuleContext.getMeasureSql(ruleItem);
        }
        String joinKey = (userGroup.getGroupId() == null ? userGroup.getGroupName() : userGroup.getGroupId().toString()) + ":" + i + ":JoinKey:" + userGroup.getAppId();
        if (StringUtils.isEmpty((String)measure)) {
            measure = " GROUP BY " + propertyEntity.getPropertyField() + " ";
        }
        String previousKey = (userGroup.getGroupId() == null ? userGroup.getGroupName() : userGroup.getGroupId().toString()) + ":" + (i - 1) + ":JoinKey:" + userGroup.getAppId();
        String previousJoinField = this.redisCacheUtil.get(previousKey).toString();
        condition.append(" JOIN ");
        countCondition.append(" JOIN ");
        boolean bl = addDataBase = !eventEntity.getEventTableName().toUpperCase().contains("WHERE");
        String table = addDataBase ? (StringUtils.isNotEmpty((String)eventEntity.getEventDataBase()) ? eventEntity.getEventDataBase() + "." : "") : "";
        String showTemplate = propertyEntity.getPropertyField() + (StringUtils.isNotEmpty((String)eventEntity.getShowTemplate()) ? "," + eventEntity.getShowTemplate() : "");
        String eventJoin = " (SELECT " + showTemplate + " FROM " + table + eventEntity.getEventTableName() + where + (StringUtils.isNotEmpty((String)measure) ? measure : "") + " ) t" + i + " on t" + (i - 1) + "." + previousJoinField + "=t" + i + "." + propertyEntity.getPropertyField();
        condition.append(eventJoin);
        countCondition.append(eventJoin);
        this.redisCacheUtil.set(joinKey, (Object)propertyEntity.getPropertyField(), Long.valueOf(600L));
        result.put("statsu", 1);
        result.put("message", "\u6210\u529f");
        result.put("showTemplate", eventEntity.getShowTemplate());
        return result;
    }
}

