/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.scene.usergroup;

import cc.lechun.scrm.entity.property.EventPropertyEntity;
import cc.lechun.scrm.entity.property.PropertyEntity;
import cc.lechun.scrm.entity.scene.FiltersRule;
import cc.lechun.scrm.entity.scene.RuleItem;
import cc.lechun.scrm.iservice.property.EventPropertyInterface;
import cc.lechun.scrm.iservice.property.OperateTypeInterface;
import cc.lechun.scrm.iservice.property.PropertyInterface;
import cc.lechun.scrm.service.scene.usergroup.operate.OperateTypeContext;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProfileRuleContext {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PropertyInterface propertyInterface;
    @Autowired
    private EventPropertyInterface eventPropertyInterface;
    @Autowired
    private OperateTypeInterface operateTypeInterface;
    @Autowired
    OperateTypeContext operateTypeContext;

    public String getWhereSql(RuleItem ruleItem, Integer execDay) {
        StringBuilder stringBuilderWhere = new StringBuilder();
        int i = 1;
        if (CollectionUtils.isNotEmpty(ruleItem.getFiltersRuleList())) {
            for (FiltersRule filtersRule : ruleItem.getFiltersRuleList()) {
                EventPropertyEntity eventPropertyEntity = (EventPropertyEntity)this.eventPropertyInterface.selectByPrimaryKey(filtersRule.getEventPropertyId());
                if (eventPropertyEntity == null) {
                    this.logger.error("\u4e8b\u4ef6\u5c5e\u6027:{}\u914d\u7f6e\u9519\u8bef", (Object)filtersRule.getEventPropertyId());
                    return "";
                }
                PropertyEntity propertyEntity = (PropertyEntity)this.propertyInterface.selectByPrimaryKey(eventPropertyEntity.getPropertyId());
                if (propertyEntity == null) {
                    this.logger.error("\u5c5e\u6027:{}\u914d\u7f6e\u9519\u8bef", (Object)eventPropertyEntity.getPropertyId());
                    return "";
                }
                if (i == 1) {
                    stringBuilderWhere.append(" where ");
                } else {
                    stringBuilderWhere.append(" " + filtersRule.getRelation().toUpperCase() + " ");
                }
                try {
                    stringBuilderWhere.append(this.operateTypeContext.getWhereSql(filtersRule, execDay));
                }
                catch (Exception e) {
                    this.logger.error("\u62fc\u88c5sql\u6761\u4ef6\u51fa\u9519 {}", (Object)ruleItem.toString(), (Object)e);
                }
                ++i;
            }
        }
        this.logger.info(" \u7ec4\u88c5\u7684where={}", (Object)stringBuilderWhere.toString());
        return stringBuilderWhere.toString();
    }
}

