/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.scene.usergroup;

import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.scrm.entity.event.EventEntity;
import cc.lechun.scrm.entity.event.EventTypeEnum;
import cc.lechun.scrm.entity.scene.RuleItem;
import cc.lechun.scrm.iservice.event.EventInterface;
import cc.lechun.scrm.service.scene.usergroup.ProfileRuleContext;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UserGroupBase {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private EventInterface eventInterface;
    @Autowired
    ProfileRuleContext profileRuleContext;

    public String getUserSql(int sceneId, int sceneType, List<String> list, Integer appId) {
        EventEntity query = new EventEntity();
        query.setEventType(EventTypeEnum.user_event.getValue());
        query.setAppId(appId);
        EventEntity eventEntity = (EventEntity)this.eventInterface.getSingle(query, 0L);
        String template = this.getTemplate(list);
        return " SELECT t0.*" + template + " FROM  ( SELECT " + sceneId + " as SCENE_ID," + sceneType + " as SCENE_TYPE," + appId + " as APP_ID, " + eventEntity.getReadTemplate() + " FROM " + (StringUtils.isNotEmpty((String)eventEntity.getEventDataBase()) ? eventEntity.getEventDataBase() + "." : "") + eventEntity.getEventTableName() + " ) t0  ";
    }

    private String getMainTableName(EventEntity eventEntity) {
        if (eventEntity == null) {
            return "";
        }
        if (StringUtils.isNotEmpty((String)eventEntity.getEventTableNameAlias())) {
            return eventEntity.getEventTableNameAlias();
        }
        return eventEntity.getEventTableName();
    }

    public String getUserSql(int sceneId, Integer sceneType, RuleItem ruleItem, List<String> list, Integer appId) {
        EventEntity query = new EventEntity();
        query.setEventType(EventTypeEnum.user_event.getValue());
        query.setAppId(appId);
        EventEntity eventEntity = (EventEntity)this.eventInterface.getSingle(query, 0L);
        String where = "";
        if (CollectionUtils.isNotEmpty(ruleItem.getFiltersRuleList())) {
            try {
                where = this.profileRuleContext.getWhereSql(ruleItem, null);
            }
            catch (Exception e) {
                this.logger.error("\u62fc\u88c5sql \u51fa\u9519:{}", (Object)ruleItem.toString());
            }
        }
        String template = this.getTemplate(list);
        return " SELECT t0.*" + template + " FROM  (SELECT " + sceneId + " as SCENE_ID," + sceneType + " as SCENE_TYPE," + appId + " as APP_ID," + eventEntity.getReadTemplate() + " FROM " + (StringUtils.isNotEmpty((String)eventEntity.getEventDataBase()) ? eventEntity.getEventDataBase() + "." : "") + eventEntity.getEventTableName() + " " + (StringUtils.isNotEmpty((String)where) ? where : "") + ") t0  ";
    }

    public String getUserCountSql(Integer appId) {
        EventEntity query = new EventEntity();
        query.setEventType(EventTypeEnum.user_event.getValue());
        query.setAppId(appId);
        EventEntity eventEntity = (EventEntity)this.eventInterface.getSingle(query, 0L);
        return "SELECT count(1) num FROM " + (StringUtils.isNotEmpty((String)eventEntity.getEventDataBase()) ? eventEntity.getEventDataBase() + "." : "") + this.getMainTableName(eventEntity) + " t0  ";
    }

    public String getUserCountSql(RuleItem ruleItem, Integer execDay, Integer appId) {
        EventEntity query = new EventEntity();
        query.setEventType(EventTypeEnum.user_event.getValue());
        query.setAppId(appId);
        EventEntity eventEntity = (EventEntity)this.eventInterface.getSingle(query, 0L);
        String where = "";
        if (CollectionUtils.isNotEmpty(ruleItem.getFiltersRuleList())) {
            where = this.profileRuleContext.getWhereSql(ruleItem, execDay);
        }
        return "SELECT count(1) num FROM (SELECT " + eventEntity.getReadTemplate() + " FROM " + (StringUtils.isNotEmpty((String)eventEntity.getEventDataBase()) ? eventEntity.getEventDataBase() + "." : "") + eventEntity.getEventTableName() + " " + (StringUtils.isNotEmpty((String)where) ? where : "") + ") t0  ";
    }

    public String getWriteUserSql(Integer appId) {
        EventEntity query = new EventEntity();
        query.setEventType(EventTypeEnum.write_user_event.getValue());
        query.setAppId(appId);
        EventEntity eventEntity = (EventEntity)this.eventInterface.getSingle(query, 0L);
        return "INSERT INTO " + eventEntity.getEventDataBase() + "." + eventEntity.getEventTableName() + "(  " + eventEntity.getWriteTemplate() + " ) ";
    }

    public String getWriteUserSql(List<String> list, Integer appId) {
        EventEntity query = new EventEntity();
        query.setEventType(EventTypeEnum.write_user_event.getValue());
        query.setAppId(appId);
        EventEntity eventEntity = (EventEntity)this.eventInterface.getSingle(query, 0L);
        String template = this.getTemplate(list);
        return "INSERT INTO " + eventEntity.getEventDataBase() + "." + eventEntity.getEventTableName() + "(  " + eventEntity.getWriteTemplate() + (StringUtils.isNotEmpty((String)template) ? template : "") + " ) ";
    }

    private String getTemplate(List<String> list) {
        String template = "";
        if (CollectionUtils.isNotEmpty(list)) {
            for (String item : list) {
                template = template + "," + item;
            }
        }
        return template;
    }
}

