/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.scene.usergroup.measure;

import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.scrm.entity.event.EventEntity;
import cc.lechun.scrm.entity.property.DataTypeFunEntity;
import cc.lechun.scrm.entity.property.EventPropertyEntity;
import cc.lechun.scrm.entity.property.EventPropertyTypeEnum;
import cc.lechun.scrm.entity.property.OperateTypeEntity;
import cc.lechun.scrm.entity.property.PropertyEntity;
import cc.lechun.scrm.entity.scene.RuleItem;
import cc.lechun.scrm.iservice.event.EventInterface;
import cc.lechun.scrm.iservice.property.DataTypeFunInterface;
import cc.lechun.scrm.iservice.property.EventPropertyInterface;
import cc.lechun.scrm.iservice.property.OperateTypeInterface;
import cc.lechun.scrm.iservice.property.PropertyInterface;
import cc.lechun.scrm.service.scene.usergroup.measure.MeasureRuleInterface;
import cc.lechun.scrm.service.scene.usergroup.operate.OperateTypeContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MeasureRuleContext {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PropertyInterface propertyInterface;
    @Autowired
    private EventPropertyInterface eventPropertyInterface;
    @Autowired
    private OperateTypeInterface operateTypeInterface;
    @Autowired
    private EventInterface eventInterface;
    @Autowired
    private DataTypeFunInterface dataTypeFunInterface;
    @Autowired
    OperateTypeContext operateTypeContext;
    private final Map<String, MeasureRuleInterface> measureRuleInterfaceMap = new ConcurrentHashMap<String, MeasureRuleInterface>();

    @Autowired
    public MeasureRuleContext(Map<String, MeasureRuleInterface> measureRuleHandle) {
        this.measureRuleInterfaceMap.clear();
        measureRuleHandle.forEach((k, v) -> this.measureRuleInterfaceMap.put((String)k, (MeasureRuleInterface)v));
    }

    public String getMeasureSql(RuleItem ruleItem) {
        String measureSql = "";
        String where = "";
        EventEntity eventEntity = (EventEntity)this.eventInterface.selectByPrimaryKey(ruleItem.getEventId());
        EventPropertyEntity eventPropertyEntity = new EventPropertyEntity();
        eventPropertyEntity.setEventId(eventEntity.getEventId());
        eventPropertyEntity.setStatus(1);
        List eventPropertyEntityList = this.eventPropertyInterface.getList(eventPropertyEntity);
        Optional<EventPropertyEntity> joinPropertyOptional = eventPropertyEntityList.stream().filter(ep -> Objects.equals(ep.getEventPropertyType(), EventPropertyTypeEnum.join_property.getValue())).findFirst();
        if (!joinPropertyOptional.isPresent()) {
            throw new RuntimeException("\u8868\u8fde\u63a5\u5c5e\u6027\u672a\u914d\u7f6e,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        PropertyEntity propertyEntity = (PropertyEntity)this.propertyInterface.selectByPrimaryKey(joinPropertyOptional.get().getPropertyId());
        if (CollectionUtils.isEmpty((Collection)eventPropertyEntityList)) {
            throw new RuntimeException("\u5c5e\u6027\u672a\u914d\u7f6e,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (ruleItem.getMeasure() == null || StringUtils.isEmpty((String)ruleItem.getMeasure().getParams()) || ruleItem.getMeasure().getFunId() == null || ruleItem.getMeasure().getOperateId() == null) {
            measureSql = " GROUP BY " + propertyEntity.getPropertyField() + " ";
            this.logger.info("\u805a\u5408\u6761\u4ef6\u4e3a\u7a7a\u7684 \u7ec4\u88c5\u7684group by sql={}", (Object)measureSql);
        } else {
            OperateTypeEntity operateTypeEntity = (OperateTypeEntity)this.operateTypeInterface.selectByPrimaryKey(ruleItem.getMeasure().getOperateId());
            this.logger.info("\u805a\u5408id:{}", (Object)ruleItem.getMeasure().getFunId());
            DataTypeFunEntity dataTypeFunEntity = (DataTypeFunEntity)this.dataTypeFunInterface.selectByPrimaryKey(ruleItem.getMeasure().getFunId());
            this.logger.info("\u805a\u5408\u51fd\u6570:{}", (Object)dataTypeFunEntity.getFunField());
            if (StringUtils.isEmpty((String)ruleItem.getMeasure().getAggregator())) {
                ruleItem.getMeasure().setAggregator(dataTypeFunEntity.getFunField());
            }
            EventPropertyEntity measureEventProperty = (EventPropertyEntity)this.eventPropertyInterface.selectByPrimaryKey(ruleItem.getMeasure().getEventPropertyId());
            PropertyEntity measurePropertyEntity = (PropertyEntity)this.propertyInterface.selectByPrimaryKey(measureEventProperty.getPropertyId());
            MeasureRuleInterface measureRuleInterface = this.measureRuleInterfaceMap.get("measure_" + measurePropertyEntity.getProperytDataType());
            if (measureRuleInterface != null) {
                where = measureRuleInterface.getMeasureSql(operateTypeEntity, dataTypeFunEntity, ruleItem.getMeasure());
                where = where + " ";
            }
            measureSql = " GROUP BY " + propertyEntity.getPropertyField() + "  HAVING " + dataTypeFunEntity.getFunField() + "(" + measurePropertyEntity.getPropertyField() + ")" + where;
            this.logger.info(" \u7ec4\u88c5\u7684group by having sql={}", (Object)measureSql);
        }
        return measureSql;
    }
}

