/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.scene.usergroup.operate;

import cc.lechun.scrm.entity.property.EventPropertyEntity;
import cc.lechun.scrm.entity.property.OperateTypeEntity;
import cc.lechun.scrm.entity.property.PropertyEntity;
import cc.lechun.scrm.entity.scene.FiltersRule;
import cc.lechun.scrm.entity.scene.TimeTypeEnum;
import cc.lechun.scrm.iservice.property.EventPropertyInterface;
import cc.lechun.scrm.iservice.property.OperateTypeInterface;
import cc.lechun.scrm.iservice.property.PropertyInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DateOperateBase {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OperateTypeInterface operateTypeInterface;
    @Autowired
    private EventPropertyInterface eventPropertyInterface;
    @Autowired
    private PropertyInterface propertyInterface;

    public String getWhereSql(FiltersRule filtersRule) {
        return this.getWhereSql(filtersRule, 0);
    }

    public String getWhereSql(FiltersRule filtersRule, Integer day) {
        List<String> sortArr;
        String where = "";
        String date = "";
        date = day == null || day == 0 ? "CURDATE() " : "DATE_ADD(CURDATE(),INTERVAL " + day + " DAY) ";
        boolean oneDayFlag = false;
        OperateTypeEntity operateTypeEntity = (OperateTypeEntity)this.operateTypeInterface.selectByPrimaryKey(filtersRule.getOperateId());
        EventPropertyEntity eventPropertyEntity = (EventPropertyEntity)this.eventPropertyInterface.selectByPrimaryKey(filtersRule.getEventPropertyId());
        PropertyEntity propertyEntity = (PropertyEntity)this.propertyInterface.selectByPrimaryKey(eventPropertyEntity.getPropertyId());
        if (Objects.equals(filtersRule.getTimeTypeId(), TimeTypeEnum.relative_time.getValue()) && (filtersRule.getParams().contains("HOUR") || filtersRule.getParams().contains("MINUTE"))) {
            date = day == null || day == 0 ? "NOW() " : "DATE_ADD(NOW(),INTERVAL " + day + " DAY) ";
            oneDayFlag = true;
        }
        if (Objects.equals(operateTypeEntity.getOperateField(), "between")) {
            if (Objects.equals(filtersRule.getTimeTypeId(), TimeTypeEnum.relative_time.getValue())) {
                filtersRule.setParams(filtersRule.getParams().replace("-", " "));
                where = propertyEntity.getPropertyField() + " BETWEEN DATE_ADD(" + date + ",INTERVAL  " + filtersRule.getParams().split(",")[0] + ") AND DATE_ADD(" + date + ",INTERVAL " + filtersRule.getParams().split(",")[1] + ")";
            } else {
                where = propertyEntity.getPropertyField() + " BETWEEN '" + filtersRule.getParams().split(",")[0] + "' AND '" + filtersRule.getParams().split(",")[1] + "'";
            }
        }
        if (Objects.equals(operateTypeEntity.getOperateField(), "betweenBefore")) {
            if (Objects.equals(filtersRule.getTimeTypeId(), TimeTypeEnum.relative_time.getValue())) {
                sortArr = this.getBeforeBetweentList(filtersRule.getParams());
                if (oneDayFlag) {
                    sortArr = this.getBeforeHourOrMinuteBetweentList(filtersRule.getParams());
                }
                where = propertyEntity.getPropertyField() + ">= DATE_ADD(" + date + ",INTERVAL " + sortArr.get(0) + ") AND " + propertyEntity.getPropertyField() + "< DATE_ADD(" + date + ",INTERVAL " + sortArr.get(1) + ")";
            } else {
                where = propertyEntity.getPropertyField() + " BETWEEN '" + filtersRule.getParams().split(",")[0] + "' AND '" + filtersRule.getParams().split(",")[1] + "' ";
            }
        }
        if (Objects.equals(operateTypeEntity.getOperateField(), "betweenAfter")) {
            if (Objects.equals(filtersRule.getTimeTypeId(), TimeTypeEnum.relative_time.getValue())) {
                sortArr = this.getAfterBetweenList(filtersRule.getParams());
                if (oneDayFlag) {
                    sortArr = this.getAfterHourOrMinuteBetweenList(filtersRule.getParams());
                }
                where = propertyEntity.getPropertyField() + ">= DATE_ADD(" + date + ",INTERVAL  " + sortArr.get(0) + ") AND " + propertyEntity.getPropertyField() + "< DATE_ADD(" + date + ",INTERVAL " + sortArr.get(1) + ")";
            } else {
                where = propertyEntity.getPropertyField() + " BETWEEN '" + filtersRule.getParams().split(",")[0] + "' AND '" + filtersRule.getParams().split(",")[1] + "' ";
            }
        } else if (Objects.equals(operateTypeEntity.getOperateField(), "greater")) {
            if (filtersRule.getParams().split(",").length == 1) {
                where = Objects.equals(filtersRule.getTimeTypeId(), TimeTypeEnum.relative_time.getValue()) ? propertyEntity.getPropertyField() + " >= ADDDATE(" + date + ",INTERVAL -" + filtersRule.getParams().replace("-", " ") + ") AND " + propertyEntity.getPropertyField() + "<ADDDATE(" + date + ",INTERVAL " + this.getBeforeParam(filtersRule.getParams()) + ")" : propertyEntity.getPropertyField() + " > '" + filtersRule.getParams() + "' ";
            }
        } else if (Objects.equals(operateTypeEntity.getOperateField(), "greater_or_equal")) {
            if (filtersRule.getParams().split(",").length == 1) {
                if (Objects.equals(filtersRule.getTimeTypeId(), TimeTypeEnum.relative_time.getValue())) {
                    filtersRule.setParams(filtersRule.getParams().replace("-", " "));
                    where = propertyEntity.getPropertyField() + " >= DATE_ADD(" + date + ",INTERVAL -" + filtersRule.getParams() + ") ";
                } else {
                    where = propertyEntity.getPropertyField() + " >= '" + filtersRule.getParams() + "' ";
                }
            }
        } else if (Objects.equals(operateTypeEntity.getOperateField(), "less")) {
            if (filtersRule.getParams().split(",").length == 1) {
                where = Objects.equals(filtersRule.getTimeTypeId(), TimeTypeEnum.relative_time.getValue()) ? propertyEntity.getPropertyField() + ">=ADDDATE(" + date + ",INTERVAL +" + filtersRule.getParams().replace("-", " ") + ") AND " + propertyEntity.getPropertyField() + " < ADDDATE(" + date + ",INTERVAL " + this.getAfterParam(filtersRule.getParams()) + ")" : propertyEntity.getPropertyField() + " < '" + filtersRule.getParams() + "'";
            }
        } else if (Objects.equals(operateTypeEntity.getOperateField(), "less_or_equal")) {
            if (filtersRule.getParams().split(",").length == 1) {
                if (Objects.equals(filtersRule.getTimeTypeId(), TimeTypeEnum.relative_time.getValue())) {
                    filtersRule.setParams(filtersRule.getParams().replace("-", " "));
                    where = propertyEntity.getPropertyField() + " <= DATE_ADD(" + date + ",INTERVAL " + filtersRule.getParams() + ") ";
                } else {
                    where = propertyEntity.getPropertyField() + " <= '" + filtersRule.getParams() + "' ";
                }
            }
        } else if (Objects.equals(operateTypeEntity.getOperateField(), "is_not_null")) {
            where = propertyEntity.getPropertyField() + " is not null ";
        } else if (Objects.equals(operateTypeEntity.getOperateField(), "is_null")) {
            where = propertyEntity.getPropertyField() + " is null ";
        }
        where = where.replace("--", "-");
        this.logger.info(" \u65e5\u671f\u7c7b\u578b \u62fc\u63a5 where\u6761\u4ef6:{} ", (Object)where);
        return where;
    }

    private List<String> getBeforeBetweentList(String param) {
        List<Integer> arr = this.getValueList(param);
        String measure = param.split(",")[0].split("-")[1];
        ArrayList<String> result = new ArrayList<String>();
        arr.sort((a, b) -> b - a);
        for (int i = 0; i < arr.size(); ++i) {
            if (i == arr.size() - 1) {
                arr.set(i, arr.get(i) - 1);
            }
            result.add((arr.get(i) > 0 ? "-" + arr.get(i) : (Serializable)arr.get(i)) + " " + measure);
        }
        return result;
    }

    private List<String> getBeforeHourOrMinuteBetweentList(String param) {
        List<Integer> arr = this.getValueList(param);
        String measure = param.split(",")[0].split("-")[1];
        ArrayList<String> result = new ArrayList<String>();
        arr.sort((a, b) -> b - a);
        for (int i = 0; i < arr.size(); ++i) {
            if (i == arr.size() - 1) {
                arr.set(i, arr.get(i));
            }
            result.add("-" + arr.get(i) + " " + measure);
        }
        return result;
    }

    private String getBeforeParam(String param) {
        Integer value = Integer.valueOf(param.split("-")[0]);
        String measure = param.split("-")[1];
        if (value - 1 < 0) {
            return Math.abs(value - 1) + " " + measure;
        }
        return "-" + (value - 1) + " " + measure;
    }

    private List<Integer> getValueList(String param) {
        ArrayList<Integer> arr = new ArrayList<Integer>();
        if (param.split(",").length > 1) {
            for (String item : param.split(",")) {
                arr.add(Integer.valueOf(item.split("-")[0]));
            }
        }
        return arr;
    }

    private List<String> getAfterHourOrMinuteBetweenList(String param) {
        List<Integer> arr = this.getValueList(param);
        String measure = param.split(",")[0].split("-")[1];
        arr.sort((a, b) -> a - b);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < arr.size(); ++i) {
            if (i == arr.size() - 1) {
                arr.set(i, arr.get(i));
            }
            result.add("+" + arr.get(i) + " " + measure);
        }
        return result;
    }

    private List<String> getAfterBetweenList(String param) {
        List<Integer> arr = this.getValueList(param);
        String measure = param.split(",")[0].split("-")[1];
        arr.sort((a, b) -> a - b);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < arr.size(); ++i) {
            if (i == arr.size() - 1) {
                arr.set(i, arr.get(i) + 1);
            }
            result.add("+" + arr.get(i) + " " + measure);
        }
        return result;
    }

    private String getAfterParam(String param) {
        Integer value = Integer.valueOf(param.split("-")[0]);
        String measure = param.split("-")[1];
        return "+" + (value + 1) + " " + measure;
    }
}

