/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.scene.usergroup.operate;

import cc.lechun.scrm.entity.property.EventPropertyEntity;
import cc.lechun.scrm.entity.property.OperateTypeEntity;
import cc.lechun.scrm.entity.property.PropertyEntity;
import cc.lechun.scrm.entity.scene.FiltersRule;
import cc.lechun.scrm.iservice.property.EventPropertyInterface;
import cc.lechun.scrm.iservice.property.OperateTypeInterface;
import cc.lechun.scrm.iservice.property.PropertyInterface;
import cc.lechun.scrm.service.scene.usergroup.operate.OperateTypeRuleInterface;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="type_String")
public class StringOperateHandle
implements OperateTypeRuleInterface {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OperateTypeInterface operateTypeInterface;
    @Autowired
    private EventPropertyInterface eventPropertyInterface;
    @Autowired
    private PropertyInterface propertyInterface;

    @Override
    public String getWhereSql(FiltersRule filtersRule) {
        String where = "";
        OperateTypeEntity operateTypeEntity = (OperateTypeEntity)this.operateTypeInterface.selectByPrimaryKey(filtersRule.getOperateId());
        EventPropertyEntity eventPropertyEntity = (EventPropertyEntity)this.eventPropertyInterface.selectByPrimaryKey(filtersRule.getEventPropertyId());
        PropertyEntity propertyEntity = (PropertyEntity)this.propertyInterface.selectByPrimaryKey(eventPropertyEntity.getPropertyId());
        if (Objects.equals(operateTypeEntity.getOperateField(), "equal")) {
            if (filtersRule.getParams().split(",").length == 1) {
                where = propertyEntity.getPropertyField() + "='" + filtersRule.getParams() + "'";
            } else if (filtersRule.getParams().split(",").length > 1) {
                String conditionStr = "";
                for (String item : filtersRule.getParams().split(",")) {
                    conditionStr = StringUtils.isEmpty((String)conditionStr) ? "'" + item + "'" : conditionStr + ",'" + item + "'";
                }
                where = propertyEntity.getPropertyField() + " in (" + conditionStr + ")";
            }
        } else if (Objects.equals(operateTypeEntity.getOperateField(), "not_equal")) {
            if (filtersRule.getParams().split(",").length == 1) {
                where = propertyEntity.getPropertyField() + "<>'" + filtersRule.getParams() + "'";
            } else if (filtersRule.getParams().split(",").length > 1) {
                String conditionStr = "";
                for (String item : filtersRule.getParams().split(",")) {
                    conditionStr = StringUtils.isEmpty((String)conditionStr) ? "'" + item + "'" : conditionStr + ",'" + item + "'";
                }
                where = propertyEntity.getPropertyField() + " not in (" + conditionStr + ")";
            }
        } else if (Objects.equals(operateTypeEntity.getOperateField(), "contain")) {
            if (filtersRule.getParams().split(",").length == 1) {
                where = propertyEntity.getPropertyField() + " like '% " + filtersRule.getParams() + "%'";
            } else if (filtersRule.getParams().split(",").length > 1) {
                where = propertyEntity.getPropertyField() + "  REGEXP '" + StringUtils.join((Object[])filtersRule.getParams().split(","), (String)"|") + "'";
            }
        } else if (Objects.equals(operateTypeEntity.getOperateField(), "not_contain")) {
            if (filtersRule.getParams().split(",").length == 1) {
                where = propertyEntity.getPropertyField() + " not like '%" + filtersRule.getParams() + "%'";
            } else if (filtersRule.getParams().split(",").length == 1) {
                where = propertyEntity.getPropertyField() + " NOT REGEXP '" + StringUtils.join((Object[])filtersRule.getParams().split(","), (String)"|") + "'";
            }
        } else if (Objects.equals(operateTypeEntity.getOperateField(), "is_not_null")) {
            where = propertyEntity.getPropertyField() + " is not null ";
        } else if (Objects.equals(operateTypeEntity.getOperateField(), "is_null")) {
            where = " (" + propertyEntity.getPropertyField() + " is null or " + propertyEntity.getPropertyField() + "='') ";
        }
        this.logger.info("String\u7c7b\u578b \u62fc\u63a5 where\u6761\u4ef6:{} ", (Object)where);
        return where;
    }

    @Override
    public String getWhereSql(FiltersRule filtersRule, Integer execDay) {
        return this.getWhereSql(filtersRule);
    }
}

