/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.variable;

import cc.lechun.scrm.entity.route.RouteCustomerEntity;
import cc.lechun.scrm.iservice.variable.VariableProcessInterface;
import cc.lechun.scrm.service.variable.Variable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VariableContext {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, VariableProcessInterface> concurrentHashMap = new ConcurrentHashMap<String, VariableProcessInterface>();

    @Autowired
    public VariableContext(Map<String, VariableProcessInterface> interfaceMap) {
        this.concurrentHashMap.clear();
        interfaceMap.forEach((k, v) -> this.concurrentHashMap.put((String)k, (VariableProcessInterface)v));
    }

    public String replaceVariable(String variableType, List<Variable> variables, String content, Integer materialId, RouteCustomerEntity routeCustomerEntity) {
        String result = "";
        VariableProcessInterface variableProcessInterface = this.concurrentHashMap.get("scrm_" + variableType);
        if (variableProcessInterface != null) {
            try {
                result = variableProcessInterface.replaceVariable(variableType, variables, content, materialId, routeCustomerEntity);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                e.printStackTrace();
            }
        } else {
            this.logger.error("\u83b7\u53d6\u53d8\u91cf\u5904\u7406\u5bf9\u8c61\u5931\u8d25\uff0cvariableType\uff1a" + variableType);
        }
        return result;
    }
}

