/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.variable;

import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.scrm.entity.route.RouteCustomerEntity;
import cc.lechun.scrm.iservice.material.MaterialInterface;
import cc.lechun.scrm.iservice.route.RouteCustomerInterface;
import cc.lechun.scrm.iservice.variable.VariableInterface;
import cc.lechun.scrm.service.variable.Variable;
import cc.lechun.scrm.service.variable.VariableContext;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VariableService
implements VariableInterface {
    @Autowired
    private MaterialInterface materialInterface;
    @Autowired
    VariableContext variableContext;
    @Autowired
    private RouteCustomerInterface routeCustomerInterface;

    @Override
    public BaseJsonVo replaceVariable(Integer materialId, Integer sceneId, Integer routeId, String routeRecordId, String textField) {
        Map map = this.materialInterface.getMaterialWithType(materialId);
        if (map.get(textField) == null) {
            return BaseJsonVo.error((String)"\u5b57\u6bb5\u4e3a\u7a7a");
        }
        String text = map.get(textField).toString();
        text = text.replace("'", "''");
        String regEx = "\\$\\{[^}]+}";
        String textresult = text;
        Pattern pattern = Pattern.compile(regEx, 2);
        Matcher matcher = pattern.matcher(text);
        LinkedList<Variable> variables = new LinkedList<Variable>();
        while (matcher.find()) {
            String var1 = text.substring(matcher.start(), matcher.end());
            System.out.println("\u53d8\u91cf\uff1a" + var1);
            String var2 = var1.replace("${", "").replace("}", "");
            Variable variable = new Variable();
            variable.setVariable(var1);
            if (var2.indexOf(".") < 0) {
                variable.setVariableType("routeCustomer");
                variable.setVariableValue(var2);
            } else {
                variable.setVariableType(var2.split("\\.")[0]);
                variable.setVariableValue(var2.split("\\.")[1]);
            }
            variables.add(variable);
        }
        Map<String, List<Variable>> maps = variables.stream().collect(Collectors.groupingBy(Variable::getVariableType));
        RouteCustomerEntity search = new RouteCustomerEntity();
        search.setRouteId(routeId);
        search.setSceneId(sceneId);
        search.setRouteRecordId(routeRecordId);
        search = (RouteCustomerEntity)this.routeCustomerInterface.getSingle(search);
        for (String m : maps.keySet()) {
            textresult = this.variableContext.replaceVariable(m, maps.get(m), textresult, materialId, search);
        }
        System.out.println(textresult);
        return BaseJsonVo.success((Object)(textresult.startsWith("replace") ? textresult : "'" + textresult + "'"));
    }
}

