/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.utils;

import cc.lechun.framework.common.utils.date.DateUtils;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class DateUtil {
    private static final SimpleDateFormat longSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat longHourSdf = new SimpleDateFormat("yyyy-MM-dd HH");

    public static int getQuarter(Date date) {
        Calendar cal = Calendar.getInstance();
        int m = cal.get(2) + 1;
        Integer quarter = 0;
        if (m >= 1 && m <= 3) {
            quarter = 1;
        }
        if (m >= 4 && m <= 6) {
            quarter = 2;
        }
        if (m >= 7 && m <= 9) {
            quarter = 3;
        }
        if (m >= 10 && m <= 12) {
            quarter = 4;
        }
        return quarter;
    }

    public static Set<Integer> getWeekOfQuarter(Date date) {
        HashSet<Integer> r = new HashSet<Integer>();
        Date sdate = DateUtil.getCurrentQuarterStartTime(date);
        Date edate = DateUtil.getCurrentQuarterEndTime(date);
        Integer sweek = DateUtil.getWeekOfYear(sdate);
        Integer eweek = DateUtil.getWeekOfYear(edate);
        for (int i = sweek.intValue(); i <= eweek; ++i) {
            r.add(i);
        }
        return r;
    }

    public static Integer getWeekOfYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(3);
    }

    public static Integer getYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(1);
    }

    public static Integer getMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(2);
    }

    public static Integer getDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5);
    }

    public static Integer getWeekOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(4);
    }

    public static boolean isMonthLastWeek(Date weekFirstDate) {
        if (weekFirstDate.compareTo(DateUtils.StrToDate((String)"2021-02-01", (String)"yyyy-MM-dd")) == 0) {
            return true;
        }
        if (weekFirstDate.compareTo(DateUtils.StrToDate((String)"2021-01-25", (String)"yyyy-MM-dd")) == 0) {
            return false;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(weekFirstDate);
        int day1 = c.get(5) + 1;
        int lastDay = c.getActualMaximum(5);
        Date s = DateUtils.getAddDateByDay((Date)weekFirstDate, (int)6);
        c.setTime(s);
        int day2 = c.get(5);
        if (day1 < day2) {
            if (day2 + 3 >= lastDay) {
                System.out.println("=========================================" + weekFirstDate + " -true ");
                return true;
            }
            return false;
        }
        if (day2 - 3 < 1) {
            System.out.println("=========================================" + weekFirstDate + " -true ");
            return true;
        }
        return day2 < 4;
    }

    public static Date getCurrentQuarterStartTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(2) + 1;
        Date now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                c.set(2, 0);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                c.set(2, 3);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                c.set(2, 4);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                c.set(2, 9);
            }
            c.set(5, 1);
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getCurrentQuarterEndTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(2) + 1;
        Date now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                c.set(2, 2);
                c.set(5, 31);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                c.set(2, 5);
                c.set(5, 30);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                c.set(2, 8);
                c.set(5, 30);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                c.set(2, 11);
                c.set(5, 31);
            }
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 23:59:59");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static long getRemainSecondsOneDay(Date currentDate) {
        LocalDateTime midnight = LocalDateTime.ofInstant(currentDate.toInstant(), ZoneId.systemDefault()).plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
        LocalDateTime currentDateTime = LocalDateTime.ofInstant(currentDate.toInstant(), ZoneId.systemDefault());
        long seconds = ChronoUnit.SECONDS.between(currentDateTime, midnight);
        return seconds;
    }

    public static Integer dayForWeek(Date pTime) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        Integer[] weekDays = new Integer[]{7, 1, 2, 3, 4, 5, 6};
        try {
            cal.setTime(pTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static Integer getCurrentHour() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(11);
    }

    public static Integer getCurrentMinute() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(12);
    }
}

