/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.utils;

import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.json.JsonUtils;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;

public class LocationUtils {
    private static String tengXunKey = "M24BZ-NNNK4-2PDUP-XZ3FU-FDGKT-7WBYZ";
    private static String gaodeKey = "60ad273ec1c38fbdedb172a46a7494fd";

    public static Map getLocationAddressByTengxun(double longitude, double latitude) {
        Map result;
        String url = "https://apis.map.qq.com/ws/geocoder/v1/?get_poi=1&location=" + latitude + "," + longitude + "&key=" + tengXunKey + "&output=JSON";
        String json = HttpRequest.get((String)url, (String)"");
        HashedMap areaMap = new HashedMap();
        Map map = JsonUtils.stringToMap((String)json);
        if (map != null && map.get("status").toString().equals("0") && (result = JsonUtils.stringToMap((String)map.get("result").toString())) != null) {
            List mapList;
            Object pois;
            Map map1 = JsonUtils.stringToMap((String)result.get("address_component").toString());
            String province = "";
            String city = "";
            String area = "";
            String town = "";
            String housing = "";
            String type = "";
            if (map1 != null) {
                province = map1.get("province");
                city = map1.get("city");
                area = map1.get("district");
            }
            if ((map1 = JsonUtils.stringToMap((String)result.get("address_reference").toString())) != null && (map1 = JsonUtils.stringToMap((String)map1.get("town").toString())) != null) {
                town = map1.get("title");
            }
            if ((pois = result.get("pois")) != null && (mapList = JsonUtils.getListByArray(Map.class, (String)pois.toString())) != null && mapList.size() > 0) {
                housing = ((Map)mapList.get(0)).get("title");
                type = ((Map)mapList.get(0)).get("category");
            }
            areaMap.put("province", province);
            areaMap.put("city", city);
            areaMap.put("area", area);
            areaMap.put("town", town);
            areaMap.put("housing", housing);
            areaMap.put("type", type);
            areaMap.put("address", result.get("address"));
            areaMap.put("source", "tengxun");
        }
        return areaMap;
    }

    public static Map getLocationLngLatByTengxun(String address, String city) {
        HashedMap res = new HashedMap();
        try {
            String url;
            String json;
            Map r;
            if (!address.isEmpty() && (r = (Map)JsonUtils.fromJson((String)(json = HttpRequest.get((String)(url = "https://apis.map.qq.com/ws/geocoder/v1/?key=" + tengXunKey + "&address=" + URLEncoder.encode(city + address, "utf-8") + (StringUtils.isNotEmpty((String)city) ? "&region=" + city : "") + "&output=JSON"), (String)"")), Map.class)).get("status").equals(0)) {
                Map map = (Map)r.get("result");
                Map lnglat = (Map)map.get("location");
                return lnglat;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static Map getLocationFormatterAddress(String address, String city, int choose) {
        Map map;
        String lnglat;
        Map<String, String> resultMap = new HashMap();
        String town = "";
        String housing = "";
        if ((choose == 1 || choose == 0) && StringUtils.isNotEmpty((String)(lnglat = LocationUtils.getLocationLngLatByGaode(address, city))) && (resultMap = LocationUtils.getLocationAddressByGaode(lnglat)) != null && resultMap.size() > 0) {
            town = resultMap.get("town");
            housing = resultMap.get("housing");
            if (resultMap.get("town") != null && StringUtils.isNotEmpty((String)resultMap.get("town").toString()) && resultMap.get("housing") != null && StringUtils.isNotEmpty((String)resultMap.get("housing").toString())) {
                return resultMap;
            }
        }
        if ((choose == 2 || choose == 0) && (map = LocationUtils.getLocationLngLatByTengxun(address, city)) != null && map.size() > 0 && (resultMap = LocationUtils.getLocationAddressByTengxun((Double)map.get("lng"), (Double)map.get("lat"))) != null) {
            if ((resultMap.get("town") == null || StringUtils.isEmpty((String)resultMap.get("town").toString())) && town != null && StringUtils.isNotEmpty((String)town.toString())) {
                resultMap.put("town", town);
                resultMap.put("source", "gaode&tengxun");
            }
            if ((resultMap.get("housing") == null || StringUtils.isEmpty((String)resultMap.get("housing").toString())) && housing != null && StringUtils.isNotEmpty((String)housing.toString())) {
                resultMap.put("housing", housing);
                resultMap.put("source", "gaode&tengxun");
            }
        }
        return resultMap;
    }

    public static Map getLocationAddressByGaode(String lnglat) {
        Map result;
        String url = "https://restapi.amap.com/v3/geocode/regeo?key=" + gaodeKey + "&location=" + lnglat + "&poitype=&radius=500&extensions=all&batch=false&roadlevel=0";
        String json = HttpRequest.get((String)url, (String)"");
        HashedMap areaMap = new HashedMap();
        Map map = JsonUtils.stringToMap((String)json);
        if (map != null && map.get("status").toString().equals("1") && (result = JsonUtils.stringToMap((String)map.get("regeocode").toString())) != null) {
            Object pois;
            Map map1 = JsonUtils.stringToMap((String)result.get("addressComponent").toString());
            String province = "";
            String city = "";
            String area = "";
            String town = "";
            String housing = "";
            String type = "";
            if (map1 != null) {
                province = map1.get("province");
                city = map1.get("city");
                area = map1.get("district");
                town = map1.get("township");
                if (city instanceof List) {
                    city = province;
                }
            }
            if ((pois = map1.get("neighborhood")) != null && (map1 = JsonUtils.stringToMap((String)pois.toString())) != null) {
                if (!(map1.get("name") instanceof List)) {
                    housing = map1.get("name");
                }
                if (!(map1.get("type") instanceof List)) {
                    type = map1.get("type");
                }
            }
            areaMap.put("province", province);
            areaMap.put("city", city);
            areaMap.put("area", area);
            areaMap.put("town", town);
            areaMap.put("housing", housing);
            areaMap.put("type", type);
            areaMap.put("address", result.get("formatted_address"));
            areaMap.put("source", "gaode");
        }
        return areaMap;
    }

    public static String getLocationLngLatByGaode(String address, String city) {
        try {
            Object location;
            List mapList;
            String url;
            String json;
            Map r;
            if (!address.isEmpty() && (r = (Map)JsonUtils.fromJson((String)(json = HttpRequest.get((String)(url = "https://restapi.amap.com/v3/geocode/geo?key=" + gaodeKey + "&address=" + address + "&city=" + city), (String)"")), Map.class)).get("status").equals("1") && (mapList = (List)r.get("geocodes")) != null && mapList.size() > 0 && (location = ((Map)mapList.get(0)).get("location")) != null && StringUtils.isNotEmpty((String)location.toString())) {
                return location.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private static double distance(double x1, double y1, double x2, double y2) {
        double EARTH_RADIUS = 6378.137;
        double lat1 = Math.toRadians(y1);
        double lat2 = Math.toRadians(y2);
        double lng1 = Math.toRadians(x1);
        double lng2 = Math.toRadians(x2);
        double a = lat1 - lat2;
        double b = lng1 - lng2;
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        return BigDecimal.valueOf(s *= 6378.137).setScale(6, 4).doubleValue();
    }

    public static double getDistance(String address1, String address2) {
        String ll = LocationUtils.getLocationLngLatByGaode(address1, "");
        if (StringUtils.isEmpty((String)ll)) {
            return -1.0;
        }
        String[] s = ll.split(",");
        double x1 = Double.valueOf(s[0]);
        double y1 = Double.valueOf(s[1]);
        ll = LocationUtils.getLocationLngLatByGaode(address2, "");
        if (StringUtils.isEmpty((String)ll)) {
            return -1.0;
        }
        s = ll.split(",");
        double x2 = Double.valueOf(s[0]);
        double y2 = Double.valueOf(s[1]);
        return LocationUtils.distance(x1, y1, x2, y2);
    }
}

