/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.utils;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.http.HttpUtil;
import cc.lechun.utils.DateUtil;
import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PeriodUtil {
    public static void main(String[] args) {
        PeriodUtil.buildCalendar(2022, null);
    }

    public static Map<String, Object> getDay(Date date, String weekend, JSONObject holidayJson) {
        JSONObject jsonObject = holidayJson == null ? PeriodUtil.getHoliday(DateUtil.getYear(date)) : holidayJson;
        String key = DateUtils.formatDate((Date)date, (String)"MM-dd");
        JSONObject o = jsonObject == null ? null : jsonObject.getJSONObject(key);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("date", date);
        Integer week = DateUtil.dayForWeek(date);
        if (week.equals(6) || week.equals(7)) {
            map.put("isHoliday", Short.valueOf("1"));
            map.put("holidayName", "\u5468\u672b");
        } else {
            map.put("isHoliday", Short.valueOf("0"));
            map.put("holidayName", "\u5de5\u4f5c\u65e5");
        }
        if (weekend.indexOf(String.valueOf(week)) >= 0) {
            map.put("qyWorkType", 1);
        } else {
            map.put("qyWorkType", 0);
        }
        if (o != null) {
            Boolean isHoliday = o.getBoolean("holiday");
            String name = o.getString("name");
            map.put("isHoliday", isHoliday != false ? Short.valueOf("2") : Short.valueOf("0"));
            map.put("holidayName", name);
            if (isHoliday.booleanValue()) {
                map.put("qyWorkType", 1);
            } else {
                map.put("qyWorkType", 0);
            }
        }
        return map;
    }

    public static List<Map<String, Object>> buildCalendar(int year, String weekend) {
        if (StringUtils.isEmpty((Object)weekend)) {
            weekend = "6,7";
        }
        ArrayList<Map<String, Object>> lst = new ArrayList<Map<String, Object>>();
        JSONObject jsonObject = PeriodUtil.getHoliday(year);
        for (int month = 1; month <= 12; ++month) {
            int days = PeriodUtil.getMonthDays(year, month);
            for (int day = 1; day <= days; ++day) {
                Date date = DateUtils.StrToDate((String)(year + "-" + month + "-" + day), (String)"yyyy-MM-dd");
                lst.add(PeriodUtil.getDay(date, weekend, jsonObject));
            }
        }
        return lst;
    }

    public static String padLeft(String origin, int length, char ch) {
        while (origin.length() < length) {
            origin = ch + origin;
        }
        return origin;
    }

    public static boolean isR(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static int getMonthDays(int year, int month) {
        switch (month) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                if (PeriodUtil.isR(year)) {
                    return 29;
                }
                return 28;
            }
        }
        return 31;
    }

    public static JSONObject getHoliday(int year) {
        try {
            String url = "http://timor.tech/api/holiday/year/" + year;
            String result = HttpUtil.doGet((String)url);
            JSONObject obj = JSONObject.parseObject((String)result);
            Integer code = obj.getInteger("code");
            if (null != code && 0 == code) {
                JSONObject holidays = obj.getJSONObject("holiday");
                return holidays;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

