/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.cache;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@EnableCaching
@RefreshScope
@Component
public class RedisConfig
extends CachingConfigurerSupport {
    private static Logger logger = Logger.getLogger(RedisConfig.class);
    @Value(value="${spring.redis.database}")
    private String datebase;
    @Value(value="${spring.redis.host}")
    private String host;
    @Value(value="${spring.redis.port}")
    private String port;
    @Value(value="${spring.redis.password}")
    private String password;
    @Value(value="${spring.redis.pool.max-active}")
    private String maxActive;
    @Value(value="${spring.redis.pool.max-wait}")
    private String maxWait;
    @Value(value="${spring.redis.pool.max-idle}")
    private String maxIdle;
    @Value(value="${spring.redis.pool.min-idle}")
    private String minIdle;
    @Value(value="${spring.redis.timeout}")
    private String timeOut;

    @Bean
    public JedisPoolConfig getRedisConfig() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxWaitMillis(Long.parseLong(this.maxWait));
        config.setMaxIdle(Integer.parseInt(this.maxIdle));
        config.setMinIdle(Integer.parseInt(this.minIdle));
        return config;
    }

    @Bean
    public JedisConnectionFactory getConnectionFactory() {
        JedisConnectionFactory factory = new JedisConnectionFactory();
        JedisPoolConfig config = this.getRedisConfig();
        factory.setDatabase(Integer.parseInt(this.datebase));
        factory.setHostName(this.host);
        factory.setPassword(this.password);
        factory.setPort(Integer.parseInt(this.port));
        factory.setTimeout(Integer.parseInt(this.timeOut));
        factory.setPoolConfig(config);
        logger.info((Object)"JedisConnectionFactory bean init success.");
        return factory;
    }

    @Bean
    @Primary
    public RedisTemplate redisTemplate() {
        JedisConnectionFactory jedisConnectionFactory = this.getConnectionFactory();
        StringRedisTemplate template = new StringRedisTemplate((RedisConnectionFactory)jedisConnectionFactory);
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper om = new ObjectMapper();
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        om.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        jackson2JsonRedisSerializer.setObjectMapper(om);
        template.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.afterPropertiesSet();
        return template;
    }

    @Bean
    public RedisTemplate redisTemplateString() {
        JedisConnectionFactory jedisConnectionFactory = this.getConnectionFactory();
        StringRedisTemplate template = new StringRedisTemplate((RedisConnectionFactory)jedisConnectionFactory);
        return template;
    }

    @Bean
    public KeyGenerator keyGenerator() {
        return new KeyGenerator(){

            public Object generate(Object target, Method method, Object ... params) {
                StringBuilder sb = new StringBuilder();
                sb.append(target.getClass().getName());
                sb.append(method.getName());
                for (Object obj : params) {
                    sb.append(obj.toString());
                }
                return sb.toString();
            }
        };
    }

    @Bean(name={"cacheManager"})
    public CacheManager CacheManager(RedisTemplate redisTemplate) {
        RedisCacheManager rcm = new RedisCacheManager((RedisOperations)redisTemplate);
        rcm.setDefaultExpiration(60L);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("test", 60L);
        rcm.setExpires(map);
        return rcm;
    }
}

