/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.log;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.log.AccessLogEntity;
import cc.lechun.framework.common.utils.log.SqlLogEntity;
import cc.lechun.framework.common.utils.web.CookieUtils;
import cc.lechun.framework.common.utils.web.IpUtil;
import java.net.URLDecoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerUtil {
    private static final Logger logger = LoggerFactory.getLogger(LoggerUtil.class);

    public static AccessLogEntity getAccessLog(HttpServletRequest request) {
        AccessLogEntity log = new AccessLogEntity();
        try {
            Cookie cookie;
            String api = request.getRequestURI();
            String referer = request.getHeader("referer");
            String url = request.getRequestURL().toString();
            String userAgent = request.getHeader("User-Agent");
            String params = JsonUtils.toJson(request.getParameterMap(), false);
            log.setIp(IpUtil.getCliectIp(request));
            log.setOperator("operator");
            log.setUserId("");
            log.setAction(api);
            String customerId = "";
            if (request != null && (cookie = CookieUtils.getCookie(request, "user")) != null) {
                customerId = URLDecoder.decode(cookie.getValue(), "utf-8");
            }
            log.setCustomerId(customerId);
            log.setMessage("\u63a5\u53e3\u76d1\u63a7");
            log.setReferer(referer);
            log.setBeginTime(System.currentTimeMillis());
            log.setUrl(url);
            log.setUserAgent(userAgent);
            log.setParams(params);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return log;
    }

    public static SqlLogEntity WriteSqlLog(String isTrans, String rw, String customerId, String service, long beginTime, long endTime, long runTimes, String sql, String db) {
        SqlLogEntity log = new SqlLogEntity();
        log.setRunTimes(runTimes);
        log.setBeginTime(beginTime);
        log.setTrans(isTrans);
        log.setRw(rw);
        log.setCustomerId(customerId);
        log.setDb(db);
        log.setEndTime(endTime);
        log.setService(service);
        log.setSqls(sql);
        return log;
    }
}

