package cc.lechun.framework.common.utils.serviceresult;

import com.github.pagehelper.Page;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import java.math.BigDecimal;
import java.util.*;

/**
 * Created by saiwengang on 2018/3/23.
 */
public class StatisticsResult {

    /*根据结果和参数 假如小计结果
     *resultList 待计算对象
     * paramList 小结计算的条件参数列表,暂时支持一个参数
     */
    public static Page<Map<String, Object>> statisticsByParam(int pageNum, int pageSize, List<Map<String, Object>> resultList , List<String> paramList, List<String> groupKeyList){
        Page<Map<String, Object>> returnList = new Page<Map<String, Object>>(pageNum, pageSize);
        List<Map<String, Object>> list =new ArrayList<>();
        if(paramList == null || paramList.isEmpty() ||  resultList == null || resultList.isEmpty()
                || groupKeyList== null || groupKeyList.isEmpty()){
        } else {
            list = statisticsByParamList(resultList , paramList,  groupKeyList);
            returnList.addAll(list);
        }
        Page<Map<String, Object>> subResults = new Page<Map<String, Object>>(pageNum, pageSize);
        // 2018.3.26 monkey 处理小计结果集，构造分页对象
        subResults.setTotal(returnList.size());
        subResults.setPageNum(pageNum);
        subResults.setPages(returnList.size() / pageSize + 1);
        int startNum = 1 + (pageNum - 1) * pageSize;
        subResults.setStartRow(startNum);
        int endNum = pageNum * pageSize > returnList.size() ? returnList.size() : pageNum * pageSize;
        subResults.setEndRow(endNum);
        for(int i = startNum; i <= endNum; i++) {
            subResults.add(returnList.get(i - 1));
        }
        return subResults;
    }
    /*根据结果和参数 假如小计结果
     *resultList 待计算对象
     * paramList 小结计算的条件参数列表,暂时支持一个参数
     */
    public static List<Map<String, Object>> statisticsByParamList(List<Map<String, Object>> resultList , List<String> paramList, List<String> groupKeyList){
        List<Map<String, Object>>  returnList = new ArrayList<>();

        if(paramList == null || paramList.isEmpty() ||  resultList == null || resultList.isEmpty()
                || groupKeyList== null || groupKeyList.isEmpty()){
            return null;
        } else {
            String groupKeyName = groupKeyList.get(0);
            Set<String> allGroupName = Sets.newHashSet();
            for (Map map : resultList){
                String key = (String) map.get(groupKeyName);
                allGroupName.add(key);
            }
            for (Iterator<String> it = allGroupName.iterator();it.hasNext();){
                String groupKey = it.next();
                if(groupKey == null){
                    groupKey = "";
                }
                Map<String,Object> resultMap = Maps.newHashMap();
                for (Map map : resultList){
                    boolean addFlag = false;
                    for (String statisticsField : paramList){
                        String groupValue = (String) map.get(groupKeyName) == null ?  "" : (String) map.get(groupKeyName);
                        if (groupValue.equals(groupKey)){
                            addFlag = true;
                            Object statisticsValue = map.get(statisticsField);
                            BigDecimal value = new BigDecimal("0");
                            if (statisticsValue !=null){
                                if (statisticsValue instanceof Long){
                                    value = new BigDecimal((Long) statisticsValue);
                                }
                                if (statisticsValue instanceof BigDecimal){
                                    value =(BigDecimal) statisticsValue;
                                }
                                if (statisticsValue instanceof Double){
                                    value = new BigDecimal((Double) statisticsValue);
                                }
                                if (statisticsValue instanceof Float){
                                    value = new BigDecimal((Float) statisticsValue);
                                }
                                if (statisticsValue instanceof String ){
                                    value = new BigDecimal((String) statisticsValue);
                                }
                            }
                            BigDecimal totalValue =  resultMap.get(statisticsField)==null?new BigDecimal("0"): ((BigDecimal) resultMap.get(statisticsField));
                            totalValue = totalValue.add(value);
                            resultMap.put(statisticsField, totalValue);
                        }
                    }
                    if (addFlag){
                        returnList.add(map);
                    }
                }
                resultMap.put(groupKeyName,"小计");
                returnList.add(resultMap);
            }
        }
        return returnList;
    }
}
