package cc.lechun.framework.common.utils.string;

import com.sun.org.apache.xpath.internal.operations.Bool;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by wangxs on 2017/12/6
 * Description: 字符串操作工具类
 */
public class StringUtils {

    public StringUtils() {
    }

    public static String clean(String str) {
        return str == null ? "" : str.trim();
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String deleteWhitespace(String str) {
        StringBuffer buffer = new StringBuffer();
        int sz = str.length();

        for (int i = 0; i < sz; ++i) {
            if (!Character.isWhitespace(str.charAt(i))) {
                buffer.append(str.charAt(i));
            }
        }

        return buffer.toString();
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (!Character.isWhitespace(str.charAt(i))) {
                    return false;
                }
            }
            return true;
        } else {
            return true;
        }
    }

    public static boolean isNotBlank(String str) {
        return !isBlank(str);
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    /**
     * 获取长度   汉字2  字母1
     * 由于Java是基于Unicode编码的，因此，一个汉字的长度为1，而不是2。
     */
    public static int getWordCount(String s) {
        int length = 0;
        for (int i = 0; i < s.length(); i++) {
            int ascii = Character.codePointAt(s, i);
            if (ascii >= 0 && ascii <= 255) {
                length++;
            } else {
                length += 2;
            }
        }
        return length;
    }

    public static boolean checkOpenID(String openId){
        if(StringUtils.isEmpty(openId)){
            return false;
        }
        String  s = "^[a-zA-Z0-9_\\-]{28}$";
        Pattern pattern = Pattern.compile(s);
        Matcher matcher = pattern.matcher(openId);
        return matcher.matches();

    }

    public static String rePlacePhone(String phone){
        if(StringUtils.isEmpty(phone)){
            return phone;
        }
        String p= phone.replaceAll("(\\d{3})\\d{4}(\\d{4})","$1****$2");
        return p;
    }

    public static Boolean isNaN(String str){
        try {
            Integer.parseInt(str);
            return true;
        } catch (NumberFormatException e) {
            return false;
        }
    }

    public static String unicode2String(String unicode) {
        StringBuffer string = new StringBuffer();
        String[] hex = unicode.split("\\\\u");
        for (int i = 1; i < hex.length; i++) {
            // 转换出每一个代码点
            int data = Integer.parseInt(hex[i], 16);
            // 追加成string
            string.append((char) data);
        }
        return string.toString();
    }
    public static Boolean checkPhone(String phone){
        String pattern = "^1([3-9][0-9])\\d{8}$";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(phone);
        return m.matches();
}
    public static Boolean checkEmail(String email){
        String pattern = "\\w[-\\w.+]*@([A-Za-z0-9][-A-Za-z0-9]+\\.)+[A-Za-z]{2,14}";

        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(email);
        return (m.matches());
    }
    public static Boolean checkIdcard(String idcard){
        String pattern = "\\d{17}[0-9Xx]|\\d{15}";

        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(idcard);
        return (m.matches());
    }
}
