/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.login;

import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.login.MallUserEntity;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.web.CookieUtils;
import cc.lechun.framework.common.utils.web.RequestDetail;
import cc.lechun.framework.common.vo.BaseJsonVo;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoginUtils {
    @Autowired
    private RedisCacheUtil redisCacheUtil;
    private static final Logger log = LoggerFactory.getLogger(LoginUtils.class);

    public Map<String, String> getUserMap() throws AuthorizeException {
        HttpServletRequest req = RequestDetail.getCurrentRequest();
        if (req == null) {
            log.info("\u8bf7\u6c42request \u4e3a\u7a7a");
            throw new AuthorizeException("\u7528\u6237\u672a\u767b\u9646");
        }
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a" + req.getRequestURI());
        String testAuthor = req.getParameter("testAuthor");
        if (StringUtils.isEmpty(testAuthor)) {
            testAuthor = req.getHeader("testAuthor");
        }
        log.info("testAuthor:" + testAuthor);
        if (this.checkTestAuthor(testAuthor).isSuccess()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userId", testAuthor.split("_")[0]);
            map.put("userName", "test");
            map.put("userNick", "test");
            return map;
        }
        String key = "JSESSIONID";
        String jsessionid = CookieUtils.getCookie(req, "JSESSIONID").getValue();
        log.info("jsessionid\uff1a" + jsessionid);
        if (StringUtils.isEmpty(jsessionid)) {
            throw new AuthorizeException("\u7528\u6237\u672a\u767b\u9646");
        }
        Object user = this.redisCacheUtil.get(key + jsessionid);
        if (user == null) {
            log.info("\u83b7\u53d6\u7528\u6237\u4e3a\u7a7a");
            throw new AuthorizeException("\u7528\u6237\u672a\u767b\u9646");
        }
        return (Map)user;
    }

    public MallUserEntity getUser() throws AuthorizeException {
        try {
            Map<String, String> map = this.getUserMap();
            return ObjectConvert.mapConvertToObject(map, MallUserEntity.class);
        }
        catch (Exception e) {
            throw new AuthorizeException("\u7528\u6237\u672a\u767b\u9646");
        }
    }

    public static void main(String[] args) {
        String path = "https://gatewaytest.lechun.cc/lechun-tools/app/getAppList?pageSize=20&pageNum=1&pageRouterUrl=%2Fdashboard";
        String[] paths = path.split("/");
        if (paths.length < 4) {
            System.out.println("\u9519\u8bef");
        }
        System.out.println(paths[3]);
    }

    public BaseJsonVo checkTestAuthor(String author) {
        HttpServletRequest req = RequestDetail.getCurrentRequest();
        if (req == null) {
            return BaseJsonVo.error("\u7528\u6237\u672a\u767b\u9646");
        }
        String path = req.getRequestURI().toLowerCase();
        if (StringUtils.isEmpty(path) || StringUtils.isEmpty(author)) {
            return BaseJsonVo.error("\u8ba4\u8bc1\u4e3a\u7a7a");
        }
        String[] paths = path.split("/");
        if (paths.length < 4) {
            return BaseJsonVo.error("\u8ba4\u8bc1\u9519\u8bef");
        }
        String sys = paths[3];
        String key = sys + "_" + author.split("_")[0];
        log.info("\u8ba4\u8bc1\u5b57\u7b26\u4e32key\uff1a" + key);
        Object value = this.redisCacheUtil.get(key);
        if (value != null) {
            log.info("\u8ba4\u8bc1\u5b57\u7b26\u4e32value\uff1a" + value.toString() + ",author:" + author);
            if (author.equals(value.toString())) {
                return BaseJsonVo.success("");
            }
        }
        return BaseJsonVo.error("\u8ba4\u8bc1\u9519\u8bef");
    }
}

