/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.vo;

import cc.lechun.framework.common.utils.SpringUtil;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.login.LoginUtils;
import cc.lechun.framework.common.utils.login.MallUserEntity;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseUser;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@RefreshScope
@Component
public class JedisUtils {
    protected static Logger logger = LoggerFactory.getLogger(JedisUtils.class);
    private static String redisKey = "JedisUtils-userId-";
    public static RedisCacheUtil<BaseUser> redisCacheUtil;

    @Autowired
    public void setRedisCacheUtil(RedisCacheUtil<BaseUser> redisCacheUtil) {
        JedisUtils.redisCacheUtil = redisCacheUtil;
    }

    public static BaseUser getBaseUser(HttpServletRequest request) {
        String id = request.getHeader("id");
        logger.info("=============0 \u7f13\u5b58\u83b7\u53d6request id:{}", (Object)id);
        BaseUser user = null;
        if (StringUtils.isNotBlank(id)) {
            user = JedisUtils.getBaseUser(id);
        }
        logger.info("=============1 \u7f13\u5b58\u83b7\u53d6user:{}", (Object)JSONObject.toJSONString((Object)user));
        return JedisUtils.getBaseUser(user);
    }

    public static BaseUser getBaseUser(String id) {
        BaseUser user = JedisUtils.getRedisBaseUser(id);
        return JedisUtils.getBaseUser(user);
    }

    private static BaseUser getBaseUser(BaseUser user) {
        if (null == user) {
            MallUserEntity v = null;
            try {
                v = SpringUtil.getBean(LoginUtils.class).getUser();
            }
            catch (AuthorizeException e) {
                logger.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            }
            user = new BaseUser();
            if (null != v) {
                user.setId(v.getUserId());
                user.setUserName(v.getUserName());
                user.setEmployeeName(v.getUserNick());
                redisCacheUtil.set(redisKey + user.getId(), user, 7200L);
                logger.info("=============2 Cookie\u83b7\u53d6user:{}", (Object)JSONObject.toJSONString((Object)user));
            } else {
                user.setId(null);
                user.setUserName("SYS-\u7cfb\u7edf");
                user.setEmployeeName("SYS-\u7cfb\u7edf");
            }
        }
        return user;
    }

    private static BaseUser getRedisBaseUser(String id) {
        Object baseUser;
        if (StringUtils.isNotBlank(id) && null != (baseUser = redisCacheUtil.get(redisKey + id))) {
            return (BaseUser)baseUser;
        }
        return null;
    }
}

