package cc.lechun.framework.common.enums.scrollpic;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Arrays;
import java.util.List;

/**
 * Created by wangxs on 2018/4/25
 * Description:图片类型 枚举
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ScrollPicTypeEnum {

    mainPageBanner(1, "首页banner"),
    mainPageGGW(3, "首页广告位"),
    mainPageKSRK(4, "首页快速入口"),
    productListPage(2, "商品列表页"),
    lexiangActiveListPage(5, "乐享活动列表"),
    mainPageKP(6, "首页开屏");

    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<ScrollPicTypeEnum> getList() {
        return Arrays.asList(ScrollPicTypeEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        ScrollPicTypeEnum[] ls = ScrollPicTypeEnum.values();
        for (ScrollPicTypeEnum rs : ls) {
            if (rs.getValue() == value) {
                return rs.getName();
            }
        }
        return "";
    }

    ScrollPicTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
