package cc.lechun.framework.common.utils.serviceresult;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtil {
	
	public static final String dateFormatter = "yyyy-MM-dd HH:mm:ss";

	public static final String date = "yyyy-MM-dd";

	/**
	 * 时间戳转换成java格式化时间字符串
	 * @param seconds
	 * @return
	 */
	public static String timestampToJavaDate(String seconds){
		
		String pattern = "(\\d+)";
		
        Pattern r = Pattern.compile(pattern);	

        Matcher m = r.matcher(seconds); 

        Long transSeconds = m.find()?Long.parseLong(m.group(0).substring(0, m.group(0).length()-3)):0L;
		
		SimpleDateFormat sdf = new SimpleDateFormat(dateFormatter);
		
		return sdf.format(new Date(transSeconds*1000L));
	}
	
	/**
	 * 按照指定日期格式解析字符串
	 * @param dateStr
	 * @param formatSr
	 * @return
	 * @throws ParseException
	 */
	public static Date getFormattedDate(String dateStr, String formatSr) throws ParseException{
		SimpleDateFormat sdf = new SimpleDateFormat(formatSr);
		return sdf.parse(dateStr);
	}
	
	/**
	 * 按照指定日期格式解析日期
	 * @param date
	 * @param formatStr
	 * @return
	 * @throws ParseException
	 */
	public static String getFormattedString(Date date, String formatStr) throws ParseException{
		SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
		return sdf.format(date);
	}	
	
	/**
	 * 按照指定的时间格式计算时间差值(秒)
	 * @param startDate
	 * @param endDate
	 * @param formatSr
	 * @return
	 */
	public static float getIntervalSeconds(String startDate, String endDate, String formatSr){
		SimpleDateFormat sdf = new SimpleDateFormat(formatSr);
		long inervalSeconds = 0L;
		try {
			inervalSeconds = sdf.parse(endDate).getTime()-sdf.parse(startDate).getTime();
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return Float.parseFloat(Long.toString(inervalSeconds/1000L));
	}
	
    /** 
     * 获得指定日期的前一天 
     *  
     * @param specifiedDate
     * @return 
     * @throws Exception 
     */  
    public static Date getSpecifiedDayBefore(Date specifiedDate) {//可以用new Date().toLocalString()传递参数  
        Calendar c = Calendar.getInstance();  
        c.setTime(specifiedDate);  
        int day = c.get(Calendar.DATE);  
        c.set(Calendar.DATE, day - 1);  
        return c.getTime();  
    }  
  
    /** 
     * 获得指定日期的后一天 
     *  
     * @param specifiedDate
     * @return 
     */  
    public static Date getSpecifiedDayAfter(Date specifiedDate) {  
        Calendar c = Calendar.getInstance();  
        c.setTime(specifiedDate);  
        int day = c.get(Calendar.DATE);  
        c.set(Calendar.DATE, day + 1);  
        return c.getTime();  
    }	
    
    /**
     * 获取前一天开始时间
     * @param nowDate
     * @return
     * @throws ParseException
     */
    public static String getYesterdayTimeStart(Date nowDate, String formatStr) throws ParseException{
    	Calendar cStart = Calendar.getInstance();
    	cStart.setTime(nowDate);
    	cStart.set(cStart.get(Calendar.YEAR), cStart.get(Calendar.MONTH), cStart.get(Calendar.DATE)-1, 0, 0, 0);
    	return getFormattedString(cStart.getTime(), formatStr);
    }
    
    /**
     * 获取前一天结束时间
     * @param nowDate
     * @return
     * @throws ParseException
     */
    public static String getYesterdayTimeEnd(Date nowDate, String formatStr) throws ParseException{
    	Calendar cEnd = Calendar.getInstance();
    	cEnd.setTime(nowDate);
    	cEnd.set(cEnd.get(Calendar.YEAR), cEnd.get(Calendar.MONTH), cEnd.get(Calendar.DATE)-1, 23, 59, 59);   	
    	return getFormattedString(cEnd.getTime(), formatStr);
    }
}
