package cc.lechun.framework.common.utils.date;

import org.quartz.CronExpression;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CronUtils {
    //main函数
    public static void main(String[] args) throws InterruptedException {

        String curTime = DateUtils.formatDate(new Date(), "yyyy-MM-dd HH:mm");
        Date dates=CronUtils.getCronTime("0 0/5 * * * ?",DateUtils.getAddDateBySecond(DateUtils.getDateFromString(curTime), -45));
        System.out.println(dates);
    }
    public static Date getCronTime(String cron){
        return getCronTime(cron,cc.lechun.framework.common.utils.date.DateUtils.getAddDateBySecond(new Date(),0));
    }
    public static Date getCronTime(String cron,Date initDate){
        CronExpression cronExpression;
        try {
            cronExpression = new CronExpression(cron);
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        // 转换 new Date 是为了给最近一次执行时间一个初始时间，这里给当前时间
        Date execTime = cronExpression.getTimeAfter(initDate);
        if(execTime==null){
            return null;
        }

        return execTime;

    }
    /**
     * 得到cron表达式对应的时间
     * @param cron 表达式
     * @param count 次数
     * @return
     */
    public static List<Date> getCronTime(String cron, Integer count,Date initDate){
        CronExpression cronExpression;
        try {
            cronExpression = new CronExpression(cron);
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        if(count==null){
            count=1;
        }
        if(count>20){
            count=20;
        }
        List<Date> result=new ArrayList<>();
        // 转换 new Date 是为了给最近一次执行时间一个初始时间，这里给当前时间
        Date exec=new Date();
        for(int i=0;i<count;i++){
            Date execTime = cronExpression.getTimeAfter(initDate);
            if(execTime==null){
                return result;
            }
            exec=execTime;
            result.add(execTime);
        }

        return result;

    }
    public static List<Date> getCronTime(String cron, Integer count){
        return getCronTime(cron,count,cc.lechun.framework.common.utils.date.DateUtils.getAddDateBySecond(new Date(),0));
    }
//    public static void main(String[] args) throws InterruptedException {
//        Date dates=getCronTime("0 0/30 * * * ?");
//        System.out.println(dates);
//    }
}
