package cc.lechun.framework.common.utils.login;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.web.CookieUtils;
import cc.lechun.framework.common.utils.web.RequestDetail;
import cc.lechun.framework.common.vo.BaseJsonVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.util.*;

@Component
public class LoginUtils {
    @Autowired
    private RedisCacheUtil redisCacheUtil;
    @Autowired
    private MemcachedService memcachedService;
    @Value("${app.id:#{NULL}}")
    private String appId;
    private static final Logger log = LoggerFactory.getLogger(LoginUtils.class);
    public Map<String,String> getUserMap() throws AuthorizeException {
        HttpServletRequest req = RequestDetail.getCurrentRequest();
        if(req==null){
            //log.info("请求request 为空");
            throw new AuthorizeException("用户未登陆");
        }
        //og.info("请求地址："+req.getRequestURL());
        String testAuthor=req.getParameter("testAuthor");
        if(StringUtils.isEmpty(testAuthor)){
            testAuthor=req.getHeader("testAuthor");
        }
        //log.info("testAuthor:"+testAuthor);
        BaseJsonVo jsonVo=checkTestAuthor(testAuthor);
        if(jsonVo.isSuccess()){
            Map<String,String>map =new HashMap<>();
            map.put("userId",testAuthor.split("_")[0]);
            map.put("userName","test");
            map.put("userNick","test");
            return map;
        }else{
            //log.info("checkAuthor return result:"+jsonVo.getMessage());
        }

        String key="JSESSIONID";
        Cookie cookie=CookieUtils.getCookie(req,"JSESSIONID");
        if(cookie==null){
            throw new AuthorizeException("用户未登陆");
        }
        String jsessionid=cookie.getValue();
        //log.info("jsessionid："+jsessionid);
        if(StringUtils.isEmpty(jsessionid)){
            throw new AuthorizeException("用户未登陆");
        }
        Object user = null;
        try {
            user = redisCacheUtil.get(key+jsessionid);
        } catch (Exception e){

        }
        if(user==null){
            //log.info("redis获取用户为空");
            try {
                user = memcachedService.get(key + jsessionid);
                //log.info("memcachedService获取用户[{}]结果：{}",key + jsessionid, JsonUtils.toJson(user,false));
            } catch (Exception e){

            }
            //log.info("获取用户为空");
            //throw new AuthorizeException("用户未登陆");
        }
        if(user == null) {
            //log.info("memcachedService获取用户为空");
            throw new AuthorizeException("用户未登陆");
        }
        return (Map<String,String>)user;
        ///throw new AuthorizeException("用户未登陆");
    }
    public Boolean isLogin(){
        try {
            Map<String,String> map=getUserMap();
            if(map!=null){
                return true;
            }
        } catch (AuthorizeException e) {

        }
        return false;
    }
    public MallUserEntity getLoginUser(){
        try {
            return getUser();
        } catch (AuthorizeException e) {

        }
        return null;
    }
    public String getLoginUserId(){
        try {
            return getUser().getUserId();
        } catch (AuthorizeException e) {

        }
        return null;
    }
    public MallUserEntity getUser() throws AuthorizeException {
        try {
            Map<String,String> map=getUserMap();
            return ObjectConvert.mapConvertToObject(map, MallUserEntity.class);
        }catch (Exception e){
            //log.error("getUser登录异常:",e);
            throw new AuthorizeException("用户未登陆");
        }
        ///throw new AuthorizeException("用户未登陆");
    }
    public static void main(String[] args) {
        String path="https://gatewaytest.lechun.cc/lechun-tools/app/getAppList?pageSize=20&pageNum=1&pageRouterUrl=%2Fdashboard";
        String[] paths=path.split("/");
        if(paths.length<4){
            System.out.println("错误");
        }
        System.out.println(paths[3]);
    }
    public   BaseJsonVo checkTestAuthor(String author){
        HttpServletRequest req = RequestDetail.getCurrentRequest();
        if(req==null){
            return BaseJsonVo.error("用户未登陆");
        }
        String path = req.getRequestURL().toString().toLowerCase();
        if (StringUtils.isEmpty(path) || StringUtils.isEmpty(author)) {
            return BaseJsonVo.error("认证为空");
        }
        log.info("请求路径："+path);

        String[] paths = path.split("/");
        if (paths.length < 4) {
            //return BaseJsonVo.error("认证错误");
        }else {
            appId = paths[3];
        }
        log.info("请求appID1："+appId);

        //log.info("认证路径："+appId);
        String sys=appId;
        String key=sys+"_"+author.split("_")[0];
        //log.info("认证字符串key："+key);
        Object value=redisCacheUtil.get(key.toLowerCase(Locale.ROOT));
        //log.info("认证字符串value："+value);
        if(value!=null) {
            //log.info("认证字符串value：" + value.toString()+",author:"+author);
            if (author.equals(value.toString())) {
                return BaseJsonVo.success("");
            }
        }else{
            String[] arr=sys.split("-");
            if(arr.length>1){
                sys=arr[1];
            }
            key=sys+"_"+author.split("_")[0];
            value=redisCacheUtil.get(key.toLowerCase(Locale.ROOT));
            if(value!=null) {
                //log.info("认证字符串value1：" + value.toString()+",author:"+author);
                if (author.equals(value.toString())) {
                    return BaseJsonVo.success("");
                }
            }
        }

        return BaseJsonVo.error("认证错误");
    }
}
