package cc.lechun.framework.common.utils.sql;

import cc.lechun.framework.common.utils.string.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
/** *//**
* 单句Sql解析器，单句即非嵌套的意思
* @author 赵朝峰（）
*
* @since 2013-6-10
* @version 1.00
*/
public abstract class BaseSingleSqlParser{
/** *//**
　* 原始Sql语句
　*/
protected String originalSql;
/** *//**
　* Sql语句片段
　*/
protected List<SqlSegment> segments;
/** *//**
　* 构造函数，传入原始Sql语句，进行劈分。
　* @param originalSql
　*/
public BaseSingleSqlParser(String originalSql){
    this.originalSql=originalSql;
    segments=new ArrayList<SqlSegment>();
    initializeSegments();
    splitSql2Segment();
}
/** *//**
　* 初始化segments，强制子类实现
　*
　*/
protected abstract void initializeSegments();
/** *//**
　* 将originalSql劈分成一个个片段
　*
　*/
protected void splitSql2Segment() {
    for(SqlSegment sqlSegment:segments)
    {
        sqlSegment.parse(originalSql);
    }
}
/** *//**
　* 得到解析完毕的Sql语句
　* @return
　*/
public String getParsedSql() {
    
    //测试输出各个片段的信息
    /*
    for(SqlSegment sqlSegment:segments)
    {
        String start=sqlSegment.getStart();
        String end=sqlSegment.getEnd();
        System.out.println(start);
        System.out.println(end);
    }
    */
    
    StringBuffer sb=new StringBuffer();
    for(SqlSegment sqlSegment:segments)
    {
        sb.append(sqlSegment.getParsedSqlSegment());
    }
    String retval=sb.toString().replaceAll("@+", "\n");
    return retval;
}
public String replaceSql(String where) {
    if(!where.trim().toLowerCase(Locale.ROOT).startsWith("and ")&&!where.trim().toLowerCase(Locale.ROOT).startsWith("or ")){
        where="and ("+where+")";
    }
    //测试输出各个片段的信息
    SqlSegment sqlSegment=segments.stream().filter(c->c.getStart().startsWith("where")).findFirst().orElse(null);
    if(sqlSegment!=null){
        sqlSegment.setBody(sqlSegment.getBody()+" "+where);
    }else{
        if(where.trim().toLowerCase(Locale.ROOT).startsWith("and ")){
            where=where.replaceFirst("and ","");
        }
        if(where.trim().toLowerCase(Locale.ROOT).startsWith("or ")){
            where=where.replaceFirst("or ","");
        }
        sqlSegment=segments.stream().filter(c->c.getStart().startsWith("from")).findFirst().orElse(null);
        if(sqlSegment!=null){
            int i=segments.indexOf(sqlSegment);
            SqlSegment s=new SqlSegment(" ","");
            s.setStart("where");
            s.setBody(where);
            s.setEnd("");
            segments.add(i+1, s);
        }
    }


    StringBuffer sb=new StringBuffer();
    for(SqlSegment sqlSegment1:segments)
    {
        sb.append(sqlSegment1.getStart()+" "+sqlSegment1.getBody()+" ");
    }
    String retval=sb.toString().replaceAll("@+", "");
    return retval;
}

/** *//**
 　* 得到解析完毕的Sql语句
 　* @return
 　*/
public List<String> getParsedSqlList() {


    List<String> sb=new ArrayList<String>();
    for(SqlSegment sqlSegment:segments)
    {
        String retval=sqlSegment.getParsedSqlSegment().replaceAll("@+", "");
        sb.add(retval);
    }

    return sb;
}
/** *//**
* 得到解析的Sql片段
* @return
*/
public List<SqlSegment> RetrunSqlSegments()
{
    int SegmentLength=this.segments.size();
    if(SegmentLength!=0)
    {
      List<SqlSegment> result=this.segments;
      return result;
    }
    else
    {
        //throw new Exception();
        return null;
    }
}
}