package cc.lechun.framework.common.utils.sql;

import cc.lechun.framework.common.utils.string.StringUtils;

import java.util.List;

/** *//**
* 单句Sql解析器制造工厂
* @author 赵朝峰
*
* @since 2013-6-10
* @version 1.00
*/
public class SqlParserUtil{
    /** *//**
    　* 方法的主要入口
    　* @param sql:要解析的sql语句
    　* @return 返回解析结果
    　*/
    public String getParsedSql(String sql){
        sql=sql.trim();
        sql=sql.toLowerCase();
        sql=sql.replaceAll("\\s{1,}", " ");
        sql=""+sql+" ENDOFSQL";
        //System.out.println(sql);
        return SingleSqlParserFactory.generateParser(sql).getParsedSql();
    }
    public List<String> getParsedSqlList(String sql){
        sql=sql.trim();
        sql=sql.toLowerCase();
        sql=sql.replaceAll("\\s{1,}", " ");
        sql=""+sql+" ENDOFSQL";
        //System.out.println(sql);
        return SingleSqlParserFactory.generateParser(sql).getParsedSqlList();
    }
    /** *//**
    　* SQL语句解析的接口
    　* @param sql:要解析的sql语句
    　* @return 返回解析结果
    　*/
    public List<SqlSegment> getParsedSqlSegmentList(String sql)
    {
        sql=sql.trim();
        sql=sql.toLowerCase();
        sql=sql.replaceAll("\\s{1,}", " ");
        sql=""+sql+" ENDOFSQL";
        //System.out.println(sql);
        return SingleSqlParserFactory.generateParser(sql).RetrunSqlSegments();
    }
    public String replaceSql(String sql,String where){
        if(StringUtils.isEmpty(where)){
            return sql;
        }
        sql=sql.trim();
        sql=sql.toLowerCase();
        sql=sql.replaceAll("\\s{1,}", " ");
        sql=""+sql+" ENDOFSQL";


        where=where.trim();
        where=where.toLowerCase();
        //where=where.replaceAll("\\s{1,}", " ");

        System.out.println(where);
        return SingleSqlParserFactory.generateParser(sql).replaceSql(where);

    }
}