package cc.lechun.framework.common.utils.task;

import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.http.HttpUtil;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Set;

@Component
public class NoticeBiUpdateDataUtil {

    private String key="noticeBiUpdateData";
    @Autowired
    protected RedisCacheUtil<String> redisCacheUtil;

    /**
     * 添加到任务池，每分钟执行一次
     * @param noticeUrl
     * @return
     */
    public BaseJsonVo noticeForTask(String noticeUrl){
        //这里放入缓存，定时消费，set为不重复集合，每分钟消费一次
        Boolean b=redisCacheUtil.setCacheSet(key,noticeUrl);
        if(b){
            return BaseJsonVo.success("添加队列成功");
        }else{
            return BaseJsonVo.error("添加队列失败");
        }
    }

    /**
     * 立即执行
     * @param noticeUrl
     * @return
     */
    public BaseJsonVo noticeForImmediately(String noticeUrl){
        if(StringUtils.isNotEmpty(noticeUrl)){
            String s=HttpUtil.doGet(noticeUrl);
            if(s==null){
                return BaseJsonVo.error("执行失败");
            }
            return BaseJsonVo.success(s);
        }
        return BaseJsonVo.error("参数错误");
    }
    public BaseJsonVo execTask(){
        Set<String> set=redisCacheUtil.getCacheSet(key);
        if(set!=null&&set.size()>0){
            for (String str : set) {
                String s=HttpUtil.doGet(str);
                if(s==null){
                    return BaseJsonVo.error("执行失败");
                }
                redisCacheUtil.remove(str);
                return BaseJsonVo.success(s);
            }
        }
        return BaseJsonVo.error("没有任务");
    }
}
