package cc.lechun.framework.common.utils.math;

import cc.lechun.framework.common.utils.date.DateUtils;
import com.github.pagehelper.util.StringUtil;

import java.util.*;

public class CompareUtil {
    private static void main(String[] args) {
        boolean b =Compare(12, "12","13","between");
        System.out.println("jiekou:"+b);
    }
    public static boolean Compare(Object mapValue,String filterValue,String filterValue1,String filterType){
        if(StringUtil.isEmpty(filterType)){
            return false;
        }
        filterType=filterType.toUpperCase(Locale.ROOT).trim();
        try {
            String value0=null;
            String value=null;
            String value1=null;
            if (mapValue instanceof Date) {
                if(StringUtil.isNotEmpty(filterValue)){
                    value=String.valueOf(DateUtils.StrToDate(filterValue).getTime());
                }
                if(StringUtil.isNotEmpty(filterValue1)){
                    value1=String.valueOf(DateUtils.StrToDate(filterValue1).getTime());
                }
                if(mapValue!=null){
                    value0=String.valueOf(((Date) mapValue).getTime());
                }
                return Compare(value0, value,value1, filterType);
            }else {
                if(mapValue!=null){
                    value0=mapValue.toString();
                }
                return Compare( value0, filterValue,filterValue1, filterType);

            }

        }catch (NumberFormatException e){

        }

        return false;
    }
    private static <T> boolean Compare(String mapValue, String filterValue,String filterValue1, String filterType) {
        try {
            if (filterType.equals("EQUALS")) {
                if(filterValue==null){
                    return false;
                }
                return filterValue.equals(mapValue);
            }
            if(filterType.equals("NOT_EQUALS")){
                if(filterValue==null){
                    return false;
                }
                return !filterValue.equals(mapValue);
            }
            if (">".equals(filterType)) {
                if(filterValue==null||mapValue==null){
                    return false;
                }
                return Double.parseDouble( mapValue) > Double.parseDouble(filterValue);
            }
            if ("<".equals(filterType)) {
                if(filterValue==null||mapValue==null){
                    return false;
                }
                return Double.parseDouble( mapValue) < Double.parseDouble( filterValue);
            }
            if ("=".equals(filterType)) {
                if(filterValue==null||mapValue==null){
                    return false;
                }
                return Double.parseDouble(mapValue) == Double.parseDouble( filterValue);
            }
            if ("<=".equals(filterType)) {
                if(filterValue==null||mapValue==null){
                    return false;
                }
                return Double.parseDouble(mapValue) <= Double.parseDouble( filterValue);
            }
            if (">=".equals(filterType)) {
                if(filterValue==null||mapValue==null){
                    return false;
                }
                return Double.parseDouble(mapValue) >= Double.parseDouble( filterValue);
            }
            if ("!=".equals(filterType)) {
                if(filterValue==null||mapValue==null){
                    return false;
                }
                return Double.parseDouble(mapValue) != Double.parseDouble( filterValue);
            }
            if("LIKE".equals(filterType)){
                if(filterValue==null||mapValue==null){
                    return false;
                }
                return mapValue.indexOf(filterValue)>-1;
            }
            if("NOT_LIKE".equals(filterType)){
                if(filterValue==null||mapValue==null){
                    return false;
                }
                return mapValue.indexOf(filterValue)<0;
            }
            if("IN".equals(filterType)){
                if(filterValue==null||mapValue==null){
                    return false;
                }
                String[] filterValues=filterValue.split(",");
                return Arrays.stream(filterValues).filter(c->c.equals(mapValue)).count()>0;
            }
            if("NOT_IN".equals(filterType)){
                if(filterValue==null||mapValue==null){
                    return false;
                }
                String[] filterValues=filterValue.split(",");
                return Arrays.stream(filterValues).filter(c->c.equals(mapValue)).count()<=0;
            }
            if("BETWEEN".equals(filterType)){
                if(mapValue==null){
                    return false;
                }
                if(StringUtil.isEmpty(filterValue)&&StringUtil.isEmpty(filterValue1)){
                    return Double.parseDouble(mapValue)<=Double.parseDouble(filterValue1);
                }
                if(StringUtil.isEmpty(filterValue1)&&StringUtil.isNotEmpty(filterValue)){
                    return Double.parseDouble(mapValue)>=Double.parseDouble(filterValue);
                }
                return Double.parseDouble(mapValue)>=Double.parseDouble(filterValue)&&Double.parseDouble(mapValue)<=Double.parseDouble(filterValue1);
            }
            //not between
            if("NOT_BETWEEN".equals(filterType)){
                if(mapValue==null){
                    return false;
                }
                if(StringUtil.isEmpty(filterValue)&&StringUtil.isNotEmpty(filterValue1)){
                    return Double.parseDouble(mapValue)>Double.parseDouble(filterValue1);
                }
                if(StringUtil.isEmpty(filterValue1)&&StringUtil.isNotEmpty(filterValue)){
                    return Double.parseDouble(mapValue)<Double.parseDouble(filterValue);
                }
                return Double.parseDouble(mapValue)<Double.parseDouble(filterValue)&&Double.parseDouble(mapValue)>Double.parseDouble(filterValue1);
            }
            if("NULL".equals(filterType)){
                return StringUtil.isEmpty(mapValue);
            }
            if("NOT_NULL".equals(filterType)){
                return StringUtil.isNotEmpty(mapValue);
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return false;
    }
    public static List<Map<String,Object>> getCompareString(String dataType){
        List<Map<String,Object>> filterList=new ArrayList<>();
        Map<String,Object> filterMap;
        filterMap=new HashMap<>();
        filterMap.put("code","NULL");
        filterMap.put("name","为空");
        filterMap.put("inputNum",0);
        filterList.add(filterMap);
        filterMap=new HashMap<>();
        filterMap.put("code","NOT_NULL");
        filterMap.put("name","不为空");
        filterMap.put("inputNum",0);
        filterList.add(filterMap);

        if(dataType.equals("String")){
            filterMap=new HashMap<>();
            filterMap.put("code","EQUALS");
            filterMap.put("name","等于");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);
            filterMap=new HashMap<>();
            filterMap.put("code","NOT_EQUALS");
            filterMap.put("name","不等于");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);

            filterMap=new HashMap<>();
            filterMap.put("code","LIKE");
            filterMap.put("name","包含(like)");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);
            filterMap=new HashMap<>();
            filterMap.put("code","NOT_LIKE");
            filterMap.put("name","不包含(not like)");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);
            filterMap=new HashMap<>();
            filterMap.put("code","IN");
            filterMap.put("name","包含(IN,多个逗号分隔)");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);
            filterMap=new HashMap<>();
            filterMap.put("code","NOT IN");
            filterMap.put("name","不包含(NOT IN,多个逗号分隔)");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);
        }else {
            filterMap=new HashMap<>();
            filterMap.put("code",">");
            filterMap.put("name","大于");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);
            filterMap=new HashMap<>();
            filterMap.put("code",">=");
            filterMap.put("name","大于等于");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);
            filterMap=new HashMap<>();
            filterMap.put("code","<");
            filterMap.put("name","小于");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);
            filterMap=new HashMap<>();
            filterMap.put("code","<=");
            filterMap.put("name","小于等于");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);
            filterMap=new HashMap<>();
            filterMap.put("code","=");
            filterMap.put("name","等于");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);
            filterMap=new HashMap<>();
            filterMap.put("code","!=");
            filterMap.put("name","!不等于");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);

            filterMap=new HashMap<>();
            filterMap.put("code","BETWEEN");
            filterMap.put("name","在两者之间");
            filterMap.put("inputNum",2);
            filterList.add(filterMap);
            filterMap=new HashMap<>();
            filterMap.put("code","NOT_BETWEEN");
            filterMap.put("name","不在两者之间");
            filterMap.put("inputNum",2);
            filterList.add(filterMap);
        }
        return filterList;
    }
    public static String getSqlOperator(Integer operator){
        switch (operator){
            case 1:
                return "IS NULL";
            case 2:
                return "IS NOT NULL";
            case 3:
                return "=";
            case 4:
                return "!=";
            case 5:
                return "LIKE";
            case 6:
                return "NOT LIKE";
            case 7:
                return "IN";
            case 8:
                return "NOT IN";
            case 9:
                return ">";
            case 10:
                return ">=";
            case 11:
                return "<";
            case 12:
                return "<=";
            case 13:
                return "BETWEEN";
            case 14:
                return "NOT BETWEEN";
            case 1000:
                return "ASC";
            case 1001:
                return "DESC";
        }
        return "=";
    }
    public static List<Map<String,Object>> getSqlCompareString(String dataType){
        List<Map<String,Object>> filterList=new ArrayList<>();
        Map<String,Object> filterMap;
        filterMap=new HashMap<>();
        filterMap.put("code",(1));
        filterMap.put("name","为空");
        filterMap.put("inputNum",0);
        filterList.add(filterMap);
        filterMap=new HashMap<>();
        filterMap.put("code",(2));
        filterMap.put("name","不为空");
        filterMap.put("inputNum",0);
        filterList.add(filterMap);

        if(dataType.equals("String")||dataType.contains("char")||dataType.contains("text")){
            filterMap=new HashMap<>();
            filterMap.put("code",(3));
            filterMap.put("name","等于");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);
            filterMap=new HashMap<>();
            filterMap.put("code",(4));
            filterMap.put("name","不等于");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);

            filterMap=new HashMap<>();
            filterMap.put("code",(5));
            filterMap.put("name","包含(like)");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);
            filterMap=new HashMap<>();
            filterMap.put("code",(6));
            filterMap.put("name","不包含(not like)");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);
            filterMap=new HashMap<>();
            filterMap.put("code",(7));
            filterMap.put("name","包含(IN,多个逗号分隔)");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);
            filterMap=new HashMap<>();
            filterMap.put("code",(8));
            filterMap.put("name","不包含(NOT IN,多个逗号分隔)");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);
        }else {
            filterMap=new HashMap<>();
            filterMap.put("code",(9));
            filterMap.put("name","大于");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);
            filterMap=new HashMap<>();
            filterMap.put("code",(10));
            filterMap.put("name","大于等于");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);
            filterMap=new HashMap<>();
            filterMap.put("code",(11));
            filterMap.put("name","小于");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);
            filterMap=new HashMap<>();
            filterMap.put("code",(12));
            filterMap.put("name","小于等于");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);
            filterMap=new HashMap<>();
            filterMap.put("code",(3));
            filterMap.put("name","等于");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);
            filterMap=new HashMap<>();
            filterMap.put("code",(4));
            filterMap.put("name","!不等于");
            filterMap.put("inputNum",1);
            filterList.add(filterMap);

            filterMap=new HashMap<>();
            filterMap.put("code",(13));
            filterMap.put("name","在两者之间");
            filterMap.put("inputNum",2);
            filterList.add(filterMap);
            filterMap=new HashMap<>();
            filterMap.put("code",(14));
            filterMap.put("name","不在两者之间");
            filterMap.put("inputNum",2);
            filterList.add(filterMap);

        }
        return filterList;
    }
    public static List<Map<String,Object>> getSqlOrderByString() {
        List<Map<String, Object>> filterList = new ArrayList<>();
        Map<String, Object> filterMap;
        filterMap = new HashMap<>();
        filterMap.put("code", (1000));
        filterMap.put("name", "升序");
        filterMap.put("inputNum", 0);
        filterList.add(filterMap);
        filterMap = new HashMap<>();
        filterMap.put("code", (1001));
        filterMap.put("name", "降序");
        filterMap.put("inputNum", 0);
        filterList.add(filterMap);
        return filterList;
    }
}
