/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.math;

import java.math.BigDecimal;

public class MathUtils {
    private static final Integer DEF_DIV_SCALE = 2;

    public static BigDecimal mulBigDecimal(Number value1, Number value2) {
        BigDecimal b1 = new BigDecimal(Double.toString(value1.doubleValue()));
        BigDecimal b2 = new BigDecimal(Double.toString(value2.doubleValue()));
        return b1.multiply(b2);
    }

    public static Double mul(Number value1, Number value2) {
        return MathUtils.mulBigDecimal(value1, value2).doubleValue();
    }

    public static Double add(Number value1, Number value2) {
        BigDecimal b1 = new BigDecimal(Double.toString(value1.doubleValue()));
        BigDecimal b2 = new BigDecimal(Double.toString(value2.doubleValue()));
        return b1.add(b2).doubleValue();
    }

    public static double sub(Number value1, Number value2) {
        BigDecimal b1 = new BigDecimal(Double.toString(value1.doubleValue()));
        BigDecimal b2 = new BigDecimal(Double.toString(value2.doubleValue()));
        return b1.subtract(b2).doubleValue();
    }

    public static Double div(Double dividend, Double divisor) {
        return MathUtils.div(dividend, divisor, DEF_DIV_SCALE);
    }

    public static Double div(Double dividend, Double divisor, Integer scale) {
        return MathUtils.divBigDecimal(dividend, divisor, scale).doubleValue();
    }

    public static BigDecimal divBigDecimal(Double dividend, Double divisor, Integer scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(dividend));
        BigDecimal b2 = new BigDecimal(Double.toString(divisor));
        return b1.divide(b2, (int)scale, 4);
    }

    public static BigDecimal divBigDecimal(Number dividend, Number divisor, Integer scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(dividend.doubleValue()));
        BigDecimal b2 = new BigDecimal(Double.toString(divisor.doubleValue()));
        return b1.divide(b2, (int)scale, 4);
    }
}

