/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.sql;

import cc.lechun.framework.common.utils.sql.BaseSingleSqlParser;
import cc.lechun.framework.common.utils.sql.DeleteSqlParser;
import cc.lechun.framework.common.utils.sql.InsertSelectSqlParser;
import cc.lechun.framework.common.utils.sql.InsertSqlParser;
import cc.lechun.framework.common.utils.sql.SelectSqlParser;
import cc.lechun.framework.common.utils.sql.UpdateSqlParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SingleSqlParserFactory {
    public static BaseSingleSqlParser generateParser(String sql) {
        if (SingleSqlParserFactory.contains(sql, "(insert into)(.+)(select)(.+)(from)(.+)")) {
            return new InsertSelectSqlParser(sql);
        }
        if (SingleSqlParserFactory.contains(sql, "(select)(.+)(from)(.+)")) {
            return new SelectSqlParser(sql);
        }
        if (SingleSqlParserFactory.contains(sql, "(delete from)(.+)")) {
            return new DeleteSqlParser(sql);
        }
        if (SingleSqlParserFactory.contains(sql, "(update)(.+)(set)(.+)")) {
            return new UpdateSqlParser(sql);
        }
        if (SingleSqlParserFactory.contains(sql, "(insert into)(.+)(values)(.+)")) {
            return new InsertSqlParser(sql);
        }
        return new InsertSqlParser(sql);
    }

    private static boolean contains(String sql, String regExp) {
        Pattern pattern = Pattern.compile(regExp, 2);
        Matcher matcher = pattern.matcher(sql);
        return matcher.find();
    }
}

