/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.gateway.config.shiro;

import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.gateway.config.shiro.MallUserEntity;
import java.util.Map;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AuthBaseService {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public MallUserEntity getUser() throws AuthorizeException {
        this.log.info("getUser.start");
        Subject subject = SecurityUtils.getSubject();
        this.log.info("getUser.getSubject is null ? :{}", (Object)(subject == null ? 1 : 0));
        this.log.info("getUser.getSubject.getPrincipal() is null ? :{}", (Object)(subject.getPrincipal() == null ? 1 : 0));
        if (null != subject && null != subject.getPrincipal()) {
            MallUserEntity user = this.convertUserEntity(subject);
            this.log.info("\u8054\u5408\u8ba4\u8bc1\u6210\u529f\uff1a\u53d6\u5230user" + user.getUserName());
            return user;
        }
        throw new AuthorizeException("\u7528\u6237\u672a\u767b\u9646");
    }

    protected MallUserEntity convertUserEntity(Subject subject) {
        try {
            if (null != subject && null != subject.getPrincipal()) {
                Map map = (Map)subject.getPrincipal();
                MallUserEntity user = (MallUserEntity)ObjectConvert.mapConvertToObject((Map)map, MallUserEntity.class);
                return user;
            }
        }
        catch (Exception e) {
            this.log.error("convertUserEntity error:{}", (Throwable)e);
        }
        return null;
    }
}

