/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.gateway.filter;

import cc.lechun.framework.common.enums.common.EnvironmentEnum;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.log.AccessLogDBConfig;
import cc.lechun.framework.common.utils.log.AccessLogEntity;
import cc.lechun.framework.common.utils.log.LoggerUtil;
import cc.lechun.framework.common.utils.login.LoginUtils;
import cc.lechun.framework.common.utils.login.MallUserEntity;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.web.IpUtil;
import cc.lechun.framework.common.utils.web.ResponseUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.gateway.apiInvoke.BaseServiceInvoke;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.aliyun.log.producer.Producer;
import com.aliyun.openservices.aliyun.log.producer.errors.ProducerException;
import com.aliyun.openservices.log.common.LogItem;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=99)
public class RightControlFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(RightControlFilter.class);
    @Value(value="${whiteList}")
    private String writeList;
    @Value(value="${ipWriteList}")
    private String ipWriteList;
    @Value(value="${lechun.environment}")
    private String environment;
    @Autowired
    private BaseServiceInvoke baseServiceInvoke;
    @Value(value="${ipBlackList}")
    private String ipBlackList;
    @Value(value="${aliyun.sls.project}")
    private String project;
    @Value(value="${aliyun.sls.logStore}")
    private String logStore;
    @Autowired
    private RedisCacheUtil redisCacheUtil;
    @Autowired
    private AccessLogDBConfig accessLogDBConfig;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private LoginUtils loginUtils;
    @Autowired
    private Producer producer;

    public void init(FilterConfig var1) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain Chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String path = req.getRequestURI().toLowerCase();
        logger.info("doFilter,path:" + path);
        BaseJsonVo jsonVo = this.loginUserId(req, path);
        Object pageRouterUrl = req.getParameter("pageRouterUrl");
        if (StringUtils.isEmpty((String)pageRouterUrl) && (pageRouterUrl = req.getHeader("Pagerouterurl")) == null) {
            pageRouterUrl = "";
        }
        AccessLogEntity accessLog = LoggerUtil.getAccessLog((HttpServletRequest)req);
        if (jsonVo.isSuccess()) {
            accessLog.setUserId(((MallUserEntity)jsonVo.getValue()).getUserId());
        }
        long endTime = System.currentTimeMillis();
        accessLog.setEndTime(endTime);
        accessLog.setRunTimes(endTime - accessLog.getBeginTime());
        accessLog.setUrl((String)pageRouterUrl);
        if (!"".equals(pageRouterUrl)) {
            this.accessLogDBConfig.writeAccessDBLog(accessLog);
        }
        if (StringUtils.isNotEmpty((String)accessLog.getAction()) && !accessLog.getAction().contains("/health") && !accessLog.getAction().contains("/saveAccessLog")) {
            try {
                LogItem logItem = new LogItem();
                logItem.PushBack("\u5458\u5de5ID", accessLog.getUserId());
                logItem.PushBack("\u5458\u5de5\u59d3\u540d", jsonVo.isSuccess() ? ((MallUserEntity)jsonVo.getValue()).getUserNick() : "");
                logItem.PushBack("IP", accessLog.getIp());
                logItem.PushBack("\u7cfb\u7edf", accessLog.getAction() == null ? "" : accessLog.getAction().split("/")[1]);
                logItem.PushBack("\u63a5\u53e3", accessLog.getAction());
                logItem.PushBack("\u53c2\u6570", accessLog.getParams());
                logItem.PushBack("\u8017\u65f6", String.valueOf(accessLog.getRunTimes()));
                logItem.PushBack("\u9875\u9762", (String)pageRouterUrl);
                this.producer.send(this.project, this.logStore, logItem);
            }
            catch (ProducerException | InterruptedException logItem) {
                // empty catch block
            }
        }
        String[] urlArr = ((String)pageRouterUrl).split("/");
        pageRouterUrl = "";
        for (String url : urlArr) {
            Pattern pattern;
            boolean b;
            if (url == "" || (b = (pattern = Pattern.compile("[0-9]*")).matcher(url).matches())) continue;
            pageRouterUrl = (String)pageRouterUrl + "/" + url;
        }
        String testAuthor = req.getParameter("testAuthor");
        if (StringUtils.isEmpty((String)testAuthor)) {
            testAuthor = req.getHeader("testAuthor");
        }
        logger.info("\u8fdb\u5165filter\uff1a" + path + ",testAuthor\uff1a" + testAuthor);
        Integer control = this.isControl(path, (String)pageRouterUrl);
        if (control == 1 || control == 2) {
            if (this.isIpBlackList(req)) {
                logger.info("\u9ed1\u540d\u5355\u62e6\u622a\uff0c\u91cd\u5b9a\u5411\u5230\u65e0\u6743\u9650\u9875\u9762" + path);
                ResponseUtils.corsConfigFilter((HttpServletRequest)req, (HttpServletResponse)res);
                res.getWriter().write(JSON.toJSONString((Object)new BaseJsonVo(403, "\u65e0\u6743\u9650\uff01")));
                return;
            }
            if (this.isIpWriteList(req)) {
                logger.info("ip\u767d\u540d\u5355\u653e\u884c" + path);
                Chain.doFilter(request, response);
                return;
            }
            if (this.isWriteList(path)) {
                logger.info("\u767d\u540d\u5355\u653e\u884c" + path);
                Chain.doFilter(request, response);
                return;
            }
            if (this.isTestAuthor(path, testAuthor)) {
                logger.info("\u6d4b\u8bd5\u653e\u884c" + path);
                Chain.doFilter(request, response);
                return;
            }
            if (!jsonVo.isSuccess()) {
                logger.info("\u6ca1\u6709\u767b\u5f55\u91cd\u5b9a\u5411\u5230\u767b\u5f55" + path);
                ResponseUtils.corsConfigFilter((HttpServletRequest)req, (HttpServletResponse)res);
                res.getWriter().write(JSON.toJSONString((Object)new BaseJsonVo(20112, "\u5ba2\u6237\u7aef\u672a\u767b\u5f55\uff01")));
                return;
            }
            if (control == 2) {
                logger.info("\u6743\u9650\u5224\u65ad\uff1auser:" + String.valueOf(jsonVo.getValue()) + "_pageUrl:" + (String)pageRouterUrl);
                String userId = ((MallUserEntity)jsonVo.getValue()).getUserId();
                try {
                    jsonVo = this.baseServiceInvoke.getUserRoleRight(userId, (String)pageRouterUrl, Integer.valueOf(1));
                }
                catch (Exception e) {
                    jsonVo = BaseJsonVo.error((String)"\u6743\u9650\u670d\u52a1\u8c03\u4e0d\u901a\u4e86");
                }
                if (!jsonVo.isSuccess()) {
                    logger.info("\u6ca1\u6709\u6743\u9650\uff0c\u62e6\u622a\uff0c\u91cd\u5b9a\u5411\u5230\u65e0\u6743\u9650\u9875\u9762");
                    ResponseUtils.corsConfigFilter((HttpServletRequest)req, (HttpServletResponse)res);
                    res.getWriter().write(JSON.toJSONString((Object)new BaseJsonVo(403, "\u65e0\u6743\u9650\uff01")));
                    return;
                }
                String referer = req.getHeader("Referer");
                logger.info("\u5f97\u5230referer\uff1a" + referer);
                if (referer == null || !referer.contains("lechun.cc")) {
                    ResponseUtils.corsConfigFilter((HttpServletRequest)req, (HttpServletResponse)res);
                    res.getWriter().write(JSON.toJSONString((Object)new BaseJsonVo(403, "\u65e0\u6743\u9650\uff01")));
                    return;
                }
                logger.info("\u6240\u6709\u89c4\u5219\u901a\u8fc7\uff0c\u653e\u884c" + path);
            }
        } else {
            logger.info("\u4e0d\u62e6\u622a\u653e\u884c" + path);
        }
        Chain.doFilter(request, response);
    }

    private Integer isControl(String path, String pageRouterUrl) {
        String curSys;
        String[] curArr = path.split("/");
        String string = curSys = curArr.length > 1 ? curArr[1] : curArr[0];
        if (pageRouterUrl.startsWith("/csms")) {
            curSys = "lechun-csms";
        }
        if (pageRouterUrl.startsWith("/admin")) {
            curSys = "lechun-ams";
        }
        if (pageRouterUrl.startsWith("/oa")) {
            curSys = "lechun-oa";
        }
        if (pageRouterUrl.startsWith("/scrm")) {
            curSys = "lechun-cms";
        }
        if (pageRouterUrl.endsWith("dashboard") || pageRouterUrl.equals("/oa/formplayground")) {
            return 0;
        }
        logger.info("curSys:" + curSys + "\uff0cpageRouterUrl:" + pageRouterUrl);
        List lst = this.getEnableSystemList(1);
        for (String p : lst) {
            if (!curSys.toLowerCase().equals(p.toLowerCase())) continue;
            return 1;
        }
        lst = this.getEnableSystemList(2);
        for (String p : lst) {
            if (!curSys.toLowerCase().equals(p.toLowerCase())) continue;
            return 2;
        }
        return 0;
    }

    private List<String> getEnableSystemList(int type) {
        BaseJsonVo jsonVo;
        String key = "gateway.enableSystemList" + type;
        Object obj = this.redisCacheUtil.get(key);
        if (obj != null) {
            return (List)obj;
        }
        try {
            jsonVo = this.baseServiceInvoke.getEnableSystemList(Integer.valueOf(type));
        }
        catch (Exception e) {
            jsonVo = BaseJsonVo.error((String)"\u6743\u9650\u670d\u52a1\u8c03\u4e0d\u901a\u4e86");
        }
        if (jsonVo.isSuccess()) {
            List list = (List)jsonVo.getValue();
            this.redisCacheUtil.set(key, (Object)list, Long.valueOf(300L));
            return list;
        }
        return new ArrayList<String>();
    }

    private boolean isWriteList(String path) {
        for (String p : this.writeList.split("\\n")) {
            if (!path.contains(p.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private boolean isIpWriteList(HttpServletRequest req) {
        if (StringUtils.isNotEmpty((String)this.ipWriteList)) {
            String ip = IpUtil.getCliectIp((HttpServletRequest)req);
            String[] arr = this.ipWriteList.split("\\n");
            logger.info("ipWriteList:" + ip);
            for (String p : arr) {
                if (!p.contains(ip)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isTestAuthor(String path, String testAuthor) {
        if (StringUtils.isEmpty((String)testAuthor)) {
            return false;
        }
        BaseJsonVo jsonVo = this.loginUtils.checkTestAuthor(testAuthor);
        logger.info("isTestAuthor:" + jsonVo.isSuccess() + "\uff0cmessage\uff1a" + jsonVo.getMessage());
        return jsonVo.isSuccess();
    }

    private boolean isServiceInvoke(HttpServletRequest req) {
        return true;
    }

    private boolean isIpBlackList(HttpServletRequest req) {
        if (StringUtils.isNotEmpty((String)this.ipBlackList)) {
            String[] arr;
            String ip = IpUtil.getCliectIp((HttpServletRequest)req);
            for (String p : arr = this.ipBlackList.split("\\n")) {
                if (!p.contains(ip)) continue;
                return true;
            }
        }
        return false;
    }

    private BaseJsonVo<MallUserEntity> loginUserId(HttpServletRequest req, String path) {
        try {
            if (path.contains("/lechun-mall/")) {
                return BaseJsonVo.error((String)"mall\u6ca1\u6709\u767b\u5f55\u5440");
            }
            MallUserEntity user = this.loginUtils.getUser();
            return BaseJsonVo.success((Object)user);
        }
        catch (Exception e) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u767b\u5f55\u5440");
        }
    }

    private boolean isProduction() {
        return EnvironmentEnum.PRODUCT.getValue().equals(this.environment);
    }
}

