/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.gateway.service.impl;

import cc.lechun.framework.gateway.service.PermissionService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;

@Service(value="permissionService")
public class PermissionServiceImpl
implements PermissionService {
    private AntPathMatcher antPathMatcher = new AntPathMatcher();

    public boolean hasPermission(HttpServletRequest request, Authentication authentication) {
        Object principal = authentication.getPrincipal();
        String requestUrl = request.getRequestURI();
        List grantedAuthorityList = (List)authentication.getAuthorities();
        boolean hasPermission = false;
        if (principal != null) {
            if (CollectionUtils.isEmpty((Collection)grantedAuthorityList)) {
                return hasPermission;
            }
            for (SimpleGrantedAuthority authority : grantedAuthorityList) {
                if (!this.antPathMatcher.match(authority.getAuthority(), requestUrl)) continue;
                hasPermission = true;
                break;
            }
        }
        return true;
    }
}

