/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.ask;

import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.iservice.ask.MallAskInterface;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/mallAsk"})
public class MallAskController {
    private static final Logger log = LoggerFactory.getLogger(MallAskController.class);
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private MallAskInterface mallAskInterface;

    @ResponseBody
    @RequestMapping(value={"/getNextQuestion"})
    public BaseJsonVo getNextQuestion(HttpServletRequest request, HttpServletResponse response, String bindCode) {
        BaseJsonVo baseJsonVo = null;
        try {
            CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
            if (customerDetailVo != null) {
                baseJsonVo = this.mallAskInterface.getNextQuestion(customerDetailVo.getCustomerId(), bindCode);
            }
        }
        catch (AuthorizeException e) {
            e.printStackTrace();
            log.error("+++++cc.lechun.mall.controller.ask.MallAskController.getNextQuestion++++Exception={}", (Object)e.getMessage());
        }
        return baseJsonVo;
    }

    @ResponseBody
    @RequestMapping(value={"/commitAnswer"})
    public BaseJsonVo commitAnswer(HttpServletRequest request, HttpServletResponse response, String bindCode, String questionId, String answerId) {
        BaseJsonVo baseJsonVo = null;
        try {
            CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
            if (customerDetailVo != null) {
                baseJsonVo = this.mallAskInterface.commitAnswer(customerDetailVo, questionId, answerId, bindCode);
            }
        }
        catch (AuthorizeException e) {
            e.printStackTrace();
        }
        return baseJsonVo;
    }
}

