/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.cashticket;

import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.iservice.cashticket.CashticketBatchInterface;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.iservice.cashticket.CashticketInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/cashTicket"})
public class CashTicketController {
    @Autowired
    private CashticketCustomerInterface cashticketCustomerInterface;
    @Autowired
    private CashticketInterface cashticketInterface;
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private MallTradeInterface mallTradeInterface;
    @Autowired
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    private CashticketBatchInterface cashticketBatchInterface;
    @Autowired
    private DictionaryInterface dictionaryService;

    @RequestMapping(value={"/getCashticketList"})
    @ResponseBody
    public BaseJsonVo getCashticketList(HttpServletRequest request, HttpServletResponse response, Integer type) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        if (type == null || type == 0) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7c7b\u578b");
        }
        if (type == 1) {
            return BaseJsonVo.success((Object)this.cashticketCustomerInterface.getValidCashticketList(customerDetailVo.getPlatformGroupId().intValue(), customerDetailVo.getCustomerId()));
        }
        if (type == 2) {
            return BaseJsonVo.success((Object)this.cashticketCustomerInterface.getInvalidCashticketList(customerDetailVo.getPlatformGroupId().intValue(), customerDetailVo.getCustomerId()));
        }
        if (type == 3) {
            return BaseJsonVo.success((Object)this.cashticketCustomerInterface.getUseCashticketList(customerDetailVo.getPlatformGroupId().intValue(), customerDetailVo.getCustomerId()));
        }
        return BaseJsonVo.paramError((String)"\u65e0\u6548\u7c7b\u578b");
    }

    @RequestMapping(value={"/convertTicketNo"})
    @ResponseBody
    public BaseJsonVo convertTicketNo(HttpServletRequest request, HttpServletResponse response, String ticketNo) throws AuthorizeException {
        if (StringUtils.isEmpty((String)ticketNo.trim())) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u5151\u6362\u7801");
        }
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.cashticketInterface.convertTicketNo(customerDetailVo.getCustomerId(), customerDetailVo.getPlatformId().intValue(), ticketNo.trim());
    }

    @RequestMapping(value={"/convertTicketNo4Order"})
    @ResponseBody
    public BaseJsonVo convertTicketNo4Order(HttpServletRequest request, HttpServletResponse response, String ticketNo, String cacheId, Integer orderSource, String bindCode) throws AuthorizeException {
        if (StringUtils.isEmpty((String)ticketNo.trim())) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u5151\u6362\u7801");
        }
        if (orderSource == null) {
            return BaseJsonVo.paramError((String)"\u53c2\u6570\u9519\u8bef");
        }
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        BaseJsonVo vo = this.cashticketInterface.convertTicketNo(customerDetailVo.getCustomerId(), customerDetailVo.getPlatformId().intValue(), ticketNo.trim());
        if (vo.isSuccess()) {
            MallMainOrderVo mallMainOrderVo = this.mallTradeInterface.getMainMainOrderVo(customerDetailVo.getCustomerId(), customerDetailVo.getPlatformId().intValue(), orderSource.intValue(), cacheId, bindCode);
            if (mallMainOrderVo.isBaseSuccess()) {
                List ls = this.cashticketCustomerInterface.getEnabledCashticketList(customerDetailVo.getPlatformGroupId().intValue(), 0, customerDetailVo.getCustomerId(), mallMainOrderVo.getMallOrderVos());
                return BaseJsonVo.success((Object)ls);
            }
            return BaseJsonVo.error((String)mallMainOrderVo.getBaseErrMsg());
        }
        return vo;
    }

    @RequestMapping(value={"/activeCashTicketByBindCode"})
    @ResponseBody
    public BaseJsonVo activeCashTicketByBindCode(String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.activeCashticketInterface.sendTicket4Base(customerDetailVo.getCustomerId(), bindCode, "", customerDetailVo.getPlatformId(), true);
    }

    @RequestMapping(value={"/sendCashTicketByBindCode"})
    @ResponseBody
    public BaseJsonVo sendCashTicketByBindCode() throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        String bindCode = "";
        DictionaryEntity dic = this.dictionaryService.getDictionary(customerDetailVo.getPlatformGroupId().intValue(), 50, "1");
        if (dic == null || !StringUtils.isNotEmpty((String)dic.getDictionaryName())) {
            return BaseJsonVo.error((String)"\u672a\u914d\u7f6e\u6b64\u4f18\u60e0\u5238");
        }
        bindCode = dic.getDictionaryName();
        this.activeCashticketInterface.sendTicket4BaseAsynchronous(customerDetailVo.getCustomerId(), bindCode, "", customerDetailVo.getPlatformId(), true);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/getFontPageActiveCashticket"})
    @ResponseBody
    public BaseJsonVo getFontPageActiveCashticket() throws AuthorizeException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        if (customerDetailVo == null) {
            map.put("status", 0);
            map.put("msg", "\u672a\u767b\u5f55\u65e0\u6cd5\u9886\u53d6");
            map.put("data", null);
            return BaseJsonVo.success(map);
        }
        String bindCode = "";
        DictionaryEntity dic = this.dictionaryService.getDictionary(customerDetailVo.getPlatformGroupId().intValue(), 50, "1");
        if (dic == null || !StringUtils.isNotEmpty((String)dic.getDictionaryName())) {
            map.put("status", 0);
            map.put("msg", "\u672a\u914d\u7f6e\u6b64\u4f18\u60e0\u5238");
            map.put("data", null);
            return BaseJsonVo.success(map);
        }
        bindCode = dic.getDictionaryName();
        List ticketList = this.activeCashticketInterface.getBindCodeActiveCashticketList(bindCode);
        ArrayList batchEntityList = new ArrayList();
        ticketList.forEach(activeCashticketEntity -> {
            Boolean hasTicket = this.cashticketCustomerInterface.getCustomerHasTicket(customerDetailVo.getCustomerId(), activeCashticketEntity.getTicketBatchId());
            if (!hasTicket.booleanValue()) {
                CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchInterface.getCashticketBatch(activeCashticketEntity.getTicketBatchId());
                batchEntityList.add(cashticketBatchEntity);
            }
        });
        if (batchEntityList.size() == 0) {
            map.put("status", 0);
            map.put("msg", "\u7528\u6237\u5df2\u9886\u53d6");
            map.put("data", null);
        } else {
            map.put("status", 1);
            map.put("msg", "");
            ArrayList list = new ArrayList();
            batchEntityList.forEach(batch -> {
                HashMap<String, Object> mapData = new HashMap<String, Object>();
                mapData.put("discountMode", batch.getDiscountMode());
                mapData.put("discountAmount", batch.getDiscountAmount());
                mapData.put("ticketAmount", batch.getAmount());
                mapData.put("ticketBatchName", batch.getTicketBatchName());
                mapData.put("remark", batch.getRemark());
                if (batch.getPeriodType() == 1) {
                    mapData.put("times", DateUtils.formatDate((Date)batch.getBeginTime(), (String)"yyyy.MM.dd") + "-" + DateUtils.formatDate((Date)batch.getEndTime(), (String)"yyyy.MM.dd"));
                } else if (batch.getPeriodType() == 2) {
                    mapData.put("times", DateUtils.formatDate((Date)DateUtils.now(), (String)"yyyy.MM.dd") + "-" + DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)batch.getDays()), (String)"yyyy.MM.dd"));
                }
                list.add(mapData);
            });
            map.put("data", list);
            map.put("bind", bindCode);
        }
        return BaseJsonVo.success(map);
    }
}

