/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.controller.luckydraw;

import cc.lechun.active.entity.luckydraw.ActiveLuckyDrawEntity;
import cc.lechun.active.iservice.luckydraw.ActiveLuckyDrawInterface;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"luckydraw"})
public class ActiveLuckyDrawController {
    @Autowired
    ActiveLuckyDrawInterface luckyDrawInterface;
    @Autowired
    CustomerLoginService customerLoginService;

    @CrossOrigin(origins={"*"}, maxAge=3600L)
    @RequestMapping(value={"findCustomersWhoDrawedYesterday"})
    public BaseJsonVo findCustomersWhoDrawedYesterday(String bindCode) throws AuthorizeException {
        BaseJsonVo whoDrawed = this.luckyDrawInterface.findCustomersWhoDrawedYesterday(bindCode);
        if (!whoDrawed.isSuccess()) {
            return BaseJsonVo.success(new ArrayList());
        }
        return BaseJsonVo.success((Object)whoDrawed.getValue());
    }

    @RequestMapping(value={"getBestPrize"})
    public BaseJsonVo getBestPrize(String bindCode) throws AuthorizeException {
        BaseJsonVo bestPrize = this.luckyDrawInterface.getBestPrize(bindCode);
        if (!bestPrize.isSuccess()) {
            return BaseJsonVo.success(null);
        }
        return BaseJsonVo.success((Object)bestPrize.getValue());
    }

    @RequestMapping(value={"hasTakePart"})
    public BaseJsonVo hasTakePart(String bindCode) throws Exception {
        HashMap resultMap = new HashMap();
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        BaseJsonVo isPartIn = this.luckyDrawInterface.canParticipate(customerDetailVo, bindCode);
        if (!isPartIn.isSuccess()) {
            return BaseJsonVo.success((String)isPartIn.getError_msg(), (Object)isPartIn.getValue());
        }
        return BaseJsonVo.success((Object)"\u6210\u529f");
    }

    @RequestMapping(value={"takePart"})
    public BaseJsonVo takePart(String bindCode, String areaId) throws Exception {
        HashMap resultMap = new HashMap();
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        if (customerDetailVo == null || StringUtils.isEmpty((String)customerDetailVo.getCustomerId())) {
            return BaseJsonVo.success((String)"\u5931\u8d25", (Object)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
        }
        BaseJsonVo isPartIn = this.luckyDrawInterface.canParticipate(customerDetailVo, bindCode);
        if (!isPartIn.isSuccess()) {
            return BaseJsonVo.success((Object)isPartIn.getError_msg());
        }
        BaseJsonVo drawResult = this.luckyDrawInterface.draw(customerDetailVo, areaId, bindCode);
        if (!drawResult.isSuccess()) {
            return BaseJsonVo.success((String)"\u6210\u529f", (Object)drawResult.getError_msg());
        }
        return BaseJsonVo.success((Object)drawResult.getValue());
    }

    @RequestMapping(value={"prizeList"})
    public BaseJsonVo prizeList(String bindCode) {
        HashMap resultMap = new HashMap();
        BaseJsonVo sr = this.luckyDrawInterface.luckyDrawListByBindCode(bindCode);
        if (sr.isSuccess()) {
            List entities = (List)sr.getValue();
            if (entities != null && entities.size() > 0) {
                ActiveLuckyDrawEntity entity = (ActiveLuckyDrawEntity)entities.get(0);
                BaseJsonVo sr2 = this.luckyDrawInterface.luckyDrawPrizeList(entity.getId());
                if (sr2.isSuccess()) {
                    List entities2 = (List)sr2.getValue();
                    if (entities2 != null && entities2.size() > 0) {
                        return BaseJsonVo.success((Object)entities2);
                    }
                    return BaseJsonVo.paramError((String)"\u62bd\u5956\u5956\u54c1\u4e0d\u5b58\u5728");
                }
                return BaseJsonVo.paramError((String)sr2.getError_msg());
            }
            return BaseJsonVo.paramError((String)"\u62bd\u5956\u5956\u54c1\u4e0d\u5b58\u5728");
        }
        return BaseJsonVo.paramError((String)sr.getError_msg());
    }
}

