/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.controller.reserve;

import cc.lechun.active.iservice.fit.FitInterface;
import cc.lechun.active.iservice.reserve.ReserveInterface;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/reserve"})
public class ReserveController {
    @Autowired
    private ReserveInterface reserveService;
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private FitInterface fitInterface;

    @RequestMapping(value={"reserve"})
    public BaseJsonVo reserve(@RequestParam(value="aliasId") String aliasId, @RequestParam(value="type") String type) throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        return this.reserveService.reserve(customer.getCustomerId(), aliasId, type);
    }

    @RequestMapping(value={"reserveActive"})
    public BaseJsonVo reserveActive(String aliasId, String type, String inviteId) throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        return this.reserveService.reserve(customer.getCustomerId(), customer.getNickName(), aliasId, type, inviteId, customer.getPlatformId());
    }

    @RequestMapping(value={"testreserveActive"})
    public BaseJsonVo testreserveActive(@RequestParam(value="aliasId") String aliasId, @RequestParam(value="type") String type, @RequestParam(value="inviteId") String inviteId) throws AuthorizeException {
        return this.reserveService.reserve("10003251633019271048434", "\u987e\u54c8", aliasId, type, inviteId, Integer.valueOf(1));
    }

    @RequestMapping(value={"getReserve"})
    public BaseJsonVo getReserve(String aliasId, String inviteId) throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        return this.reserveService.getReserve(customer.getCustomerId(), aliasId, customer.getOpenId(), customer.getPlatformId(), inviteId);
    }

    @RequestMapping(value={"testgetReserve"})
    public BaseJsonVo testgetReserve(String aliasId, String inviteId) throws AuthorizeException {
        return this.reserveService.getReserve("10003269505280292656164", aliasId, "oggJ0w6CerL9Bs82W2eqgHQRXB0A", Integer.valueOf(1), inviteId);
    }

    @RequestMapping(value={"testautoPrizeActive"})
    public BaseJsonVo testautoPrizeActive(String aliasId, String inviteId) throws AuthorizeException {
        this.fitInterface.autoPrizeActive("3324221527260157135", "10003269505280292656164", Integer.valueOf(1));
        return null;
    }

    @RequestMapping(value={"getReserveCount"})
    public BaseJsonVo getReserveCount(String alias) {
        return this.reserveService.getActiveReserve(alias);
    }
}

