/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.api;

import cc.lechun.common.enums.weixin.MessageTypeEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.weixin.WeiXinKeywordEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import cc.lechun.mallapi.api.CustomerMessageApi;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerMessageApiService
implements CustomerMessageApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private WeiXinKeywordInterface weiXinKeywordService;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private MessageInterface messageService;

    public BaseJsonVo<Boolean> sendCustomerMessage(String customerId, int platformId, Integer keyworldId) {
        WeiXinKeywordEntity weiXinKeywordEntity = this.weiXinKeywordService.getWeiXinKeywordById(keyworldId.intValue());
        if (weiXinKeywordEntity == null) {
            return BaseJsonVo.error((String)"\u5173\u952e\u5b57\u4e0d\u5b58\u5728!");
        }
        if (weiXinKeywordEntity.getContent().contains("nickName") || weiXinKeywordEntity.getTitle().contains("nickName")) {
            HashMap<String, String> map = new HashMap<String, String>();
            CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(customerId, platformId);
            if (customerDetailVo != null) {
                map.put("nickName", StringUtils.isNotEmpty((String)customerDetailVo.getNickName()) ? customerDetailVo.getNickName() : "\u4e50\u7eaf\u7684\u4f19\u4f34");
                return this.messageService.sendWechatMessage(MessageTypeEnum.CUSTOMZICE_MESSAGE, weiXinKeywordEntity.getId(), customerId, Integer.valueOf(platformId), map);
            }
        }
        return BaseJsonVo.error((String)"\u53d1\u9001\u5931\u8d25");
    }
}

