/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.balance;

import cc.lechun.balance.dto.BalanceChangeDTO;
import cc.lechun.balance.dto.StorageCardDTO;
import cc.lechun.balance.dto.UserBalanceDetailDTO;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"balance"})
public class BalanceController {
    private static final Logger log = LoggerFactory.getLogger(BalanceController.class);
    @Autowired
    private AccountBalanceInterface balanceService;
    @Autowired
    private CustomerLoginService customerLoginService;

    @RequestMapping(value={"storageCards"})
    public BaseJsonVo<List<StorageCardDTO>> storageCards() {
        return this.balanceService.findStorageCards();
    }

    @RequestMapping(value={"giftCharge"})
    public BaseJsonVo giftCharge(String cardNo) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        BaseJsonVo change = this.balanceService.cardCharge(customerDetailVo.getCustomerId(), cardNo);
        if (change.isSuccess()) {
            return BaseJsonVo.success((Object)((BalanceChangeDTO)change.getValue()).getTotalBalanceChange());
        }
        return BaseJsonVo.error((String)change.getError());
    }

    @RequestMapping(value={"records"})
    public BaseJsonVo<UserBalanceDetailDTO> balanceRecords() throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.balanceService.getBalanceDetail(customerDetailVo.getCustomerId());
    }
}

