/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.controller.collage;

import cc.lechun.active.iservice.collage.CollageInterface;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/collage"})
public class CollageController {
    @Autowired
    private CollageInterface collageService;
    @Autowired
    private CustomerLoginService customerLoginService;

    @RequestMapping(value={"/getCollageList"})
    public BaseJsonVo getCollageList(int platFormId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return BaseJsonVo.success((Object)this.collageService.getCollageList(customerDetailVo.getPlatformId().intValue()));
    }

    @RequestMapping(value={"/getCollageProductList"})
    BaseJsonVo getCollageProductList(String bindCode, String inviteId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        BaseJsonVo baseJsonVo = this.collageService.getCollageProductList(bindCode, customerDetailVo.getPlatformGroupId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("prodcutList", baseJsonVo.getValue());
        if (StringUtils.isNotEmpty((String)inviteId)) {
            map.put("prodcutList", baseJsonVo.getValue());
            map.put("collageList", this.collageService.getCollageList(inviteId, customerDetailVo));
        } else {
            map.put("collageList", "");
        }
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"/saveCollage"})
    public BaseJsonVo saveCollage(String bindCode, String inviteId, String items) throws AuthorizeException, UnsupportedEncodingException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.collageService.saveCollage(bindCode, inviteId, items, customerDetailVo.getCustomerId());
    }

    @RequestMapping(value={"/getCollageRecordList"})
    public BaseJsonVo getCollageRecordList(String bindCode, String inviteId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        BaseJsonVo baseJsonVo = this.collageService.getCollageList(inviteId, customerDetailVo);
        Map resultMap = (Map)baseJsonVo.getValue();
        resultMap.put("nickName", customerDetailVo.getNickName());
        return baseJsonVo;
    }

    @RequestMapping(value={"/clearCollageRecord"})
    public BaseJsonVo clearCollageRecord(String collageDatailId, Integer type) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.collageService.clearCollageRecord(collageDatailId, customerDetailVo.getCustomerId(), customerDetailVo.getPlatformId(), customerDetailVo.getNickName(), type);
    }

    @RequestMapping(value={"/checkCanJoinCollage"})
    public BaseJsonVo checkCanJoinCollage(String inviteId, String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.collageService.checkCanJoinCollage(inviteId, customerDetailVo.getCustomerId(), bindCode);
    }

    @RequestMapping(value={"/getCollageBillByInviteId"})
    public BaseJsonVo getCollageBillByInviteId(String inviteId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.collageService.getCollageBillList(inviteId, customerDetailVo);
    }

    @RequestMapping(value={"/getCollageBillByOrder"})
    public BaseJsonVo getCollageBillByOrder(String orderNo) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.collageService.getCollageBillListByOrder(orderNo, customerDetailVo);
    }

    @RequestMapping(value={"/setCollageBalance"})
    public BaseJsonVo setCollageBalance(String inviteId, String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.collageService.setCollageBalance(inviteId, bindCode);
    }

    @RequestMapping(value={"/unlockCollage"})
    public BaseJsonVo unlockCollage(String inviteId, String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.collageService.unlockCollage(customerDetailVo.getCustomerId(), inviteId, bindCode);
    }
}

