/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.api;

import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mallapi.api.CustomerInfoApi;
import cc.lechun.mallapi.dto.CustomerInfoDTO;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerInfoAPiService
implements CustomerInfoApi {
    @Autowired
    CustomerInterface customerInterface;

    public BaseJsonVo<CustomerInfoDTO> getCustomerInfoByID(String customerId) {
        if (StringUtils.isEmpty((String)customerId)) {
            return BaseJsonVo.error((String)"customerId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CustomerEntity customer = this.customerInterface.getCustomer(customerId);
        if (customer == null) {
            return BaseJsonVo.error((String)"\u4e0d\u5b58\u5728\u7684\u7528\u6237");
        }
        CustomerInfoDTO customerInfoDTO = this.CustomerEntity2CustomerInfoDTO(customer);
        if (customerInfoDTO == null) {
            return BaseJsonVo.error((String)"\u5b9e\u4f53\u8f6c\u6362\u5931\u8d25");
        }
        return BaseJsonVo.success((Object)customerInfoDTO);
    }

    public BaseJsonVo<CustomerInfoDTO> getCustomerInfoByToken(String token) {
        if (StringUtils.isEmpty((String)token)) {
            return BaseJsonVo.error((String)"token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CustomerEntity customer = this.customerInterface.getCustomerBySign(token);
        if (customer == null) {
            return BaseJsonVo.error((String)"\u4e0d\u5b58\u5728\u7684\u7528\u6237");
        }
        CustomerInfoDTO customerInfoDTO = this.CustomerEntity2CustomerInfoDTO(customer);
        if (customerInfoDTO == null) {
            return BaseJsonVo.error((String)"\u5b9e\u4f53\u8f6c\u6362\u5931\u8d25");
        }
        return BaseJsonVo.success((Object)customerInfoDTO);
    }

    public BaseJsonVo<CustomerInfoDTO> getCustomerInfoByOpenID(String openid) {
        if (StringUtils.isEmpty((String)openid)) {
            return BaseJsonVo.error((String)"openid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CustomerEntity param = new CustomerEntity();
        param.setChannelCustomerId(openid);
        CustomerEntity customer = this.customerInterface.getCustomerByOpenId(openid);
        if (customer == null) {
            return BaseJsonVo.error((String)"\u4e0d\u5b58\u5728\u7684\u7528\u6237");
        }
        CustomerInfoDTO customerInfoDTO = this.CustomerEntity2CustomerInfoDTO(customer);
        if (customerInfoDTO == null) {
            return BaseJsonVo.error((String)"\u5b9e\u4f53\u8f6c\u6362\u5931\u8d25");
        }
        return BaseJsonVo.success((Object)customerInfoDTO);
    }

    private CustomerInfoDTO CustomerEntity2CustomerInfoDTO(CustomerEntity customerEntity) {
        CustomerInfoDTO customerInfoDTO = new CustomerInfoDTO();
        if (customerEntity != null) {
            Method[] methods;
            for (Method entityGetMethod : methods = CustomerEntity.class.getMethods()) {
                if (!entityGetMethod.getName().startsWith("get")) continue;
                String setMethod = "set" + entityGetMethod.getName().substring(3);
                try {
                    Method dtoSetMethod = CustomerInfoDTO.class.getMethod(setMethod, new Class[0]);
                    dtoSetMethod.invoke((Object)customerInfoDTO, entityGetMethod.invoke((Object)customerEntity, new Object[0]));
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        return customerInfoDTO;
    }
}

