/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.weixin;

import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.common.vo.weixin.MessageListenerResultVo;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.messagePush.CustomMessageInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.mall.iservice.weixin.WeiXinMessageInterface;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.UUID;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import weixin.popular.bean.message.EventMessage;
import weixin.popular.bean.xmlmessage.XMLMessage;
import weixin.popular.support.ExpireKey;
import weixin.popular.support.expirekey.DefaultExpireKey;
import weixin.popular.util.JsUtil;
import weixin.popular.util.SignatureUtil;
import weixin.popular.util.XMLConverUtil;

@Controller
@RequestMapping(value={"/weixinapi"})
public class WeixinController {
    private static final Logger log = LoggerFactory.getLogger(WeixinController.class);
    private static final Logger weixinMessage = LoggerFactory.getLogger((String)"weixinMessageListener");
    @Autowired
    private WeiXinBaseInterface weiXinBaseInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private WeiXinMessageInterface weiXinMessageInterface;
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private CustomMessageInterface customMessageInterface;
    private static ExpireKey expireKey = new DefaultExpireKey();

    @RequestMapping(value={"/index/{platformId}"})
    public void index(@PathVariable(value="platformId") int platformId, HttpServletRequest request, HttpServletResponse response) {
        ServletOutputStream outputStream = null;
        long startTime = System.currentTimeMillis();
        try {
            ServletInputStream inputStream = request.getInputStream();
            outputStream = response.getOutputStream();
            boolean isGet = request.getMethod().toLowerCase().equals("get");
            if (isGet) {
                String echostr = request.getParameter("echostr");
                this.outputStreamWrite((OutputStream)outputStream, echostr);
                return;
            }
            String signature = request.getParameter("signature");
            String timestamp = request.getParameter("timestamp");
            String nonce = request.getParameter("nonce");
            String echostr = request.getParameter("echostr");
            if (echostr != null) {
                this.outputStreamWrite((OutputStream)outputStream, echostr);
                return;
            }
            if (!signature.equals(SignatureUtil.generateEventMessageSignature((String)this.weiXinBaseInterface.getAccessTokenByPlatformId(Integer.valueOf(platformId)).getToken(), (String)timestamp, (String)nonce))) {
                log.error("\u8bf7\u6c42\u7b7e\u540d\u9a8c\u8bc1\u4e0d\u901a\u8fc7" + this.weiXinBaseInterface.getAccessTokenByPlatformId(Integer.valueOf(platformId)).getToken() + ",timestamp=" + timestamp + ",nonce=" + nonce);
                return;
            }
            if (inputStream != null) {
                EventMessage eventMessage = (EventMessage)XMLConverUtil.convertToObject(EventMessage.class, (InputStream)inputStream);
                String key = eventMessage.getFromUserName() + "__" + eventMessage.getToUserName() + "__" + eventMessage.getMsgId() + "__" + eventMessage.getCreateTime();
                if (expireKey.exists(key)) {
                    log.warn("\u91cd\u590d\u4e8b\u4ef6\u901a\u77e5" + key);
                    return;
                }
                expireKey.add(key);
                XMLMessage xmlMessage = this.weiXinMessageInterface.receiveMessage(eventMessage, platformId);
                if (xmlMessage != null) {
                    xmlMessage.outputStreamWrite((OutputStream)outputStream);
                    long endTime = System.currentTimeMillis();
                    weixinMessage.info(JSON.toJSONString((Object)new MessageListenerResultVo(eventMessage, xmlMessage, startTime, endTime)));
                } else {
                    this.outputStreamWrite((OutputStream)outputStream, "success");
                }
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("", (Throwable)e);
        }
        this.outputStreamWrite((OutputStream)outputStream, "success");
    }

    @RequestMapping(value={"/jsapihandler"})
    @ResponseBody
    public BaseJsonVo jsapihandler(HttpServletRequest request, HttpServletResponse response, String url) throws AuthorizeException {
        int platFormId = this.customerLoginService.getPlatFormId();
        WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseInterface.getWeixinBaseByFlatformId(Integer.valueOf(platFormId));
        long timestamp = System.currentTimeMillis() / 1000L;
        String nonceStr = UUID.randomUUID().toString();
        String signature = JsUtil.generateConfigSignature((String)nonceStr, (String)weiXinBaseEntity.getJsapiTicket(), (String)(timestamp + ""), (String)url);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("debug", "false");
        map.put("appId", weiXinBaseEntity.getAppid());
        map.put("timestamp", timestamp);
        map.put("nonceStr", nonceStr);
        map.put("signature", signature);
        return BaseJsonVo.success(map);
    }

    private boolean outputStreamWrite(OutputStream outputStream, String text) {
        try {
            outputStream.write(text.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @RequestMapping(value={"/pushOrder14DayMessage"})
    @ResponseBody
    public void pushOrder14DayMessage() {
        this.customMessageInterface.pushOrder14DayMessage(1, 39, 14);
    }

    @RequestMapping(value={"/getAccessToken"})
    @ResponseBody
    public BaseJsonVo<WeiXinBaseEntity> getAccessToken(int platformId) {
        return BaseJsonVo.success((Object)this.weiXinBaseInterface.getWeixinBaseByFlatformId(Integer.valueOf(platformId)));
    }

    @RequestMapping(value={"/getWeixinBaseByFlatformId"})
    @ResponseBody
    public void getWeixinBaseByFlatformId() {
        this.weiXinBaseInterface.getWeixinBaseByFlatformId(Integer.valueOf(4));
    }
}

